/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.struts2;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.plugins.frameworks.struts2.g;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.reflection.a;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.Method;

@Singleton
@DontObfuscate
public final class ContrastStruts2RouteDispatcherImpl
implements ContrastStruts2RouteDispatcher {
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final RouteObservationProcessor routeObservationProcessor;
    private final e config;
    private static final String DEFAULT_METHOD_NAME = "execute";
    private static final Logger logger = LoggerFactory.getLogger(ContrastStruts2RouteDispatcherImpl.class);

    public ContrastStruts2RouteDispatcherImpl(ApplicationManager applicationManager, HttpManager httpManager, RouteObservationProcessor routeObservationProcessor, e e2) {
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.routeObservationProcessor = routeObservationProcessor;
        this.config = e2;
    }

    public void onRoutesDiscovered(String string, Object object) {
        if (string == null || object == null) {
            logger.error("ContextPath or Struts2 dispatcher were null");
            return;
        }
        Application application = this.applicationManager.findByKey(string);
        if (application == null) {
            application = this.applicationManager.current();
        }
        if (application == null) {
            logger.debug("Application not found, cannot proceed with route discovery");
            return;
        }
        application.addDiscoveredRoutes(g.a(object, this.config.getBoolean(ConfigProperty.ROUTE_COVERAGE_FILTERS_ENABLED)));
    }

    public void onRoutesObserved(Object object, Object object2) {
        Object object3;
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        if (httpRequest == null) {
            return;
        }
        g.b b2 = g.b.a(object);
        if (b2 == null) {
            return;
        }
        Method method = a.a(object2.getClass(), "getName", new Class[0]);
        String string = (String)g.a(method, object2, new Object[0]);
        if (string == null) {
            return;
        }
        Method method2 = a.a(object2.getClass(), "getNamespace", new Class[0]);
        String string2 = (String)g.a(method2, object2, new Object[0]);
        if (string2 == null) {
            return;
        }
        Method method3 = a.a(b2.a().getClass(), "getRuntimeConfiguration", new Class[0]);
        Object object4 = g.a(method3, b2.a(), new Object[0]);
        if (object4 == null) {
            return;
        }
        Method method4 = a.a(object4.getClass(), "getActionConfig", String.class, String.class);
        Object object5 = g.a(method4, object4, string2, string);
        if (object5 == null) {
            return;
        }
        String string3 = g.a(object5);
        if (string3 == null) {
            return;
        }
        String string4 = g.a(b2.b(), string3);
        if (string4 == null) {
            return;
        }
        Method method5 = a.a(object2.getClass(), "getMethod", new Class[0]);
        String string5 = (String)g.a(method5, object2, new Object[0]);
        if (string5 == null) {
            object3 = a.a(object5.getClass(), "getMethodName", new Class[0]);
            string5 = (String)g.a((Method)object3, object5, new Object[0]);
        }
        if (string5 == null) {
            string5 = DEFAULT_METHOD_NAME;
        }
        if (StringUtils.isBlank(string4) || StringUtils.isBlank(string)) {
            return;
        }
        object3 = string4 + "." + string5 + "()";
        String string6 = this.extractTemplate(object4, string, "/".equals(string2) ? "" : string2);
        this.routeObservationProcessor.onRouteStart((String)object3, string6, httpRequest);
    }

    private String extractTemplate(Object object, String string, String string2) {
        String string3 = Reflect.reflect(object, logger).field("namespaceActionConfigMatchers").invoke("get", new Class[]{Object.class}, new Object[]{string2}).field("compiledPaths").invoke("get", new Class[]{Integer.TYPE}, new Object[]{0}).field("original").asString();
        if (!string3.isEmpty()) {
            return string3;
        }
        return string2 + "/" + string;
    }

    public void onEnterInterceptorRouteObserved(Object object, String string) {
        if (object == null || string == null) {
            return;
        }
        this.routeObservationProcessor.onRouteStart(object.getClass().getName() + string, this.httpManager.getCurrentRequest());
    }

    public void onExitRouteObserved() {
        this.routeObservationProcessor.onRouteEnd(this.httpManager.getCurrentRequest());
    }
}

