/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.tomcat;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.reflection.a;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.util.Map;

@Singleton
@DontObfuscate
final class ContrastTomcatAssessDispatcherImpl
implements ContrastTomcatAssessDispatcher {
    private final e config;
    private final EventContext eventContext;
    static final String COYOTE_OUTPUT_STREAM = "org.apache.catalina.connector.CoyoteOutputStream";
    private static final ThreadLocal<Boolean> IN_REQUEST_RECYCLE = ThreadLocal.withInitial(() -> false);
    private static final Logger logger = LoggerFactory.getLogger(ContrastTomcatAssessDispatcherImpl.class);

    public ContrastTomcatAssessDispatcherImpl(e e2, EventContext eventContext) {
        this.config = e2;
        this.eventContext = eventContext;
    }

    @ScopedSensor
    public void onRecycleBytes(Object object) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
                scopeAggregator.leaveScope();
                return;
            }
            if (IN_REQUEST_RECYCLE.get().booleanValue()) {
                try {
                    Field field = a.b(object, "buff");
                    Object object2 = field.get(object);
                    Map<Object, Trace> map = this.eventContext.getTraceMap();
                    if (map != null) {
                        map.remove(object2);
                    }
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                    logger.error("Problem handling Tomcat's ByteChunk.recyle()", exception2);
                }
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onRecycleChars(Object object) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
                scopeAggregator.leaveScope();
                return;
            }
            if (IN_REQUEST_RECYCLE.get().booleanValue()) {
                try {
                    Field field = a.b(object, "buff");
                    Object object2 = field.get(object);
                    Map<Object, Trace> map = this.eventContext.getTraceMap();
                    if (map != null) {
                        map.remove(object2);
                    }
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                    logger.error("Problem handling Tomcat's CharChunk.recycle()", exception2);
                }
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onRecycleRequestStart() {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            IN_REQUEST_RECYCLE.set(true);
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onRecycleRequestEnd() {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            IN_REQUEST_RECYCLE.set(false);
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    public void onLoadConnectorPackage(ClassLoader classLoader) {
        try {
            classLoader.loadClass(COYOTE_OUTPUT_STREAM);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.debug("Attempted to preload the CoyoteOutputStream class to avoid accessibility issues but failed. This indicates that the current version of Tomcat is different than anticipated", classNotFoundException);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Attempted to preload the CoyoteOutputStream class to avoid accessibility issues but failed", throwable2);
        }
    }
}

