/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.deadzone.e;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;

@Singleton
@DontObfuscate
public class ObserveRootSpanManager
implements Purgeable {
    public static final long OBSERVE_CONTEXT_TTL_MS = 15000L;
    private final Clock clock;
    private final ApplicationManager applicationManager;
    private final com.contrastsecurity.agent.config.e config;
    private final e deadzoneManager;

    public ObserveRootSpanManager(Clock clock, ApplicationManager applicationManager, com.contrastsecurity.agent.config.e e2, e e3) {
        this.clock = clock;
        this.applicationManager = applicationManager;
        this.config = e2;
        this.deadzoneManager = e3;
    }

    public RootSpan createNewRootSpan(HttpRequest httpRequest) {
        Application application = this.applicationManager.current();
        if (application == null) {
            return null;
        }
        RootSpan rootSpan = new RootSpan(application.otel().b(), this.clock, httpRequest, this.config, this.deadzoneManager, this.applicationManager.current().otel().a());
        ContrastContext.current().observe(rootSpan);
        return rootSpan;
    }

    public RootSpan currentRootSpan() {
        return ContrastContext.current().observe();
    }

    public void currentRootSpan(RootSpan rootSpan) {
        ContrastContext.current().observe(rootSpan);
    }

    @Override
    public void purgeStale() {
        if (this.isStale(this.currentRootSpan())) {
            this.currentRootSpan(null);
        }
    }

    @Override
    public int purgeableCount() {
        return this.isStale(this.currentRootSpan()) ? 1 : 0;
    }

    private boolean isStale(RootSpan rootSpan) {
        if (rootSpan == null) {
            return false;
        }
        return this.clock.now() - rootSpan.getStartTimeMs() > 15000L;
    }
}

