/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.cmd_execution;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.e;
import com.contrastsecurity.agent.plugins.observe.semconv.SemanticAttributes;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;

@Singleton
@DontObfuscate
public final class CmdExecutionDispatcherImpl
implements ContrastObserveCmdExecutionDispatcher {
    final com.contrastsecurity.agent.config.e config;
    final ContrastPolicyManager policyManager;
    final HttpManager httpManager;
    final ScopeProvider scopeProvider;
    final ObserveRootSpanManager rootSpanManager;
    final ApplicationManager applicationManager;
    private static final String SINK_TYPE = "host-cmd-exec";

    public CmdExecutionDispatcherImpl(com.contrastsecurity.agent.config.e e2, HttpManager httpManager, ContrastPolicyManager contrastPolicyManager, ApplicationManager applicationManager, ScopeProvider scopeProvider, ObserveRootSpanManager observeRootSpanManager) {
        this.config = e2;
        this.policyManager = contrastPolicyManager;
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.scopeProvider = scopeProvider;
        this.rootSpanManager = observeRootSpanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onActionStart(String string, String[] stringArray) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ScopeAggregator scopeAggregator = e.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return null;
        }
        Application application = this.applicationManager.current();
        if (application == null) {
            return null;
        }
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        try {
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan == null || !rootSpan.isRecording()) {
                Object var7_6 = null;
                return var7_6;
            }
            Span span = rootSpan.startChildSpan(SINK_TYPE, string);
            if (span != null) {
                span.setAttribute(SemanticAttributes.CMD, String.join((CharSequence)" ", stringArray));
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    public void onActionEnd(Object object) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        e.a(object, this.scopeProvider, this.rootSpanManager.currentRootSpan(), this.applicationManager.current(), SINK_TYPE);
    }
}

