/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.file;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.e;
import com.contrastsecurity.agent.plugins.observe.semconv.SemanticAttributes;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.com.contrastsecurity.secobs.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;

@Singleton
@DontObfuscate
public final class FileOpenCreateDispatcherImpl
implements ContrastObserveFileOpenCreateDispatcher {
    final com.contrastsecurity.agent.config.e config;
    final ContrastPolicyManager policyManager;
    final HttpManager httpManager;
    final ApplicationManager applicationManager;
    final ScopeProvider scopeProvider;
    final ObserveRootSpanManager rootSpanManager;
    final com.contrastsecurity.agent.plugins.observe.deadzone.e deadzoneManager;
    private static final String SINK_TYPE = "file-open-create";
    private static final String FILE_OPEN_PATH = "file.open.path";
    private static final Logger logger = LoggerFactory.getLogger(FileOpenCreateDispatcherImpl.class);

    public FileOpenCreateDispatcherImpl(com.contrastsecurity.agent.config.e e2, HttpManager httpManager, ApplicationManager applicationManager, ContrastPolicyManager contrastPolicyManager, ScopeProvider scopeProvider, ObserveRootSpanManager observeRootSpanManager, com.contrastsecurity.agent.plugins.observe.deadzone.e e3) {
        this.config = e2;
        this.policyManager = contrastPolicyManager;
        this.httpManager = httpManager;
        this.applicationManager = applicationManager;
        this.scopeProvider = scopeProvider;
        this.rootSpanManager = observeRootSpanManager;
        this.deadzoneManager = e3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object string(String string, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ScopeAggregator scopeAggregator = e.a(this.scopeProvider, this.httpManager);
        if (scopeAggregator == null) {
            return null;
        }
        try {
            if (FileOpenCreateDispatcherImpl.shouldIgnore(string2)) {
                Object var5_4 = null;
                return var5_4;
            }
            Span span = this.onFileAccess(string);
            if (span != null) {
                span.setAttribute(FILE_OPEN_PATH, string2);
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object uri(String string, URI uRI) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ScopeAggregator scopeAggregator = e.a(this.scopeProvider, this.httpManager);
        if (scopeAggregator == null) {
            return null;
        }
        try {
            String string2 = uRI.getPath();
            if (FileOpenCreateDispatcherImpl.shouldIgnore(string2)) {
                Object var6_5 = null;
                return var6_5;
            }
            Span span = this.onFileAccess(string);
            if (span != null) {
                span.setAttribute(FILE_OPEN_PATH, string2);
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    public void onFileReturnObserved(File file, String string) {
        String string2;
        if (file == null) {
            return;
        }
        try {
            string2 = file.getPath();
        }
        catch (NullPointerException nullPointerException) {
            logger.debug("Encountered an NPE attempting to get the path of a file", nullPointerException);
            return;
        }
        this.startAndStopFileSpan(string2, string);
    }

    public void onPathObserved(Path path, String string) {
        String string2;
        if (path == null) {
            return;
        }
        try {
            string2 = path.toString();
        }
        catch (NullPointerException nullPointerException) {
            logger.debug("Encountered an NPE attempting to get the path of a file", nullPointerException);
            return;
        }
        this.startAndStopFileSpan(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndStopFileSpan(String string, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ScopeAggregator scopeAggregator = e.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return;
        }
        try {
            if (FileOpenCreateDispatcherImpl.shouldIgnore(string)) {
                return;
            }
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan == null || !rootSpan.isRecording()) {
                return;
            }
            Application application = this.applicationManager.current();
            if (application == null) {
                return;
            }
            Span span = FileOpenCreateDispatcherImpl.onFileAccess(rootSpan, string2);
            if (span == null) {
                return;
            }
            span.setAttribute(SemanticAttributes.FILE_OPEN_PATH, string);
            span.end();
            rootSpan.popContext();
            application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, SINK_TYPE, ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    public void onActionEnd(Object object) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        e.a(object, this.scopeProvider, this.rootSpanManager.currentRootSpan(), this.applicationManager.current(), SINK_TYPE);
    }

    private Span onFileAccess(String string) {
        return FileOpenCreateDispatcherImpl.onFileAccess(this.rootSpanManager.currentRootSpan(), string);
    }

    private static Span onFileAccess(RootSpan rootSpan, String string) {
        return rootSpan != null && rootSpan.isRecording() ? rootSpan.startChildSpan(SINK_TYPE, string) : null;
    }

    private static boolean shouldIgnore(String string) {
        return string == null || string.isEmpty() || string.endsWith(".class") || string.endsWith(".jar") || string.endsWith(".war") || string.endsWith(".ear") || string.endsWith(".css");
    }
}

