/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.serverside;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.e;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.semconv.SemanticAttributes;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;

@Singleton
@DontObfuscate
public final class ServerSideRequestDispatcherImpl
implements ContrastObserveServerSideRequestDispatcher {
    final com.contrastsecurity.agent.config.e config;
    final ContrastPolicyManager policyManager;
    final HttpManager httpManager;
    final ScopeProvider scopeProvider;
    final ObserveRootSpanManager rootSpanManager;
    final ApplicationManager applicationManager;
    private static final Set<String> EXCLUDED_PROTOCOLS = Sets.of("file", "jar", "jrt", "war", "ear");
    private static final String SINK_TYPE = "outbound-service-call";

    ServerSideRequestDispatcherImpl(com.contrastsecurity.agent.config.e e2, HttpManager httpManager, ContrastPolicyManager contrastPolicyManager, ApplicationManager applicationManager, ScopeProvider scopeProvider, ObserveRootSpanManager observeRootSpanManager) {
        this.config = e2;
        this.policyManager = contrastPolicyManager;
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.scopeProvider = scopeProvider;
        this.rootSpanManager = observeRootSpanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onTraceStart(String string, Object object) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ScopeAggregator scopeAggregator = e.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return null;
        }
        Application application = this.applicationManager.current();
        if (application == null) {
            return null;
        }
        try {
            if (!(object instanceof URLConnection)) {
                Object var6_5 = null;
                return var6_5;
            }
            URL uRL = ((URLConnection)object).getURL();
            String string2 = uRL.getHost();
            int n2 = uRL.getPort();
            String string3 = uRL.getProtocol();
            if (string3 != null && EXCLUDED_PROTOCOLS.contains(string3.toLowerCase())) {
                Object var10_10 = null;
                return var10_10;
            }
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan == null) {
                Object var11_12 = null;
                return var11_12;
            }
            Span span = rootSpan.startChildSpan(SINK_TYPE, string);
            if (span == null) {
                Object var12_14 = null;
                return var12_14;
            }
            if (string2 != null) {
                span.setAttribute(SemanticAttributes.SERVER_ADDRESS, string2);
                if (n2 >= 0) {
                    span.setAttribute(SemanticAttributes.SERVER_PORT, n2);
                }
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    public void onActionEnd(Object object) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        e.a(object, this.scopeProvider, this.rootSpanManager.currentRootSpan(), this.applicationManager.current(), SINK_TYPE);
    }
}

