/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.sql;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.plugins.frameworks.sql.DbInfo;
import com.contrastsecurity.agent.plugins.frameworks.sql.SqlDatabaseInfoCache;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.e;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.semconv.SemanticAttributes;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

@Singleton
@DontObfuscate
public final class SqlExecutionDispatcherImpl
implements ContrastObserveSqlExecutionDispatcher {
    private final SqlDatabaseInfoCache sqlDatabaseInfoCache;
    private final ApplicationManager applicationManager;
    private final ScopeProvider scopeProvider;
    private final com.contrastsecurity.agent.config.e config;
    private static final Logger logger = LoggerFactory.getLogger(SqlExecutionDispatcherImpl.class);
    private static final String SINK_TYPE = "storage-query";

    public SqlExecutionDispatcherImpl(SqlDatabaseInfoCache sqlDatabaseInfoCache, ApplicationManager applicationManager, ScopeProvider scopeProvider, com.contrastsecurity.agent.config.e e2) {
        this.sqlDatabaseInfoCache = sqlDatabaseInfoCache;
        this.applicationManager = applicationManager;
        this.scopeProvider = scopeProvider;
        this.config = e2;
    }

    public void enterScope(Object object) {
        if (!(object instanceof ContrastContext)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null) {
            return;
        }
        rootSpan.getSqlScope().enterScope();
    }

    public void leaveScope(Object object) {
        if (!(object instanceof ContrastContext)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null) {
            return;
        }
        rootSpan.getSqlScope().leaveScope();
    }

    public boolean inScope(Object object) {
        if (!(object instanceof ContrastContext)) {
            return false;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        return rootSpan != null && rootSpan.getSqlScope().inScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onExecuteStart(Object object, String string, Object object2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        if (!(object instanceof ContrastContext)) {
            return null;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return null;
        }
        ScopeAggregator scopeAggregator = e.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return null;
        }
        try {
            Span span = rootSpan.startChildSpan(SINK_TYPE, string);
            this.addSpanAttributes(span, object2);
            Span span2 = span;
            return span2;
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    private void addSpanAttributes(Span span, Object object) {
        if (span == null) {
            return;
        }
        try {
            Connection connection = ((Statement)object).getConnection();
            if (connection == null) {
                logger.debug("Got null connection from statement of type {}", (Object)object.getClass());
                return;
            }
            DbInfo dbInfo = this.sqlDatabaseInfoCache.get(connection);
            if (dbInfo == null) {
                logger.debug("Could not get database info for connection of type {}", (Object)connection.getClass());
                return;
            }
            if (dbInfo.name() != null) {
                span.setAttribute(SemanticAttributes.DB_NAME, dbInfo.name());
            } else if (dbInfo.db() != null) {
                span.setAttribute(SemanticAttributes.DB_NAME, dbInfo.db());
            }
            if (dbInfo.system() != null) {
                span.setAttribute(SemanticAttributes.DB_SYSTEM, dbInfo.system());
            }
            if (dbInfo.user() != null) {
                span.setAttribute(SemanticAttributes.DB_USER, dbInfo.user());
            }
            if (dbInfo.host() != null) {
                span.setAttribute(SemanticAttributes.SERVER_ADDRESS, dbInfo.host());
                if (dbInfo.port() != null) {
                    span.setAttribute(SemanticAttributes.SERVER_PORT, dbInfo.port());
                }
            }
        }
        catch (SQLException sQLException) {
            logger.debug("Unable to add span attributes because of SQL error", sQLException);
        }
    }

    public void onActionEnd(Object object, Object object2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        if (!(object instanceof ContrastContext)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null) {
            return;
        }
        e.a(object2, this.scopeProvider, rootSpan, this.applicationManager.current(), SINK_TYPE);
    }
}

