/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.route;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceDTM;
import com.contrastsecurity.agent.messages.mq.EventType;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.plugins.route.d;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@Singleton
@DontObfuscate
public final class RouteObservationProcessorImpl
implements RouteObservationProcessor {
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final ObserveRootSpanManager observeRootSpanManager;
    private final e config;
    private final com.contrastsecurity.agent.services.a.d<ObservedRoute> reporter;
    private final com.contrastsecurity.agent.n.e publisher;
    private final Clock clock;
    private final long duplicateWindowTimeNS;
    private final Counter observedRouteMapFullCounter;
    private final Semaphore maxRoutesSemaphore;
    private final ConcurrentHashMap<Integer, Long> routeTimestampMap;
    @n
    static final ExecutionContext.b<Deque> OUTER_OBSERVED_ROUTES = ExecutionContext.b.a(Deque.class);
    @n
    static final ExecutionContext.b<Set> SOURCES = ExecutionContext.b.a(Set.class);
    @n
    static final String COUNTER_ANALYSIS_OBSERVED_ROUTE_MAP_FULL = "observedRouteMapFullCount";
    private static final Logger logger = LoggerFactory.getLogger(RouteObservationProcessorImpl.class);

    public RouteObservationProcessorImpl(e e2, ApplicationManager applicationManager, HttpManager httpManager, ObserveRootSpanManager observeRootSpanManager, com.contrastsecurity.agent.services.a.d<ObservedRoute> d2, com.contrastsecurity.agent.n.e e3, Clock clock, TelemetryMetrics telemetryMetrics) {
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.observeRootSpanManager = observeRootSpanManager;
        this.config = e2;
        this.reporter = d2;
        this.publisher = e3;
        this.clock = clock;
        int n2 = e2.getInt(ConfigProperty.ROUTE_OBSERVATION_MAP_DEDUPLICATION_SIZE);
        this.duplicateWindowTimeNS = TimeUnit.MILLISECONDS.toNanos(e2.getLong(ConfigProperty.ROUTE_OBSERVATION_DEDUPLICATION_TIME));
        this.maxRoutesSemaphore = new Semaphore(n2);
        this.routeTimestampMap = new ConcurrentHashMap(n2);
        this.observedRouteMapFullCounter = telemetryMetrics.newCounter(COUNTER_ANALYSIS_OBSERVED_ROUTE_MAP_FULL, TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("The number of times the Observed Route deduplication map was full").register();
    }

    @Override
    public void onSourceEventsFound(Set<EventSourceDTM> set) {
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        if (httpRequest == null) {
            return;
        }
        Set set2 = httpRequest.context().getOrComputeIfAbsent(SOURCES, CopyOnWriteArraySet::new);
        set2.addAll(set);
    }

    @Override
    public void onRouteStart(String string, String string2, HttpRequest httpRequest) {
        RootSpan rootSpan;
        Object object;
        Object object2;
        if (string == null || httpRequest == null || httpRequest.getMethod() == null) {
            logger.debug("Verb, signature or request was null, which are required for route observation: {}", (Object)httpRequest);
            return;
        }
        String string3 = httpRequest.getPath();
        if (string3 == null) {
            logger.debug("Path was null, which is required for route observation: {}", (Object)httpRequest);
            return;
        }
        RequestMethod requestMethod = httpRequest.getMethod();
        if (requestMethod.isUnknownHeader()) {
            logger.debug("Request method was {}, which is unknown, cannot perform route observation: {}", (Object)requestMethod, (Object)httpRequest);
            return;
        }
        Application application = this.applicationManager.current();
        if (application == null || application.getSessionId() == null) {
            if (logger.isDebugEnabled()) {
                String string4 = application == null ? "null" : application.getSessionId();
                logger.debug("Unable to find application or session id for route observation. Request: {}, Application: {}, SessionId: {}", httpRequest, application, string4);
            }
            return;
        }
        ObservedRoute.Builder builder = ObservedRoute.builder().signature(string).sessionId(application.getSessionId()).url(string3).requestMethod(requestMethod).template(string2);
        Map map = application.context().get(Application.DISCOVERED_ROUTES_KEY);
        if (map != null && (object2 = (d)map.get(string)) != null) {
            object2.a().forEach(builder::addMapping);
            if (!StringUtils.isEmpty(string2)) {
                object = object2.a(string2);
                builder.template((String)object);
            } else if (string2 == null && object2.a().size() == 1) {
                builder.template(object2.a().iterator().next());
            }
        }
        if ((object2 = this.addSourcesToObservedRoute((ObservedRoute)httpRequest.context().get(CURRENT_OBSERVED_ROUTE))) != null) {
            httpRequest.context().getOrComputeIfAbsent(OUTER_OBSERVED_ROUTES, ArrayDeque::new).push(object2);
        }
        object = builder.build();
        httpRequest.context().put(CURRENT_OBSERVED_ROUTE, object);
        httpRequest.setTemplate(((ObservedRoute)object).template());
        if (this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE) && (rootSpan = this.observeRootSpanManager.currentRootSpan()) != null && !rootSpan.isRecording()) {
            rootSpan.startRecording();
        }
    }

    @Override
    public void onRouteStart(String string, HttpRequest httpRequest) {
        this.onRouteStart(string, httpRequest.getTemplate(), httpRequest);
    }

    private ObservedRoute addSourcesToObservedRoute(ObservedRoute observedRoute) {
        if (observedRoute == null) {
            return null;
        }
        Set set = this.httpManager.getCurrentRequest().context().get(SOURCES);
        if (set != null && !set.isEmpty()) {
            ObservedRoute.Builder builder = observedRoute.toBuilder();
            for (Object e2 : set) {
                builder.addSource((EventSourceDTM)e2);
            }
            set.clear();
            return builder.build();
        }
        return observedRoute;
    }

    @Override
    public void onRouteEnd(HttpRequest httpRequest) {
        Deque deque;
        if (httpRequest == null) {
            logger.debug("Request was null");
            return;
        }
        Application application = this.applicationManager.current();
        if (application == null) {
            logger.debug("No application was found");
            return;
        }
        ObservedRoute observedRoute = this.addSourcesToObservedRoute((ObservedRoute)httpRequest.context().remove(CURRENT_OBSERVED_ROUTE));
        if (observedRoute == null) {
            logger.debug("No observed routes were found");
            return;
        }
        this.publisher.a(EventType.OBSERVED_ROUTE_EVENT, observedRoute);
        if (!this.isDuplicate(observedRoute)) {
            this.reporter.a(application, observedRoute);
        }
        if ((deque = httpRequest.context().get(OUTER_OBSERVED_ROUTES)) != null && !deque.isEmpty()) {
            httpRequest.context().put(CURRENT_OBSERVED_ROUTE, (ObservedRoute)deque.pop());
        }
    }

    @Override
    public void onRequestEnd(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.onRouteEnd(httpRequest);
    }

    @Override
    public boolean doesCurrentRouteHaveSignature(String string) {
        if (string == null) {
            return false;
        }
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        if (httpRequest == null) {
            return false;
        }
        ObservedRoute observedRoute = (ObservedRoute)httpRequest.context().get(CURRENT_OBSERVED_ROUTE);
        return observedRoute != null && string.equals(observedRoute.signature());
    }

    @n
    boolean isDuplicate(ObservedRoute observedRoute) {
        if (this.duplicateWindowTimeNS <= 0L) {
            return false;
        }
        long l2 = this.clock.nanoTime();
        Long l4 = this.routeTimestampMap.compute(observedRoute.hashForReporting(), (n2, l3) -> {
            boolean bl2;
            if (l3 == null) {
                if (!this.maxRoutesSemaphore.tryAcquire()) {
                    this.observedRouteMapFullCounter.increment();
                    return null;
                }
                return l2;
            }
            boolean bl3 = bl2 = l2 - l3 > this.duplicateWindowTimeNS;
            if (bl2) {
                this.maxRoutesSemaphore.release();
                return null;
            }
            return l3;
        });
        return l4 != null && l4 != l2;
    }
}

