/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.route;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceDTM;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.test.integration.IntegrationTestServices;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

@Singleton
@DontObfuscate
public final class TestObservationProcessor
implements RouteObservationProcessor {
    private final HttpManager httpManager;
    private static final ExecutionContext.b<Set> SOURCES = ExecutionContext.b.a(Set.class);
    private static final ExecutionContext.b<ObservedRoute.Builder> OBSERVED_ROUTE_KEY = ExecutionContext.b.a(ObservedRoute.Builder.class);

    public TestObservationProcessor(HttpManager httpManager) {
        this.httpManager = httpManager;
    }

    @Override
    public void onRouteStart(String string, HttpRequest httpRequest) {
        this.onRouteStart(string, null, httpRequest);
    }

    @Override
    public void onRouteStart(String string, String string2, HttpRequest httpRequest) {
        ObservedRoute.Builder builder = ObservedRoute.builder().sessionId("integration-test-session-id").signature(string).url(httpRequest.getPath()).requestMethod(httpRequest.getMethod());
        this.addSourcesToObservedRoute(builder);
        httpRequest.context().put(OBSERVED_ROUTE_KEY, builder);
    }

    @Override
    public void onRouteEnd(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return;
        }
        ObservedRoute.Builder builder = httpRequest.context().get(OBSERVED_ROUTE_KEY);
        if (builder == null) {
            return;
        }
        this.addSourcesToObservedRoute(builder);
        IntegrationTestServices.getInstance().addObservedRoute(builder.build());
    }

    @Override
    public void onRequestEnd(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.onRouteEnd(httpRequest);
    }

    @Override
    public void onSourceEventsFound(Set<EventSourceDTM> set) {
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        if (httpRequest == null) {
            return;
        }
        httpRequest.context().getOrComputeIfAbsent(SOURCES, CopyOnWriteArraySet::new).addAll(set);
    }

    private void addSourcesToObservedRoute(ObservedRoute.Builder builder) {
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        if (httpRequest == null) {
            return;
        }
        Set set = httpRequest.context().get(SOURCES);
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Object e2 : set) {
            builder.addSource((EventSourceDTM)e2);
        }
        set.clear();
    }

    @Override
    public boolean doesCurrentRouteHaveSignature(String string) {
        return false;
    }
}

