/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.apps.exclusions.g;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.security.controller.i;
import com.contrastsecurity.agent.plugins.security.controller.trigger.m;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public class AssessSourceExclusionHandler
implements m {
    private final HttpManager httpManager;
    private static final Logger logger = LoggerFactory.getLogger(AssessSourceExclusionHandler.class);

    public AssessSourceExclusionHandler(HttpManager httpManager) {
        this.httpManager = httpManager;
    }

    @Override
    public boolean onTraceTriggered(Application application, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, i i2) {
        List<CodeEvent> list = trace.getEvents();
        boolean bl2 = true;
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        g g2 = application.getExclusionProcessor();
        for (int i3 = 0; i3 < list.size() && bl2; ++i3) {
            CodeEvent codeEvent = list.get(i3);
            if (!(codeEvent instanceof SourceEvent)) continue;
            bl2 = !this.isSourceExclusion(trace, rule, (SourceEvent)codeEvent, httpRequest, g2);
        }
        return bl2;
    }

    @n
    boolean isSourceExclusion(Trace trace, Rule rule, SourceEvent sourceEvent, HttpRequest httpRequest, g g2) {
        if (g2 == null) {
            logger.debug("Skipping exclusion processing: exclusion processor is null");
            return false;
        }
        String string = rule.getId();
        SourceNode sourceNode = sourceEvent.getSource();
        if (!sourceNode.hasSourceTypes()) {
            logger.debug("Skipping exclusion processing: untrusted data source [{}] does not have a processable type", (Object)sourceNode.getId());
            return false;
        }
        if (sourceEvent.getQueue() != null && (sourceNode.isSourceType(u.u) || sourceNode.isSourceType(u.v) || sourceNode.isSourceType(u.w) || sourceNode.isSourceType(u.x))) {
            return g2.isQueueExclusion(c.a.a, string, sourceEvent.getQueue());
        }
        if (httpRequest == null) {
            logger.debug("Skipping exclusion processing: request model is null");
            return false;
        }
        if (sourceNode.isSourceType(u.g)) {
            String string2 = this.extractInputName(trace, sourceEvent, sourceNode);
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.PARAMETER, string2);
        }
        if (sourceNode.isSourceType(u.d)) {
            String string3 = this.extractInputName(trace, sourceEvent, sourceNode);
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, string3);
        }
        if (sourceNode.isSourceType(u.h)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.QUERYSTRING);
        }
        if (sourceNode.isSourceType(u.c)) {
            String string4 = sourceEvent.getFieldName();
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.COOKIE, string4);
        }
        if (sourceNode.isSourceType(u.a) || sourceNode.isSourceType(u.f)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.BODY);
        }
        if (sourceNode.isSourceType(u.t)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, "authorization");
        }
        return false;
    }

    private String extractInputName(Trace trace, SourceEvent sourceEvent, SourceNode sourceNode) {
        String string = null;
        if (sourceEvent != null) {
            string = sourceEvent.getFieldName();
        }
        if (sourceEvent != null && string == null) {
            String string2;
            int n2;
            if (sourceNode != null && sourceNode.isSourceType(u.q)) {
                if (sourceEvent.getParameters() != null && sourceEvent.getParameters().length > 0) {
                    string = sourceEvent.getParameters()[0].b();
                }
            } else if (sourceNode != null && sourceNode.isSourceType(u.p) && trace != null && trace.getEvents() != null && !trace.getEvents().isEmpty() && (n2 = trace.getEvents().indexOf(sourceEvent)) >= 0 && trace.getEvents().size() > n2 && (string2 = trace.getEvents().get(n2 + 1).getRet()) != null && !string2.isEmpty()) {
                string = string2;
            }
        }
        return string;
    }
}

