/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.f;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.services.ngreporting.o;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.TraceEvent;
import com.contrastsecurity.agent.trace.d;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Map;

@Singleton
@DontObfuscate
public class ProviderUtil {
    private final e config;
    private final com.contrastsecurity.agent.services.ngreporting.e legacyReportingService;
    private final Finding.d findingFactory;
    private final d traceFactory;
    private final f disabledRulesFilter;
    private final AssessmentManager assessmentManager;
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final ContrastPolicyManager policyManager;
    private static final Logger logger = LoggerFactory.getLogger(ProviderUtil.class);

    public ProviderUtil(e e2, AssessmentManager assessmentManager, ApplicationManager applicationManager, Finding.d d2, HttpManager httpManager, com.contrastsecurity.agent.services.ngreporting.e e3, d d3, ContrastPolicyManager contrastPolicyManager, f f2) {
        this.assessmentManager = assessmentManager;
        this.applicationManager = applicationManager;
        this.policyManager = contrastPolicyManager;
        this.config = e2;
        this.findingFactory = d2;
        this.httpManager = httpManager;
        this.legacyReportingService = e3;
        this.traceFactory = d3;
        this.disabledRulesFilter = f2;
    }

    public void reportFinding(String string, String string2, long l2) {
        this.reportFinding(string, string2, l2, null, true, null);
    }

    public void reportFinding(String string, Map<PropertyKey, String> map, long l2) {
        this.reportFinding(string, null, l2, map, true, null);
    }

    public void reportFinding(String string, String string2, long l2, Map<PropertyKey, String> map) {
        this.reportFinding(string, string2, l2, map, true, null);
    }

    public void reportFinding(String string, Map<PropertyKey, String> map, long l2, boolean bl2) {
        this.reportFinding(string, null, l2, map, bl2, null);
    }

    public void reportFinding(String string, String string2, long l2, Map<PropertyKey, String> map, boolean bl2, o o2) {
        Application application = this.applicationManager.current();
        this.reportFinding(application, string, string2, l2, map, bl2, o2);
    }

    public void reportFinding(Application application, String string, String string2, long l2, Map<PropertyKey, String> map, boolean bl2, o o2) {
        if (application == null) {
            logger.debug("Unable to send report, app == NULL");
            return;
        }
        if (this.disabledRulesFilter.a(application).test(string)) {
            logger.debug("Suppressed finding in {} for the disabled rule {}", (Object)application, (Object)string);
            return;
        }
        Trace trace = this.traceFactory.a();
        trace.setEvidence(string2);
        trace.setRuleId(string);
        ContrastPolicy contrastPolicy = this.policyManager.currentPolicy();
        if (contrastPolicy == null) {
            return;
        }
        Rule rule = contrastPolicy.getRuleById(string);
        if (rule == null) {
            return;
        }
        Finding finding = this.findingFactory.a(application, string, trace, l2);
        if (bl2) {
            finding.setRequest(this.httpManager.getCurrentRequest());
        }
        finding.setProperties(map);
        logger.info("Added finding for rule ID: {} (hash={})", (Object)string, (Object)l2);
        TraceEvent traceEvent = new TraceEvent(trace);
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        if (assessmentContext != null) {
            assessmentContext.onFindingOccurred(string, l2);
        }
        finding.setListener(o2);
        this.legacyReportingService.a(finding);
    }
}

