/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.autobinding;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.plugins.security.k;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import java.util.EnumMap;

@Singleton
@DontObfuscate
public final class ContrastSpringAutoBindingDispatcherImpl
implements ContrastSpringAutoBindingDispatcher {
    private final HttpManager httpManager;
    private final ProviderUtil providerUtil;
    private final k.b configurationHasher;
    private static final String RULE = "spring-unchecked-autobinding";

    public ContrastSpringAutoBindingDispatcherImpl(HttpManager httpManager, ProviderUtil providerUtil, k k2) {
        this.httpManager = httpManager;
        this.providerUtil = providerUtil;
        this.configurationHasher = k2.a();
    }

    @ScopedSensor
    public void onDoBind(Object object, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            boolean bl2;
            if (object == null) {
                scopeAggregator.leaveScope();
                return;
            }
            boolean bl3 = stringArray == null || stringArray.length == 0;
            boolean bl4 = stringArray2 == null || stringArray2.length == 0;
            boolean bl5 = bl2 = stringArray3 == null || stringArray3.length == 0;
            if (bl3 && bl4 && bl2) {
                this.reportVulnerability(object.getClass().getName());
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    private void reportVulnerability(String string) {
        long l2 = this.configurationHasher.a(RULE, this.httpManager.getCurrentRequest(), string);
        EnumMap<PropertyKey, String> enumMap = new EnumMap<PropertyKey, String>(PropertyKey.class);
        enumMap.put(PropertyKey.FILE, string);
        this.providerUtil.reportFinding(RULE, string, l2, enumMap);
    }
}

