/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf;

import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.contrastapi_v1_0.StandardRequestMethod;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.security.k;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.HttpWatcher;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.a;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.c;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.d;
import com.contrastsecurity.agent.util.J;
import com.contrastsecurity.agent.util.SimplePattern;
import com.contrastsecurity.agent.util.q;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.http.HeaderElement;
import com.contrastsecurity.thirdparty.org.apache.http.ParseException;
import com.contrastsecurity.thirdparty.org.apache.http.message.BasicHeaderValueParser;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

public class e
implements HttpWatcher {
    private boolean a = false;
    private final d.a b;
    private final List<SimplePattern> c;
    private final ProviderUtil d;
    private final k.e e;
    private static final Collection<RequestMethod> f = Sets.of(StandardRequestMethod.GET, StandardRequestMethod.POST);
    private static final Set<String> g = Sets.of("text/plain", "multipart/form-data", "application/x-www-form-urlencoded");
    private static final int h = 8;
    private static final int i = 24;
    private static final Logger j = LoggerFactory.getLogger(e.class);

    public e(c c2, ProviderUtil providerUtil, k k2) {
        this.b = c2.a();
        this.c = c2.b();
        this.d = providerUtil;
        this.e = k2.g();
    }

    @Override
    public void onResponseEnd(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (!com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.d.c(httpRequest)) {
            boolean bl2 = this.a = this.a || com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.d.a(httpRequest);
        }
        if (!this.a) {
            int n2 = httpResponse.getStatus();
            if (this.a(n2)) {
                this.a = true;
                return;
            }
            if (this.c(httpRequest) && com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.a.a(httpRequest)) {
                String string = httpRequest.getNormalizedUri();
                try {
                    this.a(httpRequest);
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                    j.error("Problem reporting CSRF rule for {}", (Object)string, (Object)exception2);
                }
            }
        }
    }

    @Override
    public long getRuleRequestHash(HttpRequest httpRequest, CRC32 cRC32) {
        return this.e.a(cRC32, "csrf", httpRequest);
    }

    @n
    void a(HttpRequest httpRequest) {
        String string = com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.a.c(httpRequest);
        EnumMap<PropertyKey, String> enumMap = new EnumMap<PropertyKey, String>(PropertyKey.class);
        enumMap.put(PropertyKey.ACTIONS, string);
        long l2 = this.e.a("csrf", httpRequest);
        this.d.reportFinding("csrf", enumMap, l2, true);
    }

    boolean b(HttpRequest httpRequest) {
        return StandardRequestMethod.GET == httpRequest.getMethod() && StringUtils.isEmpty(httpRequest.getQueryString());
    }

    boolean c(HttpRequest httpRequest) {
        if (this.a(httpRequest.getHeaders())) {
            return false;
        }
        if (this.a(httpRequest.getParameters())) {
            return false;
        }
        Set<MultipartItem> set = httpRequest.getMultipartItems();
        if (set != null) {
            for (MultipartItem multipartItem : set) {
                String string;
                String string2 = multipartItem.getFieldName();
                if (J.c(string2, "csrf")) {
                    j.debug("Not considering CSRF because possible token value observed {}", (Object)string2);
                    return false;
                }
                if (!J.c(string2, "token") || !this.a(string = multipartItem.getValue())) continue;
                j.debug("Not considering CSRF because possible token value observed {}={}", (Object)string2, (Object)string);
                return false;
            }
        }
        return true;
    }

    boolean a(Map<String, String[]> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                String[] stringArray;
                if (J.c(string, "csrf")) {
                    j.debug("Not considering CSRF because possible token value observed {}", (Object)string);
                    return true;
                }
                if (!J.c(string, "token") || !this.a(stringArray = map.get(string))) continue;
                j.debug("Not considering CSRF because possible token value observed {}={}", (Object)string, (Object)stringArray[0]);
                return true;
            }
        }
        return false;
    }

    boolean a(String[] stringArray) {
        if (stringArray != null && stringArray.length == 1) {
            return this.a(stringArray[0]);
        }
        return false;
    }

    boolean a(String string) {
        if (string != null && string.length() >= 8 && string.length() <= 24) {
            return J.c(string);
        }
        return false;
    }

    boolean a(int n2) {
        return n2 >= 400;
    }

    @Override
    public boolean supports(HttpRequest httpRequest) {
        HeaderElement[] headerElementArray;
        String string = httpRequest.getHeader("X-Requested-With");
        if (!StringUtils.isEmpty(string)) {
            j.debug("Ignoring CSRFRule for {} because X-Requested-With={}", (Object)httpRequest.getUri(), (Object)string);
            this.a = true;
            return false;
        }
        String string2 = httpRequest.getHeader("User-Agent");
        if (StringUtils.isEmpty(string2)) {
            this.a = true;
            j.debug("Ignoring CSRFRule for {} because no User-Agent was supplied -- not a browser interaction", (Object)httpRequest.getUri());
            return false;
        }
        if (q.b(httpRequest)) {
            this.a = true;
            j.debug("Ignoring CSRFRule for {} because it looks like its a static resource", (Object)httpRequest.getUri());
            return false;
        }
        String string3 = httpRequest.getHeader("Content-Type");
        if (string3 != null) {
            try {
                headerElementArray = BasicHeaderValueParser.parseElements(string3, BasicHeaderValueParser.INSTANCE);
            }
            catch (ParseException parseException) {
                this.a = true;
                j.debug("Ignoring CSRFRule for {} because its content-type header is malformed value {}", httpRequest.getUri(), string3, parseException);
                return false;
            }
            if (headerElementArray.length == 0) {
                this.a = true;
                j.debug("Ignoring CSRFRule for {} because its content-type header is malformed value {}", (Object)httpRequest.getUri(), (Object)string3);
                return false;
            }
            HeaderElement headerElement = headerElementArray[0];
            String string4 = headerElement.getName();
            if (!this.c(string4)) {
                this.a = true;
                j.debug("Ignoring CSRFRule for {} because Content-Type was {}", (Object)httpRequest.getUri(), (Object)string3);
                return false;
            }
        }
        if (!this.a((RequestMethod)(headerElementArray = httpRequest.getMethod()))) {
            this.a = true;
            j.debug("Ignoring CSRFRule for {} because method was {}", (Object)httpRequest.getUri(), (Object)headerElementArray);
            return false;
        }
        if (this.b(httpRequest)) {
            this.a = true;
            j.debug("Ignoring CSRFRule for {} because method was GET and no querystring", (Object)httpRequest.getUri());
            return false;
        }
        if (d.a.a.equals((Object)this.b) && this.b(httpRequest.getNormalizedUri())) {
            this.a = true;
            j.debug("Ignoring CSRFRule for {} because URL was known idempotent", (Object)httpRequest.getNormalizedUri());
            return false;
        }
        if (d.a.b.equals((Object)this.b) && !this.b(httpRequest.getNormalizedUri())) {
            this.a = true;
            j.debug("Ignoring CSRFRule for {} because URL was not on the need-to-protect list", (Object)httpRequest.getNormalizedUri());
            return false;
        }
        return true;
    }

    boolean b(String string) {
        for (SimplePattern simplePattern : this.c) {
            if (!simplePattern.matches(string)) continue;
            return true;
        }
        return false;
    }

    private boolean a(RequestMethod requestMethod) {
        return f.contains(requestMethod);
    }

    private boolean c(String string) {
        return g.contains(string);
    }
}

