/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.scope;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.n;
import java.util.ArrayDeque;
import java.util.Deque;

@DontObfuscate
public final class ScopeAssess {
    private final Deque<String> triggerScope = new ArrayDeque<String>();
    private final Deque<String> deadzoneScope = new ArrayDeque<String>();
    private int masterScope;
    private int samplingScope;
    private int propagationScope;
    private int sourceScope;
    private int validatorScope;

    public boolean inTriggerRuleScope(String string) {
        if (this.samplingScope != 0) {
            return true;
        }
        int n2 = 0;
        for (String string2 : this.triggerScope) {
            if (!string2.equals(string) || ++n2 <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean inScope() {
        return this.masterScope != 0;
    }

    public int scope() {
        return this.masterScope;
    }

    public void setSamplingScope(int n2) {
        if (n2 >= 0) {
            this.samplingScope = n2;
        }
    }

    public void enterScope() {
        ++this.masterScope;
    }

    public void leaveScope() {
        this.masterScope = this.decrementScope(this.masterScope);
    }

    public void enterPropagationScope() {
        ++this.propagationScope;
    }

    public void leavePropagationScope() {
        this.propagationScope = this.decrementScope(this.propagationScope);
    }

    public void enterSourceScope() {
        ++this.sourceScope;
    }

    public void leaveSourceScope() {
        this.sourceScope = this.decrementScope(this.sourceScope);
    }

    public boolean isTaggingDisallowed(boolean bl2) {
        if (this.samplingScope != 0) {
            return true;
        }
        if (this.masterScope != 1) {
            return true;
        }
        return !bl2 && this.propagationScope != 0;
    }

    public void enterTriggerScope(String string) {
        this.triggerScope.push(string);
    }

    public void leaveTriggerScope(String string) {
        this.triggerScope.remove(string);
    }

    public void enterValidatorScope() {
        ++this.validatorScope;
    }

    public void leaveValidatorScope() {
        this.validatorScope = this.decrementScope(this.validatorScope);
    }

    public boolean inValidatorScope() {
        return this.validatorScope != 0;
    }

    public boolean isSourceCreationDisallowed() {
        return this.samplingScope != 0 || this.masterScope != 0 || this.sourceScope != 1;
    }

    public boolean isCloneAllowed() {
        return this.samplingScope == 0 && this.masterScope == 0;
    }

    public int getSamplingScope() {
        return this.samplingScope;
    }

    public int getPropagationScope() {
        return this.propagationScope;
    }

    public int getSourceScope() {
        return this.sourceScope;
    }

    @n
    public Deque<String> getTriggerScope() {
        return this.triggerScope;
    }

    public boolean inMasterOrSamplingScope() {
        return this.samplingScope != 0 || this.masterScope != 0;
    }

    private int decrementScope(int n2) {
        assert (n2 > 0) : "Decrementing the assess scope to negative value is not allowed";
        return Math.max(--n2, 0);
    }

    public void enterDeadzone(String string) {
        this.deadzoneScope.push(string);
    }

    public void exitDeadzone() {
        this.deadzoneScope.pop();
    }

    public boolean inDeadzone(String string) {
        return this.deadzoneScope.contains(string);
    }
}

