/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.scope;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.scope.ScopeAssess;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import java.util.Objects;

@DontObfuscate
public final class ScopeProviderAssessImpl
implements ScopeProviderAssess {
    private final ScopeProvider scopeProvider;
    private static boolean enabled;

    public ScopeProviderAssessImpl(ScopeProvider scopeProvider) {
        this.scopeProvider = Objects.requireNonNull(scopeProvider);
    }

    @Override
    public boolean inScope() {
        if (!enabled) {
            return true;
        }
        return this.scopeProvider.assess().inScope();
    }

    @Override
    public ScopeAssess enterScope() {
        ScopeAssess scopeAssess = this.scopeProvider.assess();
        scopeAssess.enterScope();
        return scopeAssess;
    }

    @Override
    public void leaveScope() {
        this.scopeProvider.assess().leaveScope();
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    @Override
    public void samplingSensorsOff() {
        this.scopeProvider.assess().setSamplingScope(1);
    }

    @Override
    public void samplingSensorsOn() {
        this.scopeProvider.assess().setSamplingScope(0);
    }

    @Override
    public void sensorsOff() {
        this.scopeProvider.assess().enterScope();
    }

    @Override
    public void sensorsOn() {
        this.scopeProvider.assess().leaveScope();
    }

    @Override
    public ScopeAssess scope() {
        return this.scopeProvider.assess();
    }

    @Override
    public void enterValidatorScope() {
        this.scopeProvider.assess().enterValidatorScope();
    }

    @Override
    public void leaveValidatorScope() {
        this.scopeProvider.assess().leaveValidatorScope();
    }

    @Override
    public boolean inValidatorScope() {
        return this.scopeProvider.assess().inValidatorScope();
    }

    @Override
    public void enterDeadzone(String string) {
        this.scopeProvider.assess().enterDeadzone(string);
    }

    @Override
    public void exitDeadzone() {
        this.scopeProvider.assess().exitDeadzone();
    }

    public static void setEnabled(boolean bl2) {
        enabled = bl2;
    }
}

