/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services.ngreporting;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.e.g;
import com.contrastsecurity.agent.messages.app.ApplicationResponse;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.apps.ApplicationSettingsUpdateEventBus;
import com.contrastsecurity.agent.plugins.i;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.ngreporting.ActivityReportContext;
import com.contrastsecurity.agent.services.ngreporting.LegacyReport;
import com.contrastsecurity.agent.services.ngreporting.e;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.services.ngreporting.l;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSyntaxException;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class a
extends l {
    private static final String b = "Contrast Application Activity Updater";
    private final long c;
    private final ApplicationSettingsUpdateEventBus d;
    private final e e;
    private final Clock f;
    private final i g;
    private static final Logger h = LoggerFactory.getLogger(a.class);

    public a(ApplicationManager applicationManager, ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus, Clock clock, com.contrastsecurity.agent.config.e e2, e e3, i i2, ScopeProvider scopeProvider, o o2) {
        super(b, e2.getLong(ConfigProperty.APP_ACTIVITY_PERIOD_MS), applicationManager, scopeProvider, o2);
        this.d = applicationSettingsUpdateEventBus;
        this.f = clock;
        this.e = e3;
        this.g = i2;
        this.c = e2.getLong(ConfigProperty.STALE_APP_ACTIVITY_UPDATE_MS);
    }

    @Override
    void a() {
        h.debug("Spooling app activities...");
        for (Application application : this.a.getApplications()) {
            this.b(application);
        }
    }

    private void b(Application application) {
        boolean bl2 = application.isUnwanted();
        boolean bl3 = application.getState().c();
        if (bl2 || !bl3) {
            h.debug("Can't send app activity for {} - created on server = {}, wanted on server = {}", application, bl3, !bl2);
            return;
        }
        List<ContrastPlugin> list = this.g.getPlugins();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ActivityReportContext activityReportContext = new ActivityReportContext();
        this.a(application, list, hashMap, activityReportContext);
        boolean bl4 = this.a(application);
        if (!activityReportContext.isRequiresReport() && !bl4) {
            return;
        }
        h.debug("Sending app activity for {} - data needed to send = {}, stale = {}", application, activityReportContext.isRequiresReport(), bl4);
        h h2 = new h(hashMap, application, this.f);
        g<String> g2 = this.a(application, h2);
        if (g2 == null) {
            h.debug("Didn't update settings for {}, response was null", (Object)application);
            return;
        }
        int n2 = g2.a();
        if (n2 == 409) {
            com.contrastsecurity.agent.services.e.a(n2, g2.b(), application, "app activity");
            return;
        }
        if (n2 != 200) {
            h.debug("Didn't update app settings for {}, status={}", (Object)application, (Object)n2);
            return;
        }
        String string = g2.b();
        if (StringUtils.isEmpty(string)) {
            h.debug("Didn't update app settings for {}, status={}", (Object)application, (Object)n2);
            return;
        }
        try {
            ApplicationResponse applicationResponse = ObjectShare.GSON.fromJson(string, ApplicationResponse.class);
            ApplicationSettingsDTM applicationSettingsDTM = applicationResponse.getSettings();
            if (applicationSettingsDTM == null) {
                return;
            }
            this.d.publish(application, applicationSettingsDTM, this.f.now());
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            h.error("Encountered a JSON syntax error, unable to update application settings", jsonSyntaxException);
        }
    }

    private void a(Application application, List<ContrastPlugin> list, Map<String, Object> map, ActivityReportContext activityReportContext) {
        for (ContrastPlugin contrastPlugin : list) {
            try {
                contrastPlugin.onAppActivityReportingStarting(activityReportContext, application, map);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                h.error("Problem delegating activity report start event to {}", (Object)contrastPlugin, (Object)exception2);
            }
        }
    }

    private g<String> a(Application application, LegacyReport legacyReport) {
        g<String> g2 = this.e.b(legacyReport);
        application.setLastActivityReportedTime(this.f.now());
        return g2;
    }

    boolean a(Application application) {
        long l2 = application.getLastActivityReportedTime();
        if (l2 == 0L) {
            return true;
        }
        Date date = new Date(l2);
        long l3 = new Date(this.f.now()).getTime() - this.c;
        return date.before(new Date(l3));
    }
}

