/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services.ngreporting;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.config.c.b;
import com.contrastsecurity.agent.config.enums.SaveReportMode;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.scope.a;
import com.contrastsecurity.agent.services.a;
import com.contrastsecurity.agent.services.ngreporting.LegacyReport;
import com.contrastsecurity.agent.services.ngreporting.c;
import com.contrastsecurity.agent.services.ngreporting.d;
import com.contrastsecurity.agent.services.ngreporting.e;
import com.contrastsecurity.agent.services.ngreporting.g;
import com.contrastsecurity.agent.services.ngreporting.k;
import com.contrastsecurity.agent.services.ngreporting.m;
import com.contrastsecurity.agent.services.ngreporting.o;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@Singleton
public final class f
implements e {
    private final Map<Long, Long> a = new ConcurrentHashMap<Long, Long>();
    private final Queue<LegacyReport> b = new ConcurrentLinkedQueue<LegacyReport>();
    private volatile boolean c;
    private Thread d;
    private final c e;
    private final long f;
    private final boolean g;
    private final com.contrastsecurity.agent.config.e h;
    private final m i;
    private final Clock j;
    private final com.contrastsecurity.agent.d.g k;
    private final long l;
    private final com.contrastsecurity.agent.telemetry.errors.o m;
    private static final Logger n = LoggerFactory.getLogger(f.class);

    public f(com.contrastsecurity.agent.config.e e2, Clock clock, com.contrastsecurity.agent.d.g g2, WorkingDirectories workingDirectories, com.contrastsecurity.agent.telemetry.errors.o o2) {
        this(e2, clock, !StringUtils.isEmpty(e2.getOrNull(ConfigProperty.TEAMSERVER_URL)) ? new d(e2, g2) : null, g2, workingDirectories, o2);
    }

    public f(com.contrastsecurity.agent.config.e e2, Clock clock, m m2, com.contrastsecurity.agent.d.g g2, WorkingDirectories workingDirectories, com.contrastsecurity.agent.telemetry.errors.o o2) {
        this.h = Objects.requireNonNull(e2);
        this.j = Objects.requireNonNull(clock);
        this.k = Objects.requireNonNull(g2);
        this.i = m2;
        this.m = Objects.requireNonNull(o2);
        this.l = e2.getLong(ConfigProperty.DUP_DELAY);
        this.e = new c(e2, workingDirectories);
        this.f = e2.getLong(ConfigProperty.LEGACY_REPORTING_PERIOD);
        this.g = e2.getBoolean(ConfigProperty.PREFLIGHT_FAIL_OPEN);
        this.c = true;
    }

    Queue<LegacyReport> d() {
        return this.b;
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    public String c() {
        return "LegacyReporting";
    }

    @Override
    public synchronized void a(Instrumentation instrumentation, List<? extends ContrastPlugin> list) {
        if (this.d != null) {
            return;
        }
        this.c = true;
        this.d = com.contrastsecurity.agent.scope.a.a("Contrast Reporting", this.m).newThread(() -> {
            while (this.c) {
                try {
                    this.e();
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    n.error("Problem sending reports to Contrast TeamServer", throwable2);
                    this.m.a(throwable2);
                }
                try {
                    Thread.sleep(this.f);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.e();
        });
        n.info("Starting reporting thread...");
        this.d.start();
    }

    @Override
    public synchronized void a() {
        if (this.d == null) {
            return;
        }
        this.c = false;
        Thread thread = this.d;
        this.d = null;
        thread.interrupt();
        n.debug("Processing remaining elements in the reporting queue");
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            n.debug("Processing remaining elements in the queue - interrupted");
            return;
        }
        n.debug("Processing remaining elements in the queue - done");
    }

    @Override
    public a.a i() {
        return a.a.b;
    }

    private boolean c(LegacyReport legacyReport) {
        long l2 = legacyReport.getHash();
        if (this.a(legacyReport.getApplication(), l2)) {
            legacyReport.onIgnoredAsAlreadyReported();
            if (n.isDebugEnabled()) {
                n.debug("LegacyReport {} already reported to server: {}", (Object)l2, (Object)legacyReport.getShortDescription());
            }
            return false;
        }
        if (this.b.offer(legacyReport)) {
            this.a.put(com.contrastsecurity.agent.services.ngreporting.f.b(legacyReport.getApplication(), l2), this.j.now());
            legacyReport.onAcceptedIntoReportingQueue();
            if (n.isDebugEnabled()) {
                n.debug("Trace {} added to reporting queue: {}", (Object)l2, (Object)legacyReport.getShortDescription());
            }
            return true;
        }
        if (n.isDebugEnabled()) {
            n.debug("Trace {} was skipped as reporting queue was full: {}", (Object)l2, (Object)legacyReport.getShortDescription());
        }
        return false;
    }

    @Override
    public boolean a(Application application, long l2) {
        if (l2 == 0L) {
            return false;
        }
        long l3 = this.j.now();
        Long l4 = this.a.get(com.contrastsecurity.agent.services.ngreporting.f.b(application, l2));
        return l4 != null && l3 - l4 <= this.l;
    }

    private static long b(Application application, long l2) {
        return (long)(application == null ? 0 : application.hashCode()) + l2;
    }

    @n
    void e() {
        int n2;
        ArrayList<LegacyReport> arrayList;
        SaveReportMode saveReportMode;
        boolean bl2;
        block20: {
            LegacyReport legacyReport;
            ArrayList<LegacyReport> arrayList2 = new ArrayList<LegacyReport>();
            ArrayList<LegacyReport> arrayList3 = new ArrayList<LegacyReport>();
            bl2 = false;
            saveReportMode = com.contrastsecurity.agent.services.ngreporting.f.a(this.h);
            boolean bl3 = SaveReportMode.Always.equals((Object)saveReportMode);
            while ((legacyReport = this.b.poll()) != null) {
                Application application = legacyReport.getApplication();
                if (application == null) {
                    arrayList3.add(legacyReport);
                } else if (!application.isUnwanted()) {
                    if (!application.getState().c()) {
                        arrayList2.add(legacyReport);
                    } else {
                        arrayList3.add(legacyReport);
                    }
                }
                if (!bl3) continue;
                this.e.a(legacyReport);
                bl2 = true;
            }
            int n3 = arrayList2.size();
            if (n3 > 0) {
                this.b.addAll(arrayList2);
                n.debug("Held back {} reports until app created.", (Object)n3);
            }
            if (arrayList3.size() == 0) {
                return;
            }
            if (this.i == null) {
                return;
            }
            arrayList = new ArrayList<LegacyReport>();
            HashMap<Integer, LegacyReport> hashMap = new HashMap<Integer, LegacyReport>();
            n2 = 0;
            for (LegacyReport object2 : arrayList3) {
                if (object2.requiresPreflight()) {
                    hashMap.put(n2++, object2);
                    if (!(object2 instanceof g)) continue;
                    this.a((g)object2);
                    continue;
                }
                n.debug("Adding {} to preflight approved reports", (Object)object2.getHash());
                arrayList.add(object2);
            }
            if (!hashMap.isEmpty()) {
                try {
                    arrayList.addAll(this.i.a(hashMap));
                }
                catch (IOException iOException) {
                    if (saveReportMode.equals((Object)SaveReportMode.OnError)) {
                        for (Object object : hashMap.values()) {
                            this.e.a((LegacyReport)object);
                        }
                        bl2 = true;
                    }
                    if (n.isDebugEnabled()) {
                        String string = this.g ? "adding all" : "not adding any";
                        n.debug("Problem asking for preflight acceptance of reports - {} to approved list", (Object)string, (Object)iOException);
                    }
                    if (!this.g) break block20;
                    arrayList.addAll(hashMap.values());
                }
            }
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            int n3;
            Object object;
            LegacyReport legacyReport = (LegacyReport)arrayList.get(i2);
            if (legacyReport instanceof g) {
                this.b((g)legacyReport);
            }
            int n4 = n3 = (object = this.i.a(legacyReport)) != null ? ((com.contrastsecurity.agent.e.g)object).a() : -1;
            if (saveReportMode.equals((Object)SaveReportMode.OnError) && n3 == -1 && !bl2) {
                this.e.a(legacyReport);
            }
            ++n2;
            if (!this.g()) continue;
            n.warn("Received bad response after sending {} of {} approved reports. Dumping the queue and pausing service.", (Object)n2, (Object)arrayList.size());
            this.h();
            break;
        }
        n.trace("Sent out {} reports to server", (Object)n2);
    }

    private void a(g g2) {
        o o2 = g2.getListener();
        if (o2 != null) {
            o2.a(g2);
        }
    }

    private void b(g g2) {
        o o2 = g2.getListener();
        if (o2 != null) {
            o2.b(g2);
        }
    }

    @Override
    public com.contrastsecurity.agent.e.g<String> b(LegacyReport legacyReport) {
        com.contrastsecurity.agent.e.g<String> g2 = null;
        if (this.f()) {
            n.debug("Not sending report because reporting service is still paused");
        } else if (!this.c) {
            n.debug("Not sending report because reporting service is stopped");
        } else if (this.i != null) {
            g2 = this.i.a(legacyReport);
            int n2 = g2 != null ? g2.a() : -1;
            SaveReportMode saveReportMode = com.contrastsecurity.agent.services.ngreporting.f.a(this.h);
            if (SaveReportMode.OnError.equals((Object)saveReportMode) && n2 == -1 || SaveReportMode.Always.equals((Object)saveReportMode)) {
                this.e.a(legacyReport);
            }
        }
        if (this.g()) {
            this.h();
        }
        return g2;
    }

    @Override
    public boolean a(LegacyReport legacyReport) {
        if (this.f()) {
            n.debug("Not queuing report because reporting service is still paused by an earlier 401 or 412");
            return false;
        }
        if (!this.c) {
            n.debug("Not queueing report because reporting service is stopped");
            return false;
        }
        String string = this.h.get(ConfigProperty.VM_ID);
        if (legacyReport.getApplication() != null) {
            string = legacyReport.getApplication().getName();
        }
        if (n.isDebugEnabled()) {
            k k2 = null;
            String string2 = "Unable to generate report JSON";
            try {
                string2 = legacyReport.getPayload();
            }
            catch (k k3) {
                k2 = k3;
            }
            n.debug("\n\tApplication: {}\n\tReportMethod: {}\n\tReportURL(): {}\n\tReportLevel(): {}\n\tReportType(): {}\n\tReportJSON():\n{}\n", new Object[]{string, legacyReport.getMethod(), legacyReport.getURL(), legacyReport.getLevel(), legacyReport.getClass().getSimpleName(), string2, k2});
        }
        return this.c(legacyReport);
    }

    boolean f() {
        return this.k.b();
    }

    boolean g() {
        return this.k.b();
    }

    void h() {
        this.b.clear();
        n.warn("Clearing reporting service queue and pausing reports because of paused TeamServer channel");
    }

    void j() {
        this.a.clear();
    }

    void k() {
        this.b.clear();
    }

    static SaveReportMode a(com.contrastsecurity.agent.config.e e2) {
        String string = e2.get(ConfigProperty.SAVERESULTS);
        SaveReportMode saveReportMode = SaveReportMode.valueOfIgnoreCase(string);
        if (saveReportMode == null) {
            throw new b("Invalid value [" + string + "] set for " + (Object)((Object)ConfigProperty.SAVERESULTS) + ". Valid values are Always, Never, OnError.");
        }
        return saveReportMode;
    }
}

