/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.e;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.http.f;
import com.contrastsecurity.agent.messages.finding.trace.EventActionDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSignatureDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTaintRangeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.ObjectDTM;
import com.contrastsecurity.agent.messages.finding.trace.ParentObjectIdDTM;
import com.contrastsecurity.agent.messages.finding.trace.StackDTM;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.services.ngreporting.k;
import com.contrastsecurity.agent.stack.StackCapture;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.a.b;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public class CodeEvent {
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    protected final EventTypeDTM eventTypeDTM;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    protected final EventActionDTM eventActionDTM;
    protected final long id;
    @HeapUsage.Deep
    protected final Set<Long> parentIds;
    @HeapUsage.Deep
    protected StackCapture stack;
    @HeapUsage.Deep
    protected TagRanges tagRanges;
    @HeapUsage.Deep
    protected final b object;
    @HeapUsage.Deep
    protected final b returnValue;
    @HeapUsage.Deep
    protected final b[] parameters;
    protected final long timestamp;
    @HeapUsage.Cacheable(cache=AssessmentContext.a.class)
    protected final String threadDesc;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    protected final MethodDescription method;
    @HeapUsage.Deep
    protected final String sourceType;
    @HeapUsage.Deep
    protected final String targetType;
    protected static final String TRACE_NEWLINE_INDENT = "\n\t\t\t\t\t\t\t";
    private static final int SHORT_STRING_MAX_TRACE_SIZE = 15;

    protected CodeEvent(a a2) {
        this.id = a2.e();
        this.parentIds = a2.f();
        this.timestamp = a2.g();
        this.threadDesc = a2.h();
        this.method = Objects.requireNonNull(a2.i());
        this.eventTypeDTM = a2.j();
        this.eventActionDTM = a2.k();
        this.object = a2.n();
        this.returnValue = a2.o();
        this.parameters = a2.p();
        this.tagRanges = a2.l();
        this.stack = a2.m();
        this.sourceType = a2.c();
        this.targetType = a2.d();
    }

    public void prepareForReporting(List<CodeEvent> list, int n2) {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public StackCapture getStack() {
        return this.stack;
    }

    public void setStack(StackCapture stackCapture) {
        this.stack = stackCapture;
    }

    public b getObject() {
        return this.object;
    }

    public b getReturnValue() {
        return this.returnValue;
    }

    public String getObj() {
        return this.getObject().b();
    }

    public String getRet() {
        return this.getReturnValue().b();
    }

    public b[] getParameters() {
        return this.parameters;
    }

    public String getThreadDesc() {
        return this.threadDesc;
    }

    public MethodDescription getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.method.getSignature());
        stringBuilder.append("\n         ");
        stringBuilder.append(this.getObj());
        stringBuilder.append(".");
        stringBuilder.append(this.method.getName());
        b[] bArray = this.getParameters();
        for (int i2 = 0; i2 < bArray.length; ++i2) {
            stringBuilder.append(bArray[i2].b());
            if (i2 == bArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(" => ");
        stringBuilder.append(this.getRet());
        stringBuilder.append(" ");
        stringBuilder.append(this.getTagRanges());
        return stringBuilder.toString();
    }

    public final EventDTM toDtm() throws k {
        this.ensureValid();
        return this.getCommonDtm();
    }

    public final EventDTM getCommonDtm() {
        return this.getCommonDtmBuilder().build();
    }

    protected EventDTM.Builder getCommonDtmBuilder() {
        List<EventTaintRangeDTM> list = this.tagRanges != null ? this.tagRanges.toDTM() : EventTaintRangeDTM.DEFAULT_LIST;
        return EventDTM.builder().type(this.eventTypeDTM).action(this.eventActionDTM).time(this.timestamp).thread(f.a(this.threadDesc)).objectId(this.id).parentObjectIds(this.buildParentIdDtms()).source(this.sourceType).target(this.targetType).signature(EventSignatureDTM.builder().setClassName(this.method.getDeclaringClassType()).setMethodName(this.method.getName()).setConstructor("<init>".equalsIgnoreCase(this.method.getName())).setArgTypes(Arrays.asList(this.method.getParameterTypeNames())).setReturnType(this.method.getReturnTypeName()).setFlags(this.method.getModifiers()).build()).taintRanges(list).object(this.object.a(list)).ret(this.returnValue.a(list)).args(this.buildArgumentDTMs(list)).tags(EventDTM.Builder.buildTagsString(this.eventTypeDTM, this.getTags())).stack(this.buildStackDTM());
    }

    private Set<ParentObjectIdDTM> buildParentIdDtms() {
        if (this.parentIds == null || this.parentIds.isEmpty()) {
            return null;
        }
        HashSet<ParentObjectIdDTM> hashSet = new HashSet<ParentObjectIdDTM>(this.parentIds.size());
        for (Long l2 : this.parentIds) {
            hashSet.add(new ParentObjectIdDTM(l2));
        }
        return hashSet;
    }

    private List<ObjectDTM> buildArgumentDTMs(List<EventTaintRangeDTM> list) {
        ArrayList<ObjectDTM> arrayList = new ArrayList<ObjectDTM>(this.parameters.length);
        for (b b2 : this.parameters) {
            arrayList.add(b2.a(list));
        }
        return arrayList;
    }

    @n
    protected List<StackDTM> buildStackDTM() {
        if (this.stack == null) {
            return null;
        }
        List<StackTraceElement> list = this.stack.traceWithoutLeadingContrastCode();
        ArrayList<StackDTM> arrayList = new ArrayList<StackDTM>(list.size());
        for (StackTraceElement stackTraceElement : list) {
            arrayList.add(StackDTM.of(stackTraceElement));
        }
        return arrayList;
    }

    @n
    public List<StackTraceElement> getStackWithoutContrastCode() {
        return this.stack.traceWithoutLeadingContrastCode();
    }

    @e
    public StringBuilder toShortString(StringBuilder stringBuilder) {
        int n2;
        String[] stringArray;
        stringBuilder.append("PLUG");
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("CALLEE: ").append(this.method.getReturnTypeName()).append(' ').append(this.method.getDeclaringClassType()).append('.').append(this.method.getName()).append('(');
        CodeEvent.joinWithSeparator(stringBuilder, this.method.getParameterTypeNames());
        stringBuilder.append(')');
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        if (this.stack != null) {
            stringArray = this.stack.traceWithoutLeadingContrastCode();
            for (n2 = 0; n2 < 15 && n2 < stringArray.size(); ++n2) {
                stringBuilder.append("CALLER: ").append(stringArray.get(n2)).append(TRACE_NEWLINE_INDENT);
            }
        }
        stringBuilder.append("OBJ:");
        CodeEvent.formatValueForShortString(stringBuilder, this.method.getDeclaringClassType(), this.object.b(), this.object.d(), this.object.c());
        stringBuilder.append(".");
        stringBuilder.append(this.method.getName());
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("LENGTH: ").append(this.object.e());
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("TAGS: ").append(this.getTagRanges());
        stringArray = this.method.getParameterTypeNames();
        for (n2 = 0; n2 < this.parameters.length; ++n2) {
            b b2 = this.parameters[n2];
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("P-").append(n2).append(":");
            CodeEvent.formatValueForShortString(stringBuilder, stringArray[n2], b2.b(), b2.d(), b2.c());
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("LENGTH: ").append(b2.e());
        }
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("RET:");
        CodeEvent.formatValueForShortString(stringBuilder, this.method.getReturnTypeName(), this.returnValue.b(), this.returnValue.d(), this.returnValue.c());
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("LENGTH: ").append(this.returnValue.e());
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("OBJ_ID:").append(this.object.a());
        for (n2 = 0; n2 < this.parameters.length; ++n2) {
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("P-").append(n2).append("_ID:").append(this.parameters[n2].a());
        }
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("RET_ID:").append(this.returnValue.a());
        return stringBuilder;
    }

    @e
    private static void formatValueForShortString(StringBuilder stringBuilder, String string, String string2, int n2, boolean bl2) {
        stringBuilder.append(string).append('[').append(string2).append(']');
        if (bl2) {
            stringBuilder.append('*').append(n2);
        }
    }

    @e
    private static void joinWithSeparator(StringBuilder stringBuilder, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(stringArray[i2]);
        }
    }

    public String getMethodName() {
        return this.method.getDeclaringClassType() + "." + this.method.getName();
    }

    public TagRanges getTagRanges() {
        return this.tagRanges;
    }

    public void addTags(Collection<Tag> collection, int n2) throws InvalidTagRangeException {
        if (n2 <= 0 || collection == null || collection.isEmpty()) {
            return;
        }
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>(this.tagRanges.size() + collection.size());
        arrayList.addAll(this.tagRanges.getTagRanges());
        for (Tag tag : collection) {
            arrayList.add(new TagRange(0, n2, tag));
        }
        this.tagRanges = new TagRanges(arrayList);
    }

    public List<TagRange> getUntrustedRanges() {
        return this.tagRanges != null ? this.tagRanges.getUntrustedRanges() : null;
    }

    public Set<Tag> getTags() {
        return this.tagRanges != null ? this.tagRanges.getTags() : null;
    }

    public int getObjHash() {
        return this.getObject().d();
    }

    public int getRetHash() {
        return this.getReturnValue().d();
    }

    public long getId() {
        return this.id;
    }

    public Set<Long> getParentIds() {
        return this.parentIds;
    }

    public boolean isAnyParamTracked() {
        if (this.parameters == null) {
            return false;
        }
        for (b b2 : this.parameters) {
            if (!b2.c()) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectTracked() {
        return this.getObject().c();
    }

    public boolean isReturnTracked() {
        return this.getReturnValue().c();
    }

    protected void ensureValid() throws k {
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public EventTypeDTM getEventTypeDTM() {
        return this.eventTypeDTM;
    }

    public EventActionDTM getEventActionDTM() {
        return this.eventActionDTM;
    }

    public static interface a {
        public long e();

        public Set<Long> f();

        public long g();

        public String h();

        public MethodDescription i();

        public EventTypeDTM j();

        public EventActionDTM k();

        public TagRanges l();

        public StackCapture m();

        public String c();

        public String d();

        public b n();

        public b o();

        public b[] p();
    }
}

