/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.n;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DontObfuscate
public final class VMArguments {
    private static final Pattern AGENT_PATTERN = Pattern.compile("-javaagent:([^=]+).*");
    private static final Pattern AGENT_PATTERN_ALL = Pattern.compile("-(?:javaagent|agentlib|agentpath):([^=]+).*");

    private VMArguments() {
    }

    public static Set<String> findAgents() {
        return VMArguments.findAgents(true);
    }

    public static Set<String> findAgents(boolean bl2) {
        return VMArguments.matchAgents(VMArguments.getVMArguments(), bl2);
    }

    @n
    static Set<String> matchAgents(Collection<String> collection, boolean bl2) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : collection) {
            Matcher matcher;
            Matcher matcher2 = matcher = bl2 ? AGENT_PATTERN_ALL.matcher(string) : AGENT_PATTERN.matcher(string);
            if (!matcher.find()) continue;
            linkedHashSet.add(matcher.group(1));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public static List<String> getVMArguments() {
        try {
            Object object;
            Class<?> clazz = Class.forName("sun.management.ManagementFactoryHelper");
            Class<?> clazz2 = Class.forName("sun.management.VMManagement");
            try {
                object = clazz.getDeclaredMethod("getVMManagement", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Field field = clazz.getDeclaredField("jvm");
                field.setAccessible(true);
                object = field.get(null);
                field.setAccessible(false);
            }
            return Collections.unmodifiableList((List)clazz2.getMethod("getVmArguments", new Class[0]).invoke(object, new Object[0]));
        }
        catch (ReflectiveOperationException | UnsatisfiedLinkError throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            try {
                Class<?> clazz = Class.forName("com.ibm.oti.vm.VM");
                String[] stringArray = (String[])clazz.getMethod("getVMArgs", new Class[0]).invoke(null, new Object[0]);
                if (stringArray == null || stringArray.length == 0) {
                    return Collections.emptyList();
                }
                return Lists.of(stringArray);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Throwables.throwIfCritical(reflectiveOperationException);
                ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        }
    }
}

