/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.Beans;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.DeferredConstruction;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.YamlConfig;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.YamlException;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.YamlWriter;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.AliasEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.CollectionStartEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.Event;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.EventType;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.Parser;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.tokenizer.Tokenizer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlReader
implements AutoCloseable {
    private final YamlConfig config;
    Parser parser;
    private final Map<String, Object> anchors = new HashMap<String, Object>();

    public YamlReader(Reader reader) {
        this(reader, new YamlConfig());
    }

    public YamlReader(Reader reader, YamlConfig yamlConfig) {
        this.config = yamlConfig;
        this.parser = new Parser(reader, yamlConfig.readConfig.defaultVersion);
    }

    public YamlReader(String string) {
        this(new StringReader(string));
    }

    public YamlReader(String string, YamlConfig yamlConfig) {
        this(new StringReader(string), yamlConfig);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public Object get(String string) {
        return this.anchors.get(string);
    }

    private void addAnchor(String string, Object object) {
        if (this.config.readConfig.anchors) {
            this.anchors.put(string, object);
        }
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        this.anchors.clear();
    }

    public Object read() throws YamlException {
        return this.read(null);
    }

    public <T> T read(Class<T> clazz) throws YamlException {
        return this.read(clazz, null);
    }

    public <T> T read(Class<T> clazz, Class clazz2) throws YamlException {
        this.anchors.clear();
        try {
            Object object;
            do {
                if ((object = this.parser.getNextEvent()) == null) {
                    return null;
                }
                if (((Event)object).type != EventType.STREAM_END) continue;
                return null;
            } while (((Event)object).type != EventType.DOCUMENT_START);
            object = this.readValue(clazz, clazz2, null);
            this.parser.getNextEvent();
            return (T)object;
        }
        catch (Parser.ParserException parserException) {
            throw new YamlException("Error parsing YAML.", parserException);
        }
        catch (Tokenizer.TokenizerException tokenizerException) {
            throw new YamlException("Error tokenizing YAML.", tokenizerException);
        }
    }

    public <T> Iterator<T> readAll(final Class<T> clazz) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                Event event = YamlReader.this.parser.peekNextEvent();
                return event != null && event.type != EventType.STREAM_END;
            }

            @Override
            public T next() {
                try {
                    return YamlReader.this.read(clazz);
                }
                catch (YamlException yamlException) {
                    throw new RuntimeException("Error reading YAML document for iterator.", yamlException);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected Object readValue(Class clazz, Class clazz2, Class clazz3) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        String string = null;
        String string2 = null;
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case ALIAS: {
                this.parser.getNextEvent();
                string2 = ((AliasEvent)event).anchor;
                Object object = this.anchors.get(string2);
                if (object == null && this.config.readConfig.anchors) {
                    throw new YamlReaderException("Unknown anchor: " + string2);
                }
                return object;
            }
            case MAPPING_START: 
            case SEQUENCE_START: {
                string = ((CollectionStartEvent)event).tag;
                string2 = ((CollectionStartEvent)event).anchor;
                break;
            }
            case SCALAR: {
                string = ((ScalarEvent)event).tag;
                string2 = ((ScalarEvent)event).anchor;
                break;
            }
        }
        return this.readValueInternal(this.chooseType(string, clazz3, clazz), clazz2, string2);
    }

    private Class<?> chooseType(String string, Class<?> clazz, Class<?> clazz2) throws YamlReaderException {
        if (string != null && this.config.readConfig.classTags) {
            Class clazz3 = this.config.tagToClass.get(string);
            if (clazz3 != null) {
                return clazz3;
            }
            ClassLoader classLoader = this.config.readConfig.classLoader == null ? this.getClass().getClassLoader() : this.config.readConfig.classLoader;
            string = string.replace("!", "");
            try {
                Class<?> clazz4 = this.findTagClass(string, classLoader);
                if (clazz4 != null) {
                    if (clazz2 != null && !clazz2.isAssignableFrom(clazz4)) {
                        throw new YamlReaderException("Class specified by tag is incompatible with expected type: " + clazz4.getName() + " (expected " + clazz2.getName() + ")");
                    }
                    return clazz4;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new YamlReaderException("Unable to find class specified by tag: " + string);
            }
        }
        if (clazz != null) {
            return clazz;
        }
        return clazz2;
    }

    protected Class<?> findTagClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(string, true, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private Object readValueInternal(Class clazz, Class clazz2, String string) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        Object object;
        Object object3;
        if (clazz == null || clazz == Object.class) {
            object3 = this.parser.peekNextEvent();
            switch (((Event)object3).type) {
                case MAPPING_START: {
                    clazz = LinkedHashMap.class;
                    break;
                }
                case SCALAR: {
                    String object22;
                    if (this.config.readConfig.guessNumberTypes && (object22 = ((ScalarEvent)object3).value) != null && (object = this.valueConvertedNumber(object22)) != null) {
                        if (string != null) {
                            this.addAnchor(string, object);
                        }
                        this.parser.getNextEvent();
                        return object;
                    }
                    clazz = String.class;
                    break;
                }
                case SEQUENCE_START: {
                    clazz = ArrayList.class;
                    break;
                }
                default: {
                    throw new YamlReaderException("Expected scalar, sequence, or mapping but found: " + (Object)((Object)((Event)object3).type));
                }
            }
        }
        if (Beans.isScalar(clazz)) {
            object3 = this.parser.getNextEvent();
            if (((Event)object3).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for primitive type '" + clazz.getClass() + "' but found: " + (Object)((Object)((Event)object3).type));
            }
            String string2 = ((ScalarEvent)object3).value;
            try {
                if (string2 == null) {
                    object = null;
                } else if (clazz == String.class) {
                    object = string2;
                } else if (clazz == Integer.TYPE || clazz == Integer.class) {
                    object = Integer.decode(string2);
                } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                    object = Boolean.valueOf(string2);
                } else if (clazz == Float.TYPE || clazz == Float.class) {
                    object = Float.valueOf(string2);
                } else if (clazz == Double.TYPE || clazz == Double.class) {
                    object = Double.valueOf(string2);
                } else if (clazz == Long.TYPE || clazz == Long.class) {
                    object = Long.decode(string2);
                } else if (clazz == Short.TYPE || clazz == Short.class) {
                    object = Short.decode(string2);
                } else if (clazz == Character.TYPE || clazz == Character.class) {
                    object = Character.valueOf(string2.charAt(0));
                } else if (clazz == Byte.TYPE || clazz == Byte.class) {
                    object = Byte.decode(string2);
                } else {
                    throw new YamlException("Unknown field type.");
                }
                if (string != null) {
                    this.addAnchor(string, object);
                }
                return object;
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                object = exception;
                throw new YamlReaderException("Unable to convert value to required type \"" + clazz + "\": " + string2, (Throwable)object);
            }
        }
        for (Map.Entry entry : this.config.scalarSerializers.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(clazz)) continue;
            object = (ScalarSerializer)entry.getValue();
            Event event = this.parser.getNextEvent();
            if (event.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for type '" + clazz + "' to be deserialized by scalar serializer '" + object.getClass().getName() + "' but found: " + (Object)((Object)event.type));
            }
            Object t2 = object.read(((ScalarEvent)event).value);
            if (string != null) {
                this.addAnchor(string, t2);
            }
            return t2;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            object3 = this.parser.getNextEvent();
            if (((Event)object3).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for enum type but found: " + (Object)((Object)((Event)object3).type));
            }
            String string3 = ((ScalarEvent)object3).value;
            if (string3 == null) {
                return null;
            }
            try {
                return Enum.valueOf(clazz, string3);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                object = exception;
                throw new YamlReaderException("Unable to find enum value '" + string3 + "' for enum class: " + clazz.getName());
            }
        }
        object3 = this.parser.peekNextEvent();
        switch (((Event)object3).type) {
            case MAPPING_START: {
                void var5_12;
                Object object2;
                Object object4;
                object3 = this.parser.getNextEvent();
                try {
                    object4 = this.createObject(clazz);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwables.throwIfCritical(invocationTargetException);
                    object = invocationTargetException;
                    throw new YamlReaderException("Error creating object.", (Throwable)object);
                }
                if (string != null) {
                    this.addAnchor(string, object4);
                }
                object = new ArrayList();
                while (true) {
                    Object object5;
                    if (this.parser.peekNextEvent().type == EventType.MAPPING_END) break;
                    object2 = this.readValue(null, null, null);
                    boolean bl2 = object2 instanceof Map;
                    Object object6 = null;
                    if (bl2) {
                        object5 = ((Map)object2).entrySet().iterator().next();
                        object2 = object5.getKey();
                        object6 = object5.getValue();
                    }
                    if (object4 instanceof Map) {
                        if (this.config.tagSuffix != null) {
                            object5 = this.parser.peekNextEvent();
                            switch (((Event)object5).type) {
                                case MAPPING_START: 
                                case SEQUENCE_START: {
                                    ((Map)object4).put(object2 + this.config.tagSuffix, ((CollectionStartEvent)object5).tag);
                                    break;
                                }
                                case SCALAR: {
                                    ((Map)object4).put(object2 + this.config.tagSuffix, ((ScalarEvent)object5).tag);
                                }
                            }
                        }
                        if (!bl2) {
                            object6 = this.readValue(clazz2, null, null);
                        }
                        if (!this.config.allowDuplicates && ((Map)object4).containsKey(object2)) {
                            throw new YamlReaderException("Duplicate key found '" + object2 + "'");
                        }
                        if (this.config.readConfig.autoMerge && "<<".equals(object2) && object6 != null) {
                            this.mergeMap((Map)object4, object6);
                            continue;
                        }
                        ((Map)object4).put(object2, object6);
                        continue;
                    }
                    try {
                        Object object7;
                        Object object8;
                        if (!this.config.allowDuplicates && ((ArrayList)object).contains(object2)) {
                            throw new YamlReaderException("Duplicate key found '" + object2 + "'");
                        }
                        ((ArrayList)object).add(object2);
                        object5 = Beans.getProperty(clazz, (String)object2, this.config.beanProperties, this.config.privateFields, this.config);
                        if (object5 == null) {
                            if (this.config.readConfig.ignoreUnknownProperties) {
                                object8 = this.parser.peekNextEvent();
                                object7 = ((Event)object8).type;
                                if (object7 == EventType.SEQUENCE_START || object7 == EventType.MAPPING_START) {
                                    this.skipRange();
                                    continue;
                                }
                                this.parser.getNextEvent();
                                continue;
                            }
                            throw new YamlReaderException("Unable to find property '" + object2 + "' on class: " + clazz.getName());
                        }
                        object8 = this.config.propertyToElementType.get(object5);
                        if (object8 == null) {
                            object8 = ((Beans.Property)object5).getElementType();
                        }
                        object7 = this.config.propertyToDefaultType.get(object5);
                        if (!bl2) {
                            object6 = this.readValue(((Beans.Property)object5).getType(), (Class)object8, (Class)object7);
                        }
                        ((Beans.Property)object5).set(object4, object6);
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        object5 = exception;
                        if (object5 instanceof YamlReaderException) {
                            throw (YamlReaderException)object5;
                        }
                        throw new YamlReaderException("Error setting property '" + object2 + "' on class: " + clazz.getName(), (Throwable)object5);
                    }
                }
                this.parser.getNextEvent();
                if (object4 instanceof DeferredConstruction) {
                    try {
                        Object object9 = ((DeferredConstruction)object4).construct();
                        if (string != null) {
                            this.addAnchor(string, object9);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwables.throwIfCritical(invocationTargetException);
                        object2 = invocationTargetException;
                        throw new YamlReaderException("Error creating object.", (Throwable)object2);
                    }
                }
                return var5_12;
            }
            case SEQUENCE_START: {
                void var5_15;
                object3 = this.parser.getNextEvent();
                if (Collection.class.isAssignableFrom(clazz)) {
                    try {
                        Collection collection = (Collection)Beans.createObject(clazz, this.config.privateConstructors);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwables.throwIfCritical(invocationTargetException);
                        object = invocationTargetException;
                        throw new YamlReaderException("Error creating object.", (Throwable)object);
                    }
                } else if (clazz.isArray()) {
                    ArrayList arrayList = new ArrayList();
                    clazz2 = clazz.getComponentType();
                } else {
                    throw new YamlReaderException("A sequence is not a valid value for the type: " + clazz.getName());
                }
                if (!clazz.isArray() && string != null) {
                    this.addAnchor(string, var5_15);
                }
                while (true) {
                    object3 = this.parser.peekNextEvent();
                    if (((Event)object3).type == EventType.SEQUENCE_END) break;
                    var5_15.add(this.readValue(clazz2, null, null));
                }
                this.parser.getNextEvent();
                if (!clazz.isArray()) {
                    return var5_15;
                }
                object = Array.newInstance(clazz2, var5_15.size());
                int n2 = 0;
                for (Object e2 : var5_15) {
                    Array.set(object, n2++, e2);
                }
                if (string != null) {
                    this.addAnchor(string, object);
                }
                return object;
            }
        }
        throw new YamlReaderException("Expected data for a " + clazz.getName() + " field but found: " + (Object)((Object)((Event)object3).type));
    }

    private void mergeMap(Map<String, Object> map, Object object) throws YamlReaderException {
        if (object instanceof Collection) {
            for (Object e2 : (Collection)object) {
                this.mergeMap(map, e2);
            }
        } else if (object instanceof Map) {
            Map map2 = (Map)object;
            for (Map.Entry entry : map2.entrySet()) {
                if (map.containsKey(entry.getKey())) continue;
                map.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            throw new YamlReaderException("Expected a mapping or a sequence of mappings for a '<<' merge field but found: " + object.getClass().getSimpleName());
        }
    }

    protected Object createObject(Class clazz) throws InvocationTargetException {
        DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(clazz, this.config);
        if (deferredConstruction != null) {
            return deferredConstruction;
        }
        return Beans.createObject(clazz, this.config.privateConstructors);
    }

    private Number valueConvertedNumber(String string) {
        Number number = null;
        try {
            number = Long.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (number == null) {
            try {
                number = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }

    private void skipRange() {
        int n2 = 0;
        do {
            Event event = this.parser.getNextEvent();
            switch (event.type) {
                case SEQUENCE_START: {
                    ++n2;
                    break;
                }
                case MAPPING_START: {
                    ++n2;
                    break;
                }
                case SEQUENCE_END: {
                    --n2;
                    break;
                }
                case MAPPING_END: {
                    --n2;
                    break;
                }
            }
        } while (n2 > 0);
    }

    public static void main(String[] stringArray) throws Exception {
        YamlReader yamlReader = new YamlReader(new FileReader("test/test.yml"));
        Object object = yamlReader.read();
        System.out.println(object);
        StringWriter stringWriter = new StringWriter();
        YamlWriter yamlWriter = new YamlWriter(stringWriter);
        yamlWriter.write(object);
        yamlWriter.close();
        System.out.println(stringWriter);
    }

    public class YamlReaderException
    extends YamlException {
        public YamlReaderException(String string, Throwable throwable) {
            super("Line " + YamlReader.this.parser.getLineNumber() + ", column " + YamlReader.this.parser.getColumn() + ": " + string, throwable);
        }

        public YamlReaderException(String string) {
            this(string, null);
        }
    }
}

