/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.emitter;

import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.Version;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.emitter.EmitterConfig;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.emitter.EmitterWriter;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.emitter.ScalarAnalysis;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.CollectionStartEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.DocumentEndEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.DocumentStartEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.Event;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.EventType;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.MappingStartEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.NodeEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.contrastsecurity.thirdparty.com.esotericsoftware.yamlbeans.parser.SequenceStartEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class Emitter {
    private static final Pattern HANDLE_FORMAT = Pattern.compile("^![-\\w]*!$");
    private static final Pattern ANCHOR_FORMAT = Pattern.compile("^[-\\w]*$");
    final EmitterConfig config;
    final EmitterWriter writer;
    final EmitterState[] table = new EmitterState[18];
    int state = 0;
    final List<Integer> states = new ArrayList<Integer>();
    final List<Event> events = new ArrayList<Event>();
    final List<Integer> indents = new ArrayList<Integer>();
    boolean isVersion10 = false;
    Event event;
    int flowLevel = 0;
    int indent = -1;
    boolean mappingContext = false;
    boolean simpleKeyContext = false;
    Map<String, String> tagPrefixes;
    String preparedTag;
    String preparedAnchor;
    ScalarAnalysis analysis;
    char style = '\u0000';
    private static final int S_STREAM_START = 0;
    private static final int S_FIRST_DOCUMENT_START = 1;
    private static final int S_DOCUMENT_ROOT = 2;
    private static final int S_NOTHING = 3;
    private static final int S_DOCUMENT_START = 4;
    private static final int S_DOCUMENT_END = 5;
    private static final int S_FIRST_FLOW_SEQUENCE_ITEM = 6;
    private static final int S_FLOW_SEQUENCE_ITEM = 7;
    private static final int S_FIRST_FLOW_MAPPING_KEY = 8;
    private static final int S_FLOW_MAPPING_SIMPLE_VALUE = 9;
    private static final int S_FLOW_MAPPING_VALUE = 10;
    private static final int S_FLOW_MAPPING_KEY = 11;
    private static final int S_BLOCK_SEQUENCE_ITEM = 12;
    private static final int S_FIRST_BLOCK_MAPPING_KEY = 13;
    private static final int S_BLOCK_MAPPING_SIMPLE_VALUE = 14;
    private static final int S_BLOCK_MAPPING_VALUE = 15;
    private static final int S_BLOCK_MAPPING_KEY = 16;
    private static final int S_FIRST_BLOCK_SEQUENCE_ITEM = 17;
    static final Map<String, String> DEFAULT_TAG_PREFIXES_1_0 = new HashMap<String, String>();
    static final Map<String, String> DEFAULT_TAG_PREFIXES_1_1 = new HashMap<String, String>();

    public Emitter(Writer writer) {
        this(writer, new EmitterConfig());
    }

    public Emitter(Writer writer, EmitterConfig emitterConfig) {
        this.config = emitterConfig;
        if (writer == null) {
            throw new IllegalArgumentException("stream cannot be null.");
        }
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.writer = new EmitterWriter(writer);
        this.initStateTable();
    }

    public void emit(Event event) throws IOException, EmitterException {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null.");
        }
        this.events.add(event);
        while (!this.needMoreEvents()) {
            this.event = this.events.remove(0);
            this.table[this.state].expect();
            this.event = null;
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    private boolean needMoreEvents() {
        if (this.events.isEmpty()) {
            return true;
        }
        this.event = this.events.get(0);
        if (this.event == null) {
            return false;
        }
        switch (this.event.type) {
            case DOCUMENT_START: {
                return this.needEvents(1);
            }
            case SEQUENCE_START: {
                return this.needEvents(2);
            }
            case MAPPING_START: {
                return this.needEvents(3);
            }
        }
        return false;
    }

    private boolean needEvents(int n2) {
        int n3 = 0;
        Iterator<Event> iterator = this.events.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Event event = iterator.next();
            if (event.type == EventType.DOCUMENT_START || event.type == EventType.MAPPING_START || event.type == EventType.SEQUENCE_START) {
                ++n3;
            } else if (event.type == EventType.DOCUMENT_END || event.type == EventType.MAPPING_END || event.type == EventType.SEQUENCE_END) {
                --n3;
            } else if (event.type == EventType.STREAM_END) {
                n3 = -1;
            }
            if (n3 >= 0) continue;
            return false;
        }
        return this.events.size() < n2 + 1;
    }

    private void initStateTable() {
        this.table[0] = new EmitterState(){

            public void expect() {
                if (Emitter.this.event.type != EventType.STREAM_START) {
                    throw new EmitterException("Expected 'stream start' but found: " + Emitter.this.event);
                }
                Emitter.this.writer.writeStreamStart();
                Emitter.this.state = 1;
            }
        };
        this.table[1] = new EmitterState(){

            public void expect() throws IOException {
                if (Emitter.this.event.type == EventType.DOCUMENT_START) {
                    DocumentStartEvent documentStartEvent = (DocumentStartEvent)Emitter.this.event;
                    if (documentStartEvent.version != null) {
                        if (documentStartEvent.version.getMajor() != 1) {
                            throw new EmitterException("Unsupported YAML version: " + documentStartEvent.version);
                        }
                        Emitter.this.writer.writeVersionDirective(documentStartEvent.version.toString());
                    }
                    if (documentStartEvent.version == Version.V1_0) {
                        Emitter.this.isVersion10 = true;
                        Emitter.this.tagPrefixes = new HashMap<String, String>(DEFAULT_TAG_PREFIXES_1_0);
                    } else {
                        Emitter.this.tagPrefixes = new HashMap<String, String>(DEFAULT_TAG_PREFIXES_1_1);
                    }
                    if (documentStartEvent.tags != null) {
                        TreeSet<String> treeSet = new TreeSet<String>();
                        treeSet.addAll(documentStartEvent.tags.keySet());
                        for (String string : treeSet) {
                            String string2 = documentStartEvent.tags.get(string);
                            Emitter.this.tagPrefixes.put(string2, string);
                            String string3 = Emitter.this.prepareTagHandle(string);
                            String string4 = Emitter.this.prepareTagPrefix(string2);
                            Emitter.this.writer.writeTagDirective(string3, string4);
                        }
                    }
                }
                Emitter.this.expectDocumentStart(true);
            }
        };
        this.table[2] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.states.add(0, 5);
                Emitter.this.expectNode(true, false, false, false);
            }
        };
        this.table[3] = new EmitterState(){

            public void expect() {
                throw new EmitterException("Expected no event but found: " + Emitter.this.event);
            }
        };
        this.table[4] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.expectDocumentStart(false);
            }
        };
        this.table[5] = new EmitterState(){

            public void expect() throws IOException {
                if (Emitter.this.event.type == EventType.DOCUMENT_END) {
                    Emitter.this.writer.writeIndent(Emitter.this.indent);
                    if (((DocumentEndEvent)Emitter.this.event).isExplicit) {
                        Emitter.this.writer.writeIndicator("...", true, false, false);
                        Emitter.this.writer.writeIndent(Emitter.this.indent);
                    }
                } else {
                    throw new EmitterException("Expected 'document end' but found: " + Emitter.this.event);
                }
                Emitter.this.writer.flushStream();
                Emitter.this.state = 4;
            }
        };
        this.table[6] = new EmitterState(){

            public void expect() throws IOException {
                if (Emitter.this.event.type == EventType.SEQUENCE_END) {
                    Emitter.this.indent = Emitter.this.indents.remove(0);
                    --Emitter.this.flowLevel;
                    Emitter.this.writer.writeIndicator("]", false, false, false);
                    Emitter.this.state = Emitter.this.states.remove(0);
                } else {
                    if (Emitter.this.config.prettyFlow) {
                        Emitter.this.writer.writeIndent(Emitter.this.flowLevel * Emitter.this.config.indentSize);
                    }
                    if (Emitter.this.config.canonical || Emitter.this.writer.column > Emitter.this.config.wrapColumn) {
                        Emitter.this.writer.writeIndent(Emitter.this.indent);
                    }
                    Emitter.this.states.add(0, 7);
                    Emitter.this.expectNode(false, true, false, false);
                }
            }
        };
        this.table[7] = new EmitterState(){

            public void expect() throws IOException {
                if (Emitter.this.event.type == EventType.SEQUENCE_END) {
                    Emitter.this.indent = Emitter.this.indents.remove(0);
                    --Emitter.this.flowLevel;
                    if (Emitter.this.config.prettyFlow) {
                        Emitter.this.writer.writeIndent(Emitter.this.flowLevel * Emitter.this.config.indentSize);
                    }
                    if (Emitter.this.config.canonical) {
                        Emitter.this.writer.writeIndent(Emitter.this.indent);
                    }
                    Emitter.this.writer.writeIndicator("]", false, false, false);
                    Emitter.this.state = Emitter.this.states.remove(0);
                } else {
                    Emitter.this.writer.writeIndicator(",", false, false, false);
                    if (Emitter.this.config.prettyFlow) {
                        Emitter.this.writer.writeIndent(Emitter.this.flowLevel * Emitter.this.config.indentSize);
                    }
                    if (Emitter.this.config.canonical || Emitter.this.writer.column > Emitter.this.config.wrapColumn) {
                        Emitter.this.writer.writeIndent(Emitter.this.indent);
                    }
                    Emitter.this.states.add(0, 7);
                    Emitter.this.expectNode(false, true, false, false);
                }
            }
        };
        this.table[8] = new EmitterState(){

            public void expect() throws IOException {
                if (Emitter.this.event.type == EventType.MAPPING_END) {
                    Emitter.this.indent = Emitter.this.indents.remove(0);
                    --Emitter.this.flowLevel;
                    Emitter.this.writer.writeIndicator("}", false, false, false);
                    Emitter.this.state = Emitter.this.states.remove(0);
                } else {
                    if (Emitter.this.config.prettyFlow) {
                        Emitter.this.writer.writeIndent(Emitter.this.flowLevel * Emitter.this.config.indentSize);
                    }
                    if (Emitter.this.config.canonical || Emitter.this.writer.column > Emitter.this.config.wrapColumn) {
                        Emitter.this.writer.writeIndent(Emitter.this.indent);
                    }
                    if (!Emitter.this.config.canonical && Emitter.this.checkSimpleKey()) {
                        Emitter.this.states.add(0, 9);
                        Emitter.this.expectNode(false, false, true, true);
                    } else {
                        Emitter.this.writer.writeIndicator("?", true, false, false);
                        Emitter.this.states.add(0, 10);
                        Emitter.this.expectNode(false, false, true, false);
                    }
                }
            }
        };
        this.table[9] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.writer.writeIndicator(": ", false, true, false);
                Emitter.this.states.add(0, 11);
                Emitter.this.expectNode(false, false, true, false);
            }
        };
        this.table[10] = new EmitterState(){

            public void expect() throws IOException {
                if (Emitter.this.config.canonical || Emitter.this.writer.column > Emitter.this.config.wrapColumn) {
                    Emitter.this.writer.writeIndent(Emitter.this.indent);
                }
                Emitter.this.writer.writeIndicator(": ", false, true, false);
                Emitter.this.states.add(0, 11);
                Emitter.this.expectNode(false, false, true, false);
            }
        };
        this.table[11] = new EmitterState(){

            public void expect() throws IOException {
                if (Emitter.this.event.type == EventType.MAPPING_END) {
                    Emitter.this.indent = Emitter.this.indents.remove(0);
                    --Emitter.this.flowLevel;
                    if (Emitter.this.config.prettyFlow) {
                        Emitter.this.writer.writeIndent(Emitter.this.flowLevel * Emitter.this.config.indentSize);
                    }
                    if (Emitter.this.config.canonical) {
                        Emitter.this.writer.writeIndent(Emitter.this.indent);
                    }
                    Emitter.this.writer.writeIndicator("}", false, false, false);
                    Emitter.this.state = Emitter.this.states.remove(0);
                } else {
                    Emitter.this.writer.writeIndicator(",", false, false, false);
                    if (Emitter.this.config.prettyFlow) {
                        Emitter.this.writer.writeIndent(Emitter.this.flowLevel * Emitter.this.config.indentSize);
                    }
                    if (Emitter.this.config.canonical || Emitter.this.writer.column > Emitter.this.config.wrapColumn) {
                        Emitter.this.writer.writeIndent(Emitter.this.indent);
                    }
                    if (!Emitter.this.config.canonical && Emitter.this.checkSimpleKey()) {
                        Emitter.this.states.add(0, 9);
                        Emitter.this.expectNode(false, false, true, true);
                    } else {
                        Emitter.this.writer.writeIndicator("?", true, false, false);
                        Emitter.this.states.add(0, 10);
                        Emitter.this.expectNode(false, false, true, false);
                    }
                }
            }
        };
        this.table[12] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.expectBlockSequenceItem(false);
            }
        };
        this.table[13] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.expectBlockMappingKey(true);
            }
        };
        this.table[14] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.writer.writeIndicator(": ", false, true, false);
                Emitter.this.states.add(0, 16);
                Emitter.this.expectNode(false, false, true, false);
            }
        };
        this.table[15] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.writer.writeIndent(Emitter.this.indent);
                Emitter.this.writer.writeIndicator(": ", true, true, true);
                Emitter.this.states.add(0, 16);
                Emitter.this.expectNode(false, false, true, false);
            }
        };
        this.table[16] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.expectBlockMappingKey(false);
            }
        };
        this.table[17] = new EmitterState(){

            public void expect() throws IOException {
                Emitter.this.expectBlockSequenceItem(true);
            }
        };
    }

    private void increaseIndent(boolean bl2, boolean bl3) {
        this.indents.add(0, this.indent);
        if (this.indent == -1) {
            this.indent = bl2 ? this.config.indentSize : 0;
        } else if (!bl3) {
            this.indent += this.config.indentSize;
        }
    }

    void expectDocumentStart(boolean bl2) throws IOException {
        if (this.event.type == EventType.DOCUMENT_START) {
            boolean bl3;
            DocumentStartEvent documentStartEvent = (DocumentStartEvent)this.event;
            boolean bl4 = bl3 = bl2 && !documentStartEvent.isExplicit && !this.config.canonical && documentStartEvent.version == null && documentStartEvent.tags == null && !this.checkEmptyDocument();
            if (!bl3) {
                this.writer.writeIndent(this.indent);
                this.writer.writeIndicator("--- ", true, true, false);
                if (this.config.canonical) {
                    this.writer.writeIndent(this.indent);
                }
            }
            this.state = 2;
        } else if (this.event.type == EventType.STREAM_END) {
            this.writer.writeStreamEnd();
            this.state = 3;
        } else {
            throw new EmitterException("Expected 'document start' but found: " + this.event);
        }
    }

    void expectBlockSequenceItem(boolean bl2) throws IOException {
        if (!bl2 && this.event.type == EventType.SEQUENCE_END) {
            this.indent = this.indents.remove(0);
            this.state = this.states.remove(0);
        } else {
            this.writer.writeIndent(this.indent);
            this.writer.writeIndicator("-", true, false, true);
            this.states.add(0, 12);
            this.expectNode(false, true, false, false);
        }
    }

    void expectBlockMappingKey(boolean bl2) throws IOException {
        if (!bl2 && this.event.type == EventType.MAPPING_END) {
            this.indent = this.indents.remove(0);
            this.state = this.states.remove(0);
        } else {
            this.writer.writeIndent(this.indent);
            if (this.checkSimpleKey()) {
                this.states.add(0, 14);
                this.expectNode(false, false, true, true);
            } else {
                this.writer.writeIndicator("?", true, false, true);
                this.states.add(0, 15);
                this.expectNode(false, false, true, false);
            }
        }
    }

    void expectNode(boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IOException {
        this.mappingContext = bl4;
        this.simpleKeyContext = bl5;
        if (this.event.type == EventType.ALIAS) {
            this.expectAlias();
        } else if (this.event.type == EventType.SCALAR || this.event.type == EventType.MAPPING_START || this.event.type == EventType.SEQUENCE_START) {
            this.processAnchor("&");
            this.processTag();
            if (this.event.type == EventType.SCALAR) {
                this.expectScalar();
            } else if (this.event.type == EventType.SEQUENCE_START) {
                if (this.flowLevel != 0 || this.config.canonical || ((SequenceStartEvent)this.event).isFlowStyle || this.checkEmptySequence()) {
                    this.expectFlowSequence();
                } else {
                    this.expectBlockSequence();
                }
            } else if (this.event.type == EventType.MAPPING_START) {
                if (this.flowLevel != 0 || this.config.canonical || ((MappingStartEvent)this.event).isFlowStyle || this.checkEmptyMapping()) {
                    this.expectFlowMapping();
                } else {
                    this.expectBlockMapping();
                }
            }
        } else {
            throw new EmitterException("Expected 'scalar', 'mapping start', or 'sequence start' but found: " + this.event);
        }
    }

    private void expectAlias() throws IOException {
        if (((NodeEvent)this.event).anchor == null) {
            throw new EmitterException("Anchor is not specified for alias.");
        }
        this.processAnchor("*");
        this.state = this.states.remove(0);
    }

    private void expectScalar() throws IOException {
        this.increaseIndent(true, false);
        this.processScalar();
        this.indent = this.indents.remove(0);
        this.state = this.states.remove(0);
    }

    private void expectFlowSequence() throws IOException {
        this.writer.writeIndicator("[", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        this.state = 6;
    }

    private void expectBlockSequence() {
        this.increaseIndent(false, this.mappingContext && !this.writer.indentation);
        this.state = 17;
    }

    private void expectFlowMapping() throws IOException {
        this.writer.writeIndicator("{", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        this.state = 8;
    }

    private void expectBlockMapping() {
        this.increaseIndent(false, false);
        this.state = 13;
    }

    private boolean checkEmptySequence() {
        return this.event.type == EventType.SEQUENCE_START && !this.events.isEmpty() && this.events.get((int)0).type == EventType.SEQUENCE_END;
    }

    private boolean checkEmptyMapping() {
        return this.event.type == EventType.MAPPING_START && !this.events.isEmpty() && this.events.get((int)0).type == EventType.MAPPING_END;
    }

    private boolean checkEmptyDocument() {
        if (this.event.type != EventType.DOCUMENT_START || this.events.isEmpty()) {
            return false;
        }
        Event event = this.events.get(0);
        return event.type == EventType.SCALAR && ((ScalarEvent)event).anchor == null && ((ScalarEvent)event).tag == null && ((ScalarEvent)event).implicit != null && ((ScalarEvent)event).value.equals("");
    }

    boolean checkSimpleKey() {
        int n2 = 0;
        if (this.event instanceof NodeEvent && ((NodeEvent)this.event).anchor != null) {
            if (this.preparedAnchor == null) {
                this.preparedAnchor = this.prepareAnchor(((NodeEvent)this.event).anchor);
            }
            n2 += this.preparedAnchor.length();
        }
        String string = null;
        if (this.event.type == EventType.SCALAR) {
            string = ((ScalarEvent)this.event).tag;
        } else if (this.event.type == EventType.MAPPING_START || this.event.type == EventType.SEQUENCE_START) {
            string = ((CollectionStartEvent)this.event).tag;
        }
        if (string != null) {
            if (this.preparedTag == null) {
                this.preparedTag = this.prepareTag(string);
            }
            n2 += this.preparedTag.length();
        }
        if (this.event.type == EventType.SCALAR && this.analysis == null) {
            this.analysis = ScalarAnalysis.analyze(((ScalarEvent)this.event).value, this.config.escapeUnicode);
            n2 += this.analysis.scalar.length();
        }
        return n2 < 1024 && (this.event.type == EventType.ALIAS || this.event.type == EventType.SCALAR && !this.analysis.empty && !this.analysis.multiline || this.checkEmptySequence() || this.checkEmptyMapping());
    }

    private void processAnchor(String string) throws IOException {
        NodeEvent nodeEvent = (NodeEvent)this.event;
        if (nodeEvent.anchor == null) {
            this.preparedAnchor = null;
            return;
        }
        if (this.preparedAnchor == null) {
            this.preparedAnchor = this.prepareAnchor(nodeEvent.anchor);
        }
        if (this.preparedAnchor != null && !"".equals(this.preparedAnchor)) {
            this.writer.writeIndicator(string + this.preparedAnchor, true, false, false);
        }
        this.preparedAnchor = null;
    }

    private void processTag() throws IOException {
        String string = null;
        if (this.event.type == EventType.SCALAR) {
            ScalarEvent scalarEvent = (ScalarEvent)this.event;
            string = scalarEvent.tag;
            if (this.style == '\u0000') {
                this.style = this.chooseScalarStyle();
            }
            if ((!this.config.canonical || string == null) && ('\u0000' == this.style && scalarEvent.implicit[0] || '\u0000' != this.style && scalarEvent.implicit[1])) {
                this.preparedTag = null;
                return;
            }
            if (scalarEvent.implicit[0] && string == null) {
                string = "!";
                this.preparedTag = null;
            }
        } else {
            CollectionStartEvent collectionStartEvent = (CollectionStartEvent)this.event;
            string = collectionStartEvent.tag;
            if ((!this.config.canonical || string == null) && collectionStartEvent.isImplicit) {
                this.preparedTag = null;
                return;
            }
        }
        if (string == null) {
            throw new EmitterException("Tag is not specified.");
        }
        if (this.preparedTag == null) {
            this.preparedTag = this.prepareTag(string);
        }
        if (this.preparedTag != null && !"".equals(this.preparedTag)) {
            this.writer.writeIndicator(this.preparedTag, true, false, false);
        }
        this.preparedTag = null;
    }

    private char chooseScalarStyle() {
        ScalarEvent scalarEvent = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = ScalarAnalysis.analyze(scalarEvent.value, this.config.escapeUnicode);
        }
        if (scalarEvent.style == '\"' || this.config.canonical) {
            return '\"';
        }
        if ((scalarEvent.style == '\u0000' || scalarEvent.style == '|' || scalarEvent.style == '>') && (!this.simpleKeyContext || !this.analysis.empty && !this.analysis.multiline) && (this.flowLevel != 0 && this.analysis.allowFlowPlain || this.flowLevel == 0 && this.analysis.allowBlockPlain)) {
            return '\u0000';
        }
        if (!(scalarEvent.style != '\u0000' && scalarEvent.style != '\'' || !this.analysis.allowSingleQuoted || this.simpleKeyContext && this.analysis.multiline)) {
            return '\'';
        }
        if ((scalarEvent.style == '\u0000' || scalarEvent.style == '|' || scalarEvent.style == '>') && this.analysis.multiline && this.flowLevel == 0 && this.analysis.allowBlock) {
            return scalarEvent.style == '\u0000' ? (char)'|' : (char)scalarEvent.style;
        }
        return '\"';
    }

    private void processScalar() throws IOException {
        boolean bl2;
        ScalarEvent scalarEvent = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = ScalarAnalysis.analyze(scalarEvent.value, this.config.escapeUnicode);
        }
        if (this.style == '\u0000') {
            this.style = this.chooseScalarStyle();
        }
        boolean bl3 = bl2 = !this.simpleKeyContext;
        if (this.style == '\"') {
            this.writer.writeDoubleQuoted(this.analysis.scalar, bl2, this.indent, this.config.wrapColumn, this.config.escapeUnicode);
        } else if (this.style == '\'') {
            this.writer.writeSingleQuoted(this.analysis.scalar, bl2, this.indent, this.config.wrapColumn);
        } else if (this.style == '>') {
            this.writer.writeFolded(this.analysis.scalar, this.indent, this.config.wrapColumn);
        } else if (this.style == '|') {
            this.writer.writeLiteral(this.analysis.scalar, this.indent);
        } else {
            this.writer.writePlain(this.analysis.scalar, bl2, this.indent, this.config.wrapColumn);
        }
        this.analysis = null;
        this.style = '\u0000';
    }

    private String prepareTag(String string) {
        int n2;
        if (string == null || "".equals(string)) {
            throw new EmitterException("Tag cannot be empty.");
        }
        if (string.equals("!")) {
            return string;
        }
        String string2 = null;
        String string3 = string;
        for (String string4 : this.tagPrefixes.keySet()) {
            if (!string.startsWith(string4) || !string4.equals("!") && string4.length() >= string.length()) continue;
            string2 = this.tagPrefixes.get(string4);
            string3 = string.substring(string4.length());
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (n2 = 0; n2 < string3.length(); ++n2) {
        }
        if (n3 < n2) {
            stringBuilder.append(string3.substring(n3, n2));
        }
        String string5 = stringBuilder.toString();
        if (string.charAt(0) == '!' && this.isVersion10) {
            return string;
        }
        if (string2 != null) {
            return string2 + string5;
        }
        if (this.config.useVerbatimTags) {
            return "!<" + string5 + ">";
        }
        return "!" + string5;
    }

    String prepareTagHandle(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("Tag handle cannot be empty.");
        }
        if (string.charAt(0) != '!' || string.charAt(string.length() - 1) != '!') {
            throw new EmitterException("Tag handle must begin and end with '!': " + string);
        }
        if (!"!".equals(string) && !HANDLE_FORMAT.matcher(string).matches()) {
            throw new EmitterException("Invalid syntax for tag handle: " + string);
        }
        return string;
    }

    String prepareTagPrefix(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("Tag prefix cannot be empty.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        if (string.charAt(0) == '!') {
            n3 = 1;
        }
        while (n3 < string.length()) {
            ++n3;
        }
        if (n2 < n3) {
            stringBuilder.append(string.substring(n2, n3));
        }
        return stringBuilder.toString();
    }

    private String prepareAnchor(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("Anchor cannot be empty.");
        }
        if (!ANCHOR_FORMAT.matcher(string).matches()) {
            throw new EmitterException("Invalid syntax for anchor: " + string);
        }
        return string;
    }

    static {
        DEFAULT_TAG_PREFIXES_1_0.put("tag:yaml.org,2002:", "!");
        DEFAULT_TAG_PREFIXES_1_1.put("!", "!");
        DEFAULT_TAG_PREFIXES_1_1.put("tag:yaml.org,2002:", "!!");
    }

    private static interface EmitterState {
        public void expect() throws IOException;
    }
}

