/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.gson.internal.bind;

import com.contrastsecurity.thirdparty.com.google.gson.Gson;
import com.contrastsecurity.thirdparty.com.google.gson.JsonElement;
import com.contrastsecurity.thirdparty.com.google.gson.JsonPrimitive;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSyntaxException;
import com.contrastsecurity.thirdparty.com.google.gson.TypeAdapter;
import com.contrastsecurity.thirdparty.com.google.gson.TypeAdapterFactory;
import com.contrastsecurity.thirdparty.com.google.gson.internal.$Gson$Types;
import com.contrastsecurity.thirdparty.com.google.gson.internal.ConstructorConstructor;
import com.contrastsecurity.thirdparty.com.google.gson.internal.JsonReaderInternalAccess;
import com.contrastsecurity.thirdparty.com.google.gson.internal.ObjectConstructor;
import com.contrastsecurity.thirdparty.com.google.gson.internal.Streams;
import com.contrastsecurity.thirdparty.com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.contrastsecurity.thirdparty.com.google.gson.internal.bind.TypeAdapters;
import com.contrastsecurity.thirdparty.com.google.gson.reflect.TypeToken;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonReader;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonToken;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public final class MapTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    final boolean complexMapKeySerialization;

    public MapTypeAdapterFactory(ConstructorConstructor constructorConstructor, boolean bl2) {
        this.constructorConstructor = constructorConstructor;
        this.complexMapKeySerialization = bl2;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> clazz = typeToken.getRawType();
        if (!Map.class.isAssignableFrom(clazz)) {
            return null;
        }
        Type[] typeArray = $Gson$Types.getMapKeyAndValueTypes(type, clazz);
        TypeAdapter<?> typeAdapter = this.getKeyAdapter(gson, typeArray[0]);
        TypeAdapter<?> typeAdapter2 = gson.getAdapter(TypeToken.get(typeArray[1]));
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        Adapter adapter = new Adapter(gson, typeArray[0], typeAdapter, typeArray[1], typeAdapter2, objectConstructor);
        return adapter;
    }

    private TypeAdapter<?> getKeyAdapter(Gson gson, Type type) {
        return type == Boolean.TYPE || type == Boolean.class ? TypeAdapters.BOOLEAN_AS_STRING : gson.getAdapter(TypeToken.get(type));
    }

    private final class Adapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;
        private final ObjectConstructor<? extends Map<K, V>> constructor;

        public Adapter(Gson gson, Type type, TypeAdapter<K> typeAdapter, Type type2, TypeAdapter<V> typeAdapter2, ObjectConstructor<? extends Map<K, V>> objectConstructor) {
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(gson, typeAdapter, type);
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>(gson, typeAdapter2, type2);
            this.constructor = objectConstructor;
        }

        @Override
        public Map<K, V> read(JsonReader jsonReader) throws IOException {
            JsonToken jsonToken = jsonReader.peek();
            if (jsonToken == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            Map<K, V> map = this.constructor.construct();
            if (jsonToken == JsonToken.BEGIN_ARRAY) {
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    jsonReader.beginArray();
                    K k2 = this.keyTypeAdapter.read(jsonReader);
                    V v2 = this.valueTypeAdapter.read(jsonReader);
                    V v3 = map.put(k2, v2);
                    if (v3 != null) {
                        throw new JsonSyntaxException("duplicate key: " + k2);
                    }
                    jsonReader.endArray();
                }
                jsonReader.endArray();
            } else {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    V v4;
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue(jsonReader);
                    K k3 = this.keyTypeAdapter.read(jsonReader);
                    V v5 = map.put(k3, v4 = this.valueTypeAdapter.read(jsonReader));
                    if (v5 == null) continue;
                    throw new JsonSyntaxException("duplicate key: " + k3);
                }
                jsonReader.endObject();
            }
            return map;
        }

        @Override
        public void write(JsonWriter jsonWriter, Map<K, V> map) throws IOException {
            JsonElement jsonElement;
            if (map == null) {
                jsonWriter.nullValue();
                return;
            }
            if (!MapTypeAdapterFactory.this.complexMapKeySerialization) {
                jsonWriter.beginObject();
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    jsonWriter.name(String.valueOf(entry.getKey()));
                    this.valueTypeAdapter.write(jsonWriter, entry.getValue());
                }
                jsonWriter.endObject();
                return;
            }
            boolean bl2 = false;
            ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>(map.size());
            ArrayList<V> arrayList2 = new ArrayList<V>(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                jsonElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
                arrayList.add(jsonElement);
                arrayList2.add(entry.getValue());
                bl2 |= jsonElement.isJsonArray() || jsonElement.isJsonObject();
            }
            if (bl2) {
                jsonWriter.beginArray();
                int n2 = arrayList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    jsonWriter.beginArray();
                    Streams.write((JsonElement)arrayList.get(i2), jsonWriter);
                    this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i2));
                    jsonWriter.endArray();
                }
                jsonWriter.endArray();
            } else {
                jsonWriter.beginObject();
                int n3 = arrayList.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    jsonElement = (JsonElement)arrayList.get(i3);
                    jsonWriter.name(this.keyToString(jsonElement));
                    this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i3));
                }
                jsonWriter.endObject();
            }
        }

        private String keyToString(JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                if (jsonPrimitive.isNumber()) {
                    return String.valueOf(jsonPrimitive.getAsNumber());
                }
                if (jsonPrimitive.isBoolean()) {
                    return Boolean.toString(jsonPrimitive.getAsBoolean());
                }
                if (jsonPrimitive.isString()) {
                    return jsonPrimitive.getAsString();
                }
                throw new AssertionError();
            }
            if (jsonElement.isJsonNull()) {
                return "null";
            }
            throw new AssertionError();
        }
    }
}

