/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.DescriptorProtos;
import com.contrastsecurity.thirdparty.com.google.protobuf.ExtensionRegistry;
import com.contrastsecurity.thirdparty.com.google.protobuf.ExtensionRegistryLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.FieldSet;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import com.contrastsecurity.thirdparty.com.google.protobuf.Message;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.TextFormat;
import com.contrastsecurity.thirdparty.com.google.protobuf.WireFormat;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Descriptors {
    private static final e logger = e.a(Descriptors.class.getName());
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Descriptor[] EMPTY_DESCRIPTORS = new Descriptor[0];
    private static final FieldDescriptor[] EMPTY_FIELD_DESCRIPTORS = new FieldDescriptor[0];
    private static final EnumDescriptor[] EMPTY_ENUM_DESCRIPTORS = new EnumDescriptor[0];
    private static final ServiceDescriptor[] EMPTY_SERVICE_DESCRIPTORS = new ServiceDescriptor[0];
    private static final OneofDescriptor[] EMPTY_ONEOF_DESCRIPTORS = new OneofDescriptor[0];

    private static String computeFullName(FileDescriptor fileDescriptor, Descriptor descriptor, String string) {
        if (descriptor != null) {
            return descriptor.getFullName() + '.' + string;
        }
        String string2 = fileDescriptor.getPackage();
        if (!string2.isEmpty()) {
            return string2 + '.' + string;
        }
        return string;
    }

    private static <T> T binarySearch(T[] TArray, int n2, NumberGetter<T> numberGetter, int n3) {
        int n4 = 0;
        int n5 = n2 - 1;
        while (n4 <= n5) {
            int n6 = (n4 + n5) / 2;
            T t2 = TArray[n6];
            int n7 = numberGetter.getNumber(t2);
            if (n3 < n7) {
                n5 = n6 - 1;
                continue;
            }
            if (n3 > n7) {
                n4 = n6 + 1;
                continue;
            }
            return t2;
        }
        return null;
    }

    private static interface NumberGetter<T> {
        public int getNumber(T var1);
    }

    public static final class OneofDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.OneofDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private Descriptor containingType;
        private int fieldCount;
        private FieldDescriptor[] fields;

        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        public DescriptorProtos.OneofOptions getOptions() {
            return this.proto.getOptions();
        }

        public boolean isSynthetic() {
            return this.fields.length == 1 && this.fields[0].isProto3Optional;
        }

        public List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public FieldDescriptor getField(int n2) {
            return this.fields[n2];
        }

        @Override
        public DescriptorProtos.OneofDescriptorProto toProto() {
            return this.proto;
        }

        private void setProto(DescriptorProtos.OneofDescriptorProto oneofDescriptorProto) {
            this.proto = oneofDescriptorProto;
        }

        private OneofDescriptor(DescriptorProtos.OneofDescriptorProto oneofDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n2) throws DescriptorValidationException {
            this.proto = oneofDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, oneofDescriptorProto.getName());
            this.file = fileDescriptor;
            this.index = n2;
            this.containingType = descriptor;
            this.fieldCount = 0;
        }

        static /* synthetic */ FieldDescriptor[] access$2502(OneofDescriptor oneofDescriptor, FieldDescriptor[] fieldDescriptorArray) {
            oneofDescriptor.fields = fieldDescriptorArray;
            return fieldDescriptorArray;
        }
    }

    private static final class DescriptorPool {
        private final Set<FileDescriptor> dependencies;
        private boolean allowUnknownDependencies;
        private final Map<String, GenericDescriptor> descriptorsByName = new HashMap<String, GenericDescriptor>();

        DescriptorPool(FileDescriptor[] fileDescriptorArray, boolean bl2) {
            this.dependencies = Collections.newSetFromMap(new IdentityHashMap(fileDescriptorArray.length));
            this.allowUnknownDependencies = bl2;
            for (FileDescriptor fileDescriptor : fileDescriptorArray) {
                this.dependencies.add(fileDescriptor);
                this.importPublicDependencies(fileDescriptor);
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                try {
                    this.addPackage(fileDescriptor.getPackage(), fileDescriptor);
                }
                catch (DescriptorValidationException descriptorValidationException) {
                    throw new AssertionError((Object)descriptorValidationException);
                }
            }
        }

        private void importPublicDependencies(FileDescriptor fileDescriptor) {
            for (FileDescriptor fileDescriptor2 : fileDescriptor.getPublicDependencies()) {
                if (!this.dependencies.add(fileDescriptor2)) continue;
                this.importPublicDependencies(fileDescriptor2);
            }
        }

        GenericDescriptor findSymbol(String string) {
            return this.findSymbol(string, SearchFilter.ALL_SYMBOLS);
        }

        GenericDescriptor findSymbol(String string, SearchFilter searchFilter) {
            GenericDescriptor genericDescriptor = this.descriptorsByName.get(string);
            if (genericDescriptor != null && (searchFilter == SearchFilter.ALL_SYMBOLS || searchFilter == SearchFilter.TYPES_ONLY && this.isType(genericDescriptor) || searchFilter == SearchFilter.AGGREGATES_ONLY && this.isAggregate(genericDescriptor))) {
                return genericDescriptor;
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                genericDescriptor = ((FileDescriptor)fileDescriptor).pool.descriptorsByName.get(string);
                if (genericDescriptor == null || searchFilter != SearchFilter.ALL_SYMBOLS && (searchFilter != SearchFilter.TYPES_ONLY || !this.isType(genericDescriptor)) && (searchFilter != SearchFilter.AGGREGATES_ONLY || !this.isAggregate(genericDescriptor))) continue;
                return genericDescriptor;
            }
            return null;
        }

        boolean isType(GenericDescriptor genericDescriptor) {
            return genericDescriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor;
        }

        boolean isAggregate(GenericDescriptor genericDescriptor) {
            return genericDescriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor || genericDescriptor instanceof PackageDescriptor || genericDescriptor instanceof ServiceDescriptor;
        }

        GenericDescriptor lookupSymbol(String string, GenericDescriptor genericDescriptor, SearchFilter searchFilter) throws DescriptorValidationException {
            GenericDescriptor genericDescriptor2;
            String string2;
            if (string.startsWith(".")) {
                string2 = string.substring(1);
                genericDescriptor2 = this.findSymbol(string2, searchFilter);
            } else {
                int n2 = string.indexOf(46);
                String string3 = n2 == -1 ? string : string.substring(0, n2);
                StringBuilder stringBuilder = new StringBuilder(genericDescriptor.getFullName());
                while (true) {
                    int n3;
                    if ((n3 = stringBuilder.lastIndexOf(".")) == -1) {
                        string2 = string;
                        genericDescriptor2 = this.findSymbol(string, searchFilter);
                        break;
                    }
                    stringBuilder.setLength(n3 + 1);
                    stringBuilder.append(string3);
                    genericDescriptor2 = this.findSymbol(stringBuilder.toString(), SearchFilter.AGGREGATES_ONLY);
                    if (genericDescriptor2 != null) {
                        if (n2 != -1) {
                            stringBuilder.setLength(n3 + 1);
                            stringBuilder.append(string);
                            genericDescriptor2 = this.findSymbol(stringBuilder.toString(), searchFilter);
                        }
                        string2 = stringBuilder.toString();
                        break;
                    }
                    stringBuilder.setLength(n3);
                }
            }
            if (genericDescriptor2 == null) {
                if (this.allowUnknownDependencies && searchFilter == SearchFilter.TYPES_ONLY) {
                    logger.c("The descriptor for message type \"" + string + "\" can not be found and a placeholder is created for it");
                    genericDescriptor2 = new Descriptor(string2);
                    this.dependencies.add(genericDescriptor2.getFile());
                    return genericDescriptor2;
                }
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is not defined.");
            }
            return genericDescriptor2;
        }

        void addSymbol(GenericDescriptor genericDescriptor) throws DescriptorValidationException {
            DescriptorPool.validateSymbolName(genericDescriptor);
            String string = genericDescriptor.getFullName();
            GenericDescriptor genericDescriptor2 = this.descriptorsByName.put(string, genericDescriptor);
            if (genericDescriptor2 != null) {
                this.descriptorsByName.put(string, genericDescriptor2);
                if (genericDescriptor.getFile() == genericDescriptor2.getFile()) {
                    int n2 = string.lastIndexOf(46);
                    if (n2 == -1) {
                        throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is already defined.");
                    }
                    throw new DescriptorValidationException(genericDescriptor, '\"' + string.substring(n2 + 1) + "\" is already defined in \"" + string.substring(0, n2) + "\".");
                }
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is already defined in file \"" + genericDescriptor2.getFile().getName() + "\".");
            }
        }

        void addPackage(String string, FileDescriptor fileDescriptor) throws DescriptorValidationException {
            String string2;
            int n2 = string.lastIndexOf(46);
            if (n2 == -1) {
                string2 = string;
            } else {
                this.addPackage(string.substring(0, n2), fileDescriptor);
                string2 = string.substring(n2 + 1);
            }
            GenericDescriptor genericDescriptor = this.descriptorsByName.put(string, new PackageDescriptor(string2, string, fileDescriptor));
            if (genericDescriptor != null) {
                this.descriptorsByName.put(string, genericDescriptor);
                if (!(genericDescriptor instanceof PackageDescriptor)) {
                    throw new DescriptorValidationException(fileDescriptor, '\"' + string2 + "\" is already defined (as something other than a package) in file \"" + genericDescriptor.getFile().getName() + "\".");
                }
            }
        }

        static void validateSymbolName(GenericDescriptor genericDescriptor) throws DescriptorValidationException {
            String string = genericDescriptor.getName();
            if (string.length() == 0) {
                throw new DescriptorValidationException(genericDescriptor, "Missing name.");
            }
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || c2 == '_' || '0' <= c2 && c2 <= '9' && i2 > 0) continue;
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is not a valid identifier.");
            }
        }

        private static final class PackageDescriptor
        extends GenericDescriptor {
            private final String name;
            private final String fullName;
            private final FileDescriptor file;

            @Override
            public Message toProto() {
                return this.file.toProto();
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getFullName() {
                return this.fullName;
            }

            @Override
            public FileDescriptor getFile() {
                return this.file;
            }

            PackageDescriptor(String string, String string2, FileDescriptor fileDescriptor) {
                this.file = fileDescriptor;
                this.fullName = string2;
                this.name = string;
            }
        }

        static enum SearchFilter {
            TYPES_ONLY,
            AGGREGATES_ONLY,
            ALL_SYMBOLS;

        }
    }

    public static class DescriptorValidationException
    extends Exception {
        private static final long serialVersionUID = 5750205775490483148L;
        private final String name;
        private final Message proto;
        private final String description;

        public String getProblemSymbolName() {
            return this.name;
        }

        public Message getProblemProto() {
            return this.proto;
        }

        public String getDescription() {
            return this.description;
        }

        private DescriptorValidationException(GenericDescriptor genericDescriptor, String string) {
            super(genericDescriptor.getFullName() + ": " + string);
            this.name = genericDescriptor.getFullName();
            this.proto = genericDescriptor.toProto();
            this.description = string;
        }

        private DescriptorValidationException(GenericDescriptor genericDescriptor, String string, Throwable throwable) {
            this(genericDescriptor, string);
            this.initCause(throwable);
        }

        private DescriptorValidationException(FileDescriptor fileDescriptor, String string) {
            super(fileDescriptor.getName() + ": " + string);
            this.name = fileDescriptor.getName();
            this.proto = fileDescriptor.toProto();
            this.description = string;
        }
    }

    public static abstract class GenericDescriptor {
        private GenericDescriptor() {
        }

        public abstract Message toProto();

        public abstract String getName();

        public abstract String getFullName();

        public abstract FileDescriptor getFile();
    }

    public static final class MethodDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.MethodDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final ServiceDescriptor service;
        private Descriptor inputType;
        private Descriptor outputType;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.MethodDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public ServiceDescriptor getService() {
            return this.service;
        }

        public Descriptor getInputType() {
            return this.inputType;
        }

        public Descriptor getOutputType() {
            return this.outputType;
        }

        public boolean isClientStreaming() {
            return this.proto.getClientStreaming();
        }

        public boolean isServerStreaming() {
            return this.proto.getServerStreaming();
        }

        public DescriptorProtos.MethodOptions getOptions() {
            return this.proto.getOptions();
        }

        private MethodDescriptor(DescriptorProtos.MethodDescriptorProto methodDescriptorProto, FileDescriptor fileDescriptor, ServiceDescriptor serviceDescriptor, int n2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = methodDescriptorProto;
            this.file = fileDescriptor;
            this.service = serviceDescriptor;
            this.fullName = serviceDescriptor.getFullName() + '.' + methodDescriptorProto.getName();
            fileDescriptor.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor = this.getFile().pool.lookupSymbol(this.proto.getInputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getInputType() + "\" is not a message type.");
            }
            this.inputType = (Descriptor)genericDescriptor;
            GenericDescriptor genericDescriptor2 = this.getFile().pool.lookupSymbol(this.proto.getOutputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor2 instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getOutputType() + "\" is not a message type.");
            }
            this.outputType = (Descriptor)genericDescriptor2;
        }

        private void setProto(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) {
            this.proto = methodDescriptorProto;
        }
    }

    public static final class ServiceDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.ServiceDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private MethodDescriptor[] methods;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.ServiceDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public DescriptorProtos.ServiceOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<MethodDescriptor> getMethods() {
            return Collections.unmodifiableList(Arrays.asList(this.methods));
        }

        public MethodDescriptor findMethodByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof MethodDescriptor) {
                return (MethodDescriptor)genericDescriptor;
            }
            return null;
        }

        private ServiceDescriptor(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto, FileDescriptor fileDescriptor, int n2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = serviceDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, null, serviceDescriptorProto.getName());
            this.file = fileDescriptor;
            this.methods = new MethodDescriptor[serviceDescriptorProto.getMethodCount()];
            for (int i2 = 0; i2 < serviceDescriptorProto.getMethodCount(); ++i2) {
                this.methods[i2] = new MethodDescriptor(serviceDescriptorProto.getMethod(i2), fileDescriptor, this, i2);
            }
            fileDescriptor.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            for (MethodDescriptor methodDescriptor : this.methods) {
                methodDescriptor.crossLink();
            }
        }

        private void setProto(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto) {
            this.proto = serviceDescriptorProto;
            for (int i2 = 0; i2 < this.methods.length; ++i2) {
                this.methods[i2].setProto(serviceDescriptorProto.getMethod(i2));
            }
        }
    }

    public static final class EnumValueDescriptor
    extends GenericDescriptor
    implements Internal.EnumLite {
        static final Comparator<EnumValueDescriptor> BY_NUMBER = new Comparator<EnumValueDescriptor>(){

            @Override
            public int compare(EnumValueDescriptor enumValueDescriptor, EnumValueDescriptor enumValueDescriptor2) {
                return Integer.compare(enumValueDescriptor.getNumber(), enumValueDescriptor2.getNumber());
            }
        };
        static final NumberGetter<EnumValueDescriptor> NUMBER_GETTER = new NumberGetter<EnumValueDescriptor>(){

            @Override
            public int getNumber(EnumValueDescriptor enumValueDescriptor) {
                return enumValueDescriptor.getNumber();
            }
        };
        private final int index;
        private DescriptorProtos.EnumValueDescriptorProto proto;
        private final String fullName;
        private final EnumDescriptor type;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumValueDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        public String toString() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.type.file;
        }

        public EnumDescriptor getType() {
            return this.type;
        }

        public DescriptorProtos.EnumValueOptions getOptions() {
            return this.proto.getOptions();
        }

        private EnumValueDescriptor(DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto, FileDescriptor fileDescriptor, EnumDescriptor enumDescriptor, int n2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = enumValueDescriptorProto;
            this.type = enumDescriptor;
            this.fullName = enumDescriptor.getFullName() + '.' + enumValueDescriptorProto.getName();
            fileDescriptor.pool.addSymbol(this);
        }

        private EnumValueDescriptor(EnumDescriptor enumDescriptor, Integer n2) {
            String string = "UNKNOWN_ENUM_VALUE_" + enumDescriptor.getName() + "_" + n2;
            DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto = DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName(string).setNumber(n2).build();
            this.index = -1;
            this.proto = enumValueDescriptorProto;
            this.type = enumDescriptor;
            this.fullName = enumDescriptor.getFullName() + '.' + enumValueDescriptorProto.getName();
        }

        private void setProto(DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto) {
            this.proto = enumValueDescriptorProto;
        }
    }

    public static final class EnumDescriptor
    extends GenericDescriptor
    implements Internal.EnumLiteMap<EnumValueDescriptor> {
        private final int index;
        private DescriptorProtos.EnumDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final EnumValueDescriptor[] values;
        private final EnumValueDescriptor[] valuesSortedByNumber;
        private final int distinctNumbers;
        private Map<Integer, WeakReference<EnumValueDescriptor>> unknownValues = null;
        private ReferenceQueue<EnumValueDescriptor> cleanupQueue = null;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public DescriptorProtos.EnumOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<EnumValueDescriptor> getValues() {
            return Collections.unmodifiableList(Arrays.asList(this.values));
        }

        public EnumValueDescriptor findValueByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof EnumValueDescriptor) {
                return (EnumValueDescriptor)genericDescriptor;
            }
            return null;
        }

        @Override
        public EnumValueDescriptor findValueByNumber(int n2) {
            return (EnumValueDescriptor)Descriptors.binarySearch(this.valuesSortedByNumber, this.distinctNumbers, EnumValueDescriptor.NUMBER_GETTER, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EnumValueDescriptor findValueByNumberCreatingIfUnknown(int n2) {
            EnumValueDescriptor enumValueDescriptor = this.findValueByNumber(n2);
            if (enumValueDescriptor != null) {
                return enumValueDescriptor;
            }
            EnumDescriptor enumDescriptor = this;
            synchronized (enumDescriptor) {
                WeakReference weakReference;
                if (this.cleanupQueue == null) {
                    this.cleanupQueue = new ReferenceQueue();
                    this.unknownValues = new HashMap<Integer, WeakReference<EnumValueDescriptor>>();
                } else {
                    while ((weakReference = (UnknownEnumValueReference)this.cleanupQueue.poll()) != null) {
                        this.unknownValues.remove(((UnknownEnumValueReference)weakReference).number);
                    }
                }
                weakReference = this.unknownValues.get(n2);
                EnumValueDescriptor enumValueDescriptor2 = enumValueDescriptor = weakReference == null ? null : (EnumValueDescriptor)weakReference.get();
                if (enumValueDescriptor == null) {
                    enumValueDescriptor = new EnumValueDescriptor(this, n2);
                    this.unknownValues.put(n2, new UnknownEnumValueReference(n2, enumValueDescriptor));
                }
            }
            return enumValueDescriptor;
        }

        int getUnknownEnumValueDescriptorCount() {
            return this.unknownValues.size();
        }

        private EnumDescriptor(DescriptorProtos.EnumDescriptorProto enumDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n2) throws DescriptorValidationException {
            int n3;
            this.index = n2;
            this.proto = enumDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, enumDescriptorProto.getName());
            this.file = fileDescriptor;
            this.containingType = descriptor;
            if (enumDescriptorProto.getValueCount() == 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Enums must contain at least one value.");
            }
            this.values = new EnumValueDescriptor[enumDescriptorProto.getValueCount()];
            for (n3 = 0; n3 < enumDescriptorProto.getValueCount(); ++n3) {
                this.values[n3] = new EnumValueDescriptor(enumDescriptorProto.getValue(n3), fileDescriptor, this, n3);
            }
            this.valuesSortedByNumber = (EnumValueDescriptor[])this.values.clone();
            Arrays.sort(this.valuesSortedByNumber, EnumValueDescriptor.BY_NUMBER);
            n3 = 0;
            for (int i2 = 1; i2 < enumDescriptorProto.getValueCount(); ++i2) {
                EnumValueDescriptor enumValueDescriptor = this.valuesSortedByNumber[n3];
                EnumValueDescriptor enumValueDescriptor2 = this.valuesSortedByNumber[i2];
                if (enumValueDescriptor.getNumber() == enumValueDescriptor2.getNumber()) continue;
                this.valuesSortedByNumber[++n3] = enumValueDescriptor2;
            }
            this.distinctNumbers = n3 + 1;
            Arrays.fill(this.valuesSortedByNumber, this.distinctNumbers, enumDescriptorProto.getValueCount(), null);
            fileDescriptor.pool.addSymbol(this);
        }

        private void setProto(DescriptorProtos.EnumDescriptorProto enumDescriptorProto) {
            this.proto = enumDescriptorProto;
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].setProto(enumDescriptorProto.getValue(i2));
            }
        }

        private static class UnknownEnumValueReference
        extends WeakReference<EnumValueDescriptor> {
            private final int number;

            private UnknownEnumValueReference(int n2, EnumValueDescriptor enumValueDescriptor) {
                super(enumValueDescriptor);
                this.number = n2;
            }
        }
    }

    public static final class FieldDescriptor
    extends GenericDescriptor
    implements FieldSet.FieldDescriptorLite<FieldDescriptor>,
    Comparable<FieldDescriptor> {
        private static final NumberGetter<FieldDescriptor> NUMBER_GETTER = new NumberGetter<FieldDescriptor>(){

            @Override
            public int getNumber(FieldDescriptor fieldDescriptor) {
                return fieldDescriptor.getNumber();
            }
        };
        private static final WireFormat.FieldType[] table = WireFormat.FieldType.values();
        private final int index;
        private DescriptorProtos.FieldDescriptorProto proto;
        private final String fullName;
        private String jsonName;
        private final FileDescriptor file;
        private final Descriptor extensionScope;
        private final boolean isProto3Optional;
        private Type type;
        private Descriptor containingType;
        private Descriptor messageType;
        private OneofDescriptor containingOneof;
        private EnumDescriptor enumType;
        private Object defaultValue;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.FieldDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public String getJsonName() {
            String string = this.jsonName;
            if (string != null) {
                return string;
            }
            if (this.proto.hasJsonName()) {
                this.jsonName = this.proto.getJsonName();
                return this.jsonName;
            }
            this.jsonName = FieldDescriptor.fieldNameToJsonName(this.proto.getName());
            return this.jsonName;
        }

        public JavaType getJavaType() {
            return this.type.getJavaType();
        }

        @Override
        public WireFormat.JavaType getLiteJavaType() {
            return this.getLiteType().getJavaType();
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return table[this.type.ordinal()];
        }

        public boolean needsUtf8Check() {
            if (this.type != Type.STRING) {
                return false;
            }
            if (this.getContainingType().getOptions().getMapEntry()) {
                return true;
            }
            if (this.getFile().getSyntax() == FileDescriptor.Syntax.PROTO3) {
                return true;
            }
            return this.getFile().getOptions().getJavaStringCheckUtf8();
        }

        public boolean isMapField() {
            return this.getType() == Type.MESSAGE && this.isRepeated() && this.getMessageType().getOptions().getMapEntry();
        }

        public boolean isRequired() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
        }

        public boolean isOptional() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL;
        }

        @Override
        public boolean isRepeated() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
        }

        @Override
        public boolean isPacked() {
            if (!this.isPackable()) {
                return false;
            }
            if (this.getFile().getSyntax() == FileDescriptor.Syntax.PROTO2) {
                return this.getOptions().getPacked();
            }
            return !this.getOptions().hasPacked() || this.getOptions().getPacked();
        }

        public boolean isPackable() {
            return this.isRepeated() && this.getLiteType().isPackable();
        }

        public boolean hasDefaultValue() {
            return this.proto.hasDefaultValue();
        }

        public Object getDefaultValue() {
            if (this.getJavaType() == JavaType.MESSAGE) {
                throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
            }
            return this.defaultValue;
        }

        public DescriptorProtos.FieldOptions getOptions() {
            return this.proto.getOptions();
        }

        public boolean isExtension() {
            return this.proto.hasExtendee();
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public OneofDescriptor getContainingOneof() {
            return this.containingOneof;
        }

        public OneofDescriptor getRealContainingOneof() {
            return this.containingOneof != null && !this.containingOneof.isSynthetic() ? this.containingOneof : null;
        }

        public boolean hasOptionalKeyword() {
            return this.isProto3Optional || this.file.getSyntax() == FileDescriptor.Syntax.PROTO2 && this.isOptional() && this.getContainingOneof() == null;
        }

        public boolean hasPresence() {
            if (this.isRepeated()) {
                return false;
            }
            return this.getType() == Type.MESSAGE || this.getType() == Type.GROUP || this.getContainingOneof() != null || this.file.getSyntax() == FileDescriptor.Syntax.PROTO2;
        }

        public Descriptor getExtensionScope() {
            if (!this.isExtension()) {
                throw new UnsupportedOperationException(String.format("This field is not an extension. (%s)", this.fullName));
            }
            return this.extensionScope;
        }

        public Descriptor getMessageType() {
            if (this.getJavaType() != JavaType.MESSAGE) {
                throw new UnsupportedOperationException(String.format("This field is not of message type. (%s)", this.fullName));
            }
            return this.messageType;
        }

        public EnumDescriptor getEnumType() {
            if (this.getJavaType() != JavaType.ENUM) {
                throw new UnsupportedOperationException(String.format("This field is not of enum type. (%s)", this.fullName));
            }
            return this.enumType;
        }

        @Override
        public int compareTo(FieldDescriptor fieldDescriptor) {
            if (fieldDescriptor.containingType != this.containingType) {
                throw new IllegalArgumentException("FieldDescriptors can only be compared to other FieldDescriptors for fields of the same message type.");
            }
            return this.getNumber() - fieldDescriptor.getNumber();
        }

        public String toString() {
            return this.getFullName();
        }

        private static String fieldNameToJsonName(String string) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '_') {
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    if ('a' <= c2 && c2 <= 'z') {
                        c2 = (char)(c2 - 97 + 65);
                    }
                    stringBuilder.append(c2);
                    bl2 = false;
                    continue;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }

        private FieldDescriptor(DescriptorProtos.FieldDescriptorProto fieldDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n2, boolean bl2) throws DescriptorValidationException {
            this.index = n2;
            this.proto = fieldDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, fieldDescriptorProto.getName());
            this.file = fileDescriptor;
            if (fieldDescriptorProto.hasType()) {
                this.type = Type.valueOf(fieldDescriptorProto.getType());
            }
            this.isProto3Optional = fieldDescriptorProto.getProto3Optional();
            if (this.getNumber() <= 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field numbers must be positive integers.");
            }
            if (bl2) {
                if (!fieldDescriptorProto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee not set for extension field.");
                }
                this.containingType = null;
                this.extensionScope = descriptor != null ? descriptor : null;
                if (fieldDescriptorProto.hasOneofIndex()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index set for extension field.");
                }
                this.containingOneof = null;
            } else {
                if (fieldDescriptorProto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee set for non-extension field.");
                }
                this.containingType = descriptor;
                if (fieldDescriptorProto.hasOneofIndex()) {
                    if (fieldDescriptorProto.getOneofIndex() < 0 || fieldDescriptorProto.getOneofIndex() >= descriptor.toProto().getOneofDeclCount()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index is out of range for type " + descriptor.getName());
                    }
                    this.containingOneof = descriptor.getOneofs().get(fieldDescriptorProto.getOneofIndex());
                    this.containingOneof.fieldCount++;
                } else {
                    this.containingOneof = null;
                }
                this.extensionScope = null;
            }
            fileDescriptor.pool.addSymbol(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor;
            if (this.proto.hasExtendee()) {
                genericDescriptor = this.file.pool.lookupSymbol(this.proto.getExtendee(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!(genericDescriptor instanceof Descriptor)) {
                    throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getExtendee() + "\" is not a message type.");
                }
                this.containingType = (Descriptor)genericDescriptor;
                if (!this.getContainingType().isExtensionNumber(this.getNumber())) {
                    throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.getContainingType().getFullName() + "\" does not declare " + this.getNumber() + " as an extension number.");
                }
            }
            if (this.proto.hasTypeName()) {
                genericDescriptor = this.file.pool.lookupSymbol(this.proto.getTypeName(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!this.proto.hasType()) {
                    if (genericDescriptor instanceof Descriptor) {
                        this.type = Type.MESSAGE;
                    } else {
                        if (!(genericDescriptor instanceof EnumDescriptor)) throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not a type.");
                        this.type = Type.ENUM;
                    }
                }
                if (this.getJavaType() == JavaType.MESSAGE) {
                    if (!(genericDescriptor instanceof Descriptor)) {
                        throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not a message type.");
                    }
                    this.messageType = (Descriptor)genericDescriptor;
                    if (this.proto.hasDefaultValue()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "Messages can't have default values.");
                    }
                } else {
                    if (this.getJavaType() != JavaType.ENUM) throw new DescriptorValidationException((GenericDescriptor)this, "Field with primitive type has type_name.");
                    if (!(genericDescriptor instanceof EnumDescriptor)) {
                        throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not an enum type.");
                    }
                    this.enumType = (EnumDescriptor)genericDescriptor;
                }
            } else if (this.getJavaType() == JavaType.MESSAGE || this.getJavaType() == JavaType.ENUM) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field with message or enum type missing type_name.");
            }
            if (this.proto.getOptions().getPacked() && !this.isPackable()) {
                throw new DescriptorValidationException((GenericDescriptor)this, "[packed = true] can only be specified for repeated primitive fields.");
            }
            if (this.proto.hasDefaultValue()) {
                if (this.isRepeated()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "Repeated fields cannot have default values.");
                }
                try {
                    switch (this.getType()) {
                        case INT32: 
                        case SINT32: 
                        case SFIXED32: {
                            this.defaultValue = TextFormat.parseInt32(this.proto.getDefaultValue());
                            break;
                        }
                        case UINT32: 
                        case FIXED32: {
                            this.defaultValue = TextFormat.parseUInt32(this.proto.getDefaultValue());
                            break;
                        }
                        case INT64: 
                        case SINT64: 
                        case SFIXED64: {
                            this.defaultValue = TextFormat.parseInt64(this.proto.getDefaultValue());
                            break;
                        }
                        case UINT64: 
                        case FIXED64: {
                            this.defaultValue = TextFormat.parseUInt64(this.proto.getDefaultValue());
                            break;
                        }
                        case FLOAT: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Float.valueOf(Float.POSITIVE_INFINITY);
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Float.valueOf(Float.NaN);
                                break;
                            }
                            this.defaultValue = Float.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case DOUBLE: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Double.POSITIVE_INFINITY;
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Double.NEGATIVE_INFINITY;
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Double.NaN;
                                break;
                            }
                            this.defaultValue = Double.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case BOOL: {
                            this.defaultValue = Boolean.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case STRING: {
                            this.defaultValue = this.proto.getDefaultValue();
                            break;
                        }
                        case BYTES: {
                            try {
                                this.defaultValue = TextFormat.unescapeBytes(this.proto.getDefaultValue());
                                break;
                            }
                            catch (TextFormat.InvalidEscapeSequenceException invalidEscapeSequenceException) {
                                throw new DescriptorValidationException(this, "Couldn't parse default value: " + invalidEscapeSequenceException.getMessage(), invalidEscapeSequenceException);
                            }
                        }
                        case ENUM: {
                            this.defaultValue = this.enumType.findValueByName(this.proto.getDefaultValue());
                            if (this.defaultValue != null) break;
                            throw new DescriptorValidationException((GenericDescriptor)this, "Unknown enum default value: \"" + this.proto.getDefaultValue() + '\"');
                        }
                        case MESSAGE: 
                        case GROUP: {
                            throw new DescriptorValidationException((GenericDescriptor)this, "Message type had default value.");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DescriptorValidationException(this, "Could not parse default value: \"" + this.proto.getDefaultValue() + '\"', numberFormatException);
                }
            } else if (this.isRepeated()) {
                this.defaultValue = Collections.emptyList();
            } else {
                switch (this.getJavaType()) {
                    case ENUM: {
                        this.defaultValue = this.enumType.getValues().get(0);
                        break;
                    }
                    case MESSAGE: {
                        this.defaultValue = null;
                        break;
                    }
                    default: {
                        this.defaultValue = this.getJavaType().defaultDefault;
                    }
                }
            }
            if (this.containingType == null || !this.containingType.getOptions().getMessageSetWireFormat()) return;
            if (!this.isExtension()) throw new DescriptorValidationException((GenericDescriptor)this, "MessageSets cannot have fields, only extensions.");
            if (this.isOptional() && this.getType() == Type.MESSAGE) return;
            throw new DescriptorValidationException((GenericDescriptor)this, "Extensions of MessageSets must be optional messages.");
        }

        private void setProto(DescriptorProtos.FieldDescriptorProto fieldDescriptorProto) {
            this.proto = fieldDescriptorProto;
        }

        @Override
        public MessageLite.Builder internalMergeFrom(MessageLite.Builder builder, MessageLite messageLite) {
            return ((Message.Builder)builder).mergeFrom((Message)messageLite);
        }

        static {
            if (Type.types.length != DescriptorProtos.FieldDescriptorProto.Type.values().length) {
                throw new RuntimeException("descriptor.proto has a new declared type but Descriptors.java wasn't updated.");
            }
        }

        public static enum JavaType {
            INT(0),
            LONG(0L),
            FLOAT(Float.valueOf(0.0f)),
            DOUBLE(0.0),
            BOOLEAN(false),
            STRING(""),
            BYTE_STRING(ByteString.EMPTY),
            ENUM(null),
            MESSAGE(null);

            private final Object defaultDefault;

            private JavaType(Object object) {
                this.defaultDefault = object;
            }
        }

        public static enum Type {
            DOUBLE(JavaType.DOUBLE),
            FLOAT(JavaType.FLOAT),
            INT64(JavaType.LONG),
            UINT64(JavaType.LONG),
            INT32(JavaType.INT),
            FIXED64(JavaType.LONG),
            FIXED32(JavaType.INT),
            BOOL(JavaType.BOOLEAN),
            STRING(JavaType.STRING),
            GROUP(JavaType.MESSAGE),
            MESSAGE(JavaType.MESSAGE),
            BYTES(JavaType.BYTE_STRING),
            UINT32(JavaType.INT),
            ENUM(JavaType.ENUM),
            SFIXED32(JavaType.INT),
            SFIXED64(JavaType.LONG),
            SINT32(JavaType.INT),
            SINT64(JavaType.LONG);

            private static final Type[] types;
            private final JavaType javaType;

            private Type(JavaType javaType) {
                this.javaType = javaType;
            }

            public DescriptorProtos.FieldDescriptorProto.Type toProto() {
                return DescriptorProtos.FieldDescriptorProto.Type.forNumber(this.ordinal() + 1);
            }

            public JavaType getJavaType() {
                return this.javaType;
            }

            public static Type valueOf(DescriptorProtos.FieldDescriptorProto.Type type) {
                return types[type.getNumber() - 1];
            }

            static {
                types = Type.values();
            }
        }
    }

    public static final class Descriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.DescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final Descriptor[] nestedTypes;
        private final EnumDescriptor[] enumTypes;
        private final FieldDescriptor[] fields;
        private final FieldDescriptor[] fieldsSortedByNumber;
        private final FieldDescriptor[] extensions;
        private final OneofDescriptor[] oneofs;
        private final int realOneofCount;
        private final int[] extensionRangeLowerBounds;
        private final int[] extensionRangeUpperBounds;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.DescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public DescriptorProtos.MessageOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public List<OneofDescriptor> getOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs));
        }

        public List<OneofDescriptor> getRealOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs).subList(0, this.realOneofCount));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<Descriptor> getNestedTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.nestedTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public boolean isExtensionNumber(int n2) {
            int n3 = Arrays.binarySearch(this.extensionRangeLowerBounds, n2);
            if (n3 < 0) {
                n3 = ~n3 - 1;
            }
            return n3 >= 0 && n2 < this.extensionRangeUpperBounds[n3];
        }

        public boolean isReservedNumber(int n2) {
            for (DescriptorProtos.DescriptorProto.ReservedRange reservedRange : this.proto.getReservedRangeList()) {
                if (reservedRange.getStart() > n2 || n2 >= reservedRange.getEnd()) continue;
                return true;
            }
            return false;
        }

        public boolean isReservedName(String string) {
            Internal.checkNotNull(string);
            for (String string2 : this.proto.getReservedNameList()) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean isExtendable() {
            return !this.proto.getExtensionRangeList().isEmpty();
        }

        public FieldDescriptor findFieldByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof FieldDescriptor) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public FieldDescriptor findFieldByNumber(int n2) {
            return (FieldDescriptor)Descriptors.binarySearch(this.fieldsSortedByNumber, this.fieldsSortedByNumber.length, FieldDescriptor.NUMBER_GETTER, n2);
        }

        public Descriptor findNestedTypeByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof Descriptor) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor instanceof EnumDescriptor) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        Descriptor(String string) throws DescriptorValidationException {
            String string2 = string;
            String string3 = "";
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string2 = string.substring(n2 + 1);
                string3 = string.substring(0, n2);
            }
            this.index = 0;
            this.proto = DescriptorProtos.DescriptorProto.newBuilder().setName(string2).addExtensionRange(DescriptorProtos.DescriptorProto.ExtensionRange.newBuilder().setStart(1).setEnd(0x20000000).build()).build();
            this.fullName = string;
            this.containingType = null;
            this.nestedTypes = EMPTY_DESCRIPTORS;
            this.enumTypes = EMPTY_ENUM_DESCRIPTORS;
            this.fields = EMPTY_FIELD_DESCRIPTORS;
            this.fieldsSortedByNumber = EMPTY_FIELD_DESCRIPTORS;
            this.extensions = EMPTY_FIELD_DESCRIPTORS;
            this.oneofs = EMPTY_ONEOF_DESCRIPTORS;
            this.realOneofCount = 0;
            this.file = new FileDescriptor(string3, this);
            this.extensionRangeLowerBounds = new int[]{1};
            this.extensionRangeUpperBounds = new int[]{0x20000000};
        }

        /*
         * WARNING - void declaration
         */
        private Descriptor(DescriptorProtos.DescriptorProto descriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n2) throws DescriptorValidationException {
            int n3;
            this.index = n2;
            this.proto = descriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, descriptorProto.getName());
            this.file = fileDescriptor;
            this.containingType = descriptor;
            this.oneofs = descriptorProto.getOneofDeclCount() > 0 ? new OneofDescriptor[descriptorProto.getOneofDeclCount()] : EMPTY_ONEOF_DESCRIPTORS;
            for (n3 = 0; n3 < descriptorProto.getOneofDeclCount(); ++n3) {
                this.oneofs[n3] = new OneofDescriptor(descriptorProto.getOneofDecl(n3), fileDescriptor, this, n3);
            }
            this.nestedTypes = descriptorProto.getNestedTypeCount() > 0 ? new Descriptor[descriptorProto.getNestedTypeCount()] : EMPTY_DESCRIPTORS;
            for (n3 = 0; n3 < descriptorProto.getNestedTypeCount(); ++n3) {
                this.nestedTypes[n3] = new Descriptor(descriptorProto.getNestedType(n3), fileDescriptor, this, n3);
            }
            this.enumTypes = descriptorProto.getEnumTypeCount() > 0 ? new EnumDescriptor[descriptorProto.getEnumTypeCount()] : EMPTY_ENUM_DESCRIPTORS;
            for (n3 = 0; n3 < descriptorProto.getEnumTypeCount(); ++n3) {
                this.enumTypes[n3] = new EnumDescriptor(descriptorProto.getEnumType(n3), fileDescriptor, this, n3);
            }
            this.fields = descriptorProto.getFieldCount() > 0 ? new FieldDescriptor[descriptorProto.getFieldCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n3 = 0; n3 < descriptorProto.getFieldCount(); ++n3) {
                this.fields[n3] = new FieldDescriptor(descriptorProto.getField(n3), fileDescriptor, this, n3, false);
            }
            this.fieldsSortedByNumber = descriptorProto.getFieldCount() > 0 ? (FieldDescriptor[])this.fields.clone() : EMPTY_FIELD_DESCRIPTORS;
            this.extensions = descriptorProto.getExtensionCount() > 0 ? new FieldDescriptor[descriptorProto.getExtensionCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n3 = 0; n3 < descriptorProto.getExtensionCount(); ++n3) {
                this.extensions[n3] = new FieldDescriptor(descriptorProto.getExtension(n3), fileDescriptor, this, n3, true);
            }
            for (n3 = 0; n3 < descriptorProto.getOneofDeclCount(); ++n3) {
                OneofDescriptor.access$2502(this.oneofs[n3], new FieldDescriptor[this.oneofs[n3].getFieldCount()]);
                this.oneofs[n3].fieldCount = 0;
            }
            for (n3 = 0; n3 < descriptorProto.getFieldCount(); ++n3) {
                OneofDescriptor object = this.fields[n3].getContainingOneof();
                if (object == null) continue;
                ((OneofDescriptor)object).fields[((OneofDescriptor)object).fieldCount++] = this.fields[n3];
            }
            n3 = 0;
            for (OneofDescriptor oneofDescriptor : this.oneofs) {
                if (oneofDescriptor.isSynthetic()) {
                    ++n3;
                    continue;
                }
                if (n3 <= 0) continue;
                throw new DescriptorValidationException((GenericDescriptor)this, "Synthetic oneofs must come last.");
            }
            this.realOneofCount = this.oneofs.length - n3;
            fileDescriptor.pool.addSymbol(this);
            if (descriptorProto.getExtensionRangeCount() > 0) {
                this.extensionRangeLowerBounds = new int[descriptorProto.getExtensionRangeCount()];
                this.extensionRangeUpperBounds = new int[descriptorProto.getExtensionRangeCount()];
                boolean bl2 = false;
                for (DescriptorProtos.DescriptorProto.ExtensionRange extensionRange : descriptorProto.getExtensionRangeList()) {
                    void var6_9;
                    this.extensionRangeLowerBounds[var6_9] = extensionRange.getStart();
                    this.extensionRangeUpperBounds[var6_9] = extensionRange.getEnd();
                    ++var6_9;
                }
                Arrays.sort(this.extensionRangeLowerBounds);
                Arrays.sort(this.extensionRangeUpperBounds);
            } else {
                this.extensionRangeLowerBounds = EMPTY_INT_ARRAY;
                this.extensionRangeUpperBounds = EMPTY_INT_ARRAY;
            }
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor genericDescriptor : this.nestedTypes) {
                genericDescriptor.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.fields) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
            Arrays.sort(this.fieldsSortedByNumber);
            this.validateNoDuplicateFieldNumbers();
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void validateNoDuplicateFieldNumbers() throws DescriptorValidationException {
            int n2 = 0;
            while (n2 + 1 < this.fieldsSortedByNumber.length) {
                FieldDescriptor fieldDescriptor = this.fieldsSortedByNumber[n2];
                FieldDescriptor fieldDescriptor2 = this.fieldsSortedByNumber[n2 + 1];
                if (fieldDescriptor.getNumber() == fieldDescriptor2.getNumber()) {
                    throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor2, "Field number " + fieldDescriptor2.getNumber() + " has already been used in \"" + fieldDescriptor2.getContainingType().getFullName() + "\" by field \"" + fieldDescriptor.getName() + "\".");
                }
                ++n2;
            }
        }

        private void setProto(DescriptorProtos.DescriptorProto descriptorProto) {
            int n2;
            this.proto = descriptorProto;
            for (n2 = 0; n2 < this.nestedTypes.length; ++n2) {
                this.nestedTypes[n2].setProto(descriptorProto.getNestedType(n2));
            }
            for (n2 = 0; n2 < this.oneofs.length; ++n2) {
                this.oneofs[n2].setProto(descriptorProto.getOneofDecl(n2));
            }
            for (n2 = 0; n2 < this.enumTypes.length; ++n2) {
                this.enumTypes[n2].setProto(descriptorProto.getEnumType(n2));
            }
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                this.fields[n2].setProto(descriptorProto.getField(n2));
            }
            for (n2 = 0; n2 < this.extensions.length; ++n2) {
                this.extensions[n2].setProto(descriptorProto.getExtension(n2));
            }
        }
    }

    public static final class FileDescriptor
    extends GenericDescriptor {
        private DescriptorProtos.FileDescriptorProto proto;
        private final Descriptor[] messageTypes;
        private final EnumDescriptor[] enumTypes;
        private final ServiceDescriptor[] services;
        private final FieldDescriptor[] extensions;
        private final FileDescriptor[] dependencies;
        private final FileDescriptor[] publicDependencies;
        private final DescriptorPool pool;

        @Override
        public DescriptorProtos.FileDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public FileDescriptor getFile() {
            return this;
        }

        @Override
        public String getFullName() {
            return this.proto.getName();
        }

        public String getPackage() {
            return this.proto.getPackage();
        }

        public DescriptorProtos.FileOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<Descriptor> getMessageTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.messageTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public List<ServiceDescriptor> getServices() {
            return Collections.unmodifiableList(Arrays.asList(this.services));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<FileDescriptor> getDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.dependencies));
        }

        public List<FileDescriptor> getPublicDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.publicDependencies));
        }

        public Syntax getSyntax() {
            if (Syntax.PROTO3.name.equals(this.proto.getSyntax())) {
                return Syntax.PROTO3;
            }
            return Syntax.PROTO2;
        }

        public Descriptor findMessageTypeByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            String string2 = this.getPackage();
            if (!string2.isEmpty()) {
                string = string2 + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) instanceof Descriptor && genericDescriptor.getFile() == this) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            String string2 = this.getPackage();
            if (!string2.isEmpty()) {
                string = string2 + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) instanceof EnumDescriptor && genericDescriptor.getFile() == this) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        public ServiceDescriptor findServiceByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            String string2 = this.getPackage();
            if (!string2.isEmpty()) {
                string = string2 + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) instanceof ServiceDescriptor && genericDescriptor.getFile() == this) {
                return (ServiceDescriptor)genericDescriptor;
            }
            return null;
        }

        public FieldDescriptor findExtensionByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            String string2 = this.getPackage();
            if (!string2.isEmpty()) {
                string = string2 + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) instanceof FieldDescriptor && genericDescriptor.getFile() == this) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray) throws DescriptorValidationException {
            return FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, false);
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray, boolean bl2) throws DescriptorValidationException {
            DescriptorPool descriptorPool = new DescriptorPool(fileDescriptorArray, bl2);
            FileDescriptor fileDescriptor = new FileDescriptor(fileDescriptorProto, fileDescriptorArray, descriptorPool, bl2);
            fileDescriptor.crossLink();
            return fileDescriptor;
        }

        private static byte[] latin1Cat(String[] stringArray) {
            if (stringArray.length == 1) {
                return stringArray[0].getBytes(Internal.ISO_8859_1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString().getBytes(Internal.ISO_8859_1);
        }

        private static FileDescriptor[] findDescriptors(Class<?> clazz, String[] stringArray, String[] stringArray2) {
            ArrayList<FileDescriptor> arrayList = new ArrayList<FileDescriptor>();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Serializable serializable;
                try {
                    serializable = clazz.getClassLoader().loadClass(stringArray[i2]);
                    arrayList.add((FileDescriptor)((Class)serializable).getField("descriptor").get(null));
                    continue;
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    serializable = exception;
                    logger.c("Descriptors for \"" + stringArray2[i2] + "\" can not be found.");
                }
            }
            return arrayList.toArray(new FileDescriptor[0]);
        }

        @Deprecated
        public static void internalBuildGeneratedFileFrom(String[] stringArray, FileDescriptor[] fileDescriptorArray, InternalDescriptorAssigner internalDescriptorAssigner) {
            FileDescriptor fileDescriptor;
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            byte[] byArray = FileDescriptor.latin1Cat(stringArray);
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            try {
                fileDescriptor = FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, true);
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
            ExtensionRegistry extensionRegistry = internalDescriptorAssigner.assignDescriptors(fileDescriptor);
            if (extensionRegistry != null) {
                try {
                    fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray, (ExtensionRegistryLite)extensionRegistry);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
                }
                fileDescriptor.setProto(fileDescriptorProto);
            }
        }

        public static FileDescriptor internalBuildGeneratedFileFrom(String[] stringArray, FileDescriptor[] fileDescriptorArray) {
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            byte[] byArray = FileDescriptor.latin1Cat(stringArray);
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            try {
                return FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray, true);
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
        }

        @Deprecated
        public static void internalBuildGeneratedFileFrom(String[] stringArray, Class<?> clazz, String[] stringArray2, String[] stringArray3, InternalDescriptorAssigner internalDescriptorAssigner) {
            FileDescriptor[] fileDescriptorArray = FileDescriptor.findDescriptors(clazz, stringArray2, stringArray3);
            FileDescriptor.internalBuildGeneratedFileFrom(stringArray, fileDescriptorArray, internalDescriptorAssigner);
        }

        public static FileDescriptor internalBuildGeneratedFileFrom(String[] stringArray, Class<?> clazz, String[] stringArray2, String[] stringArray3) {
            FileDescriptor[] fileDescriptorArray = FileDescriptor.findDescriptors(clazz, stringArray2, stringArray3);
            return FileDescriptor.internalBuildGeneratedFileFrom(stringArray, fileDescriptorArray);
        }

        public static void internalUpdateFileDescriptor(FileDescriptor fileDescriptor, ExtensionRegistry extensionRegistry) {
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            ByteString byteString = fileDescriptor.proto.toByteString();
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byteString, (ExtensionRegistryLite)extensionRegistry);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            fileDescriptor.setProto(fileDescriptorProto);
        }

        private FileDescriptor(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray, DescriptorPool descriptorPool, boolean bl2) throws DescriptorValidationException {
            int n2;
            this.pool = descriptorPool;
            this.proto = fileDescriptorProto;
            this.dependencies = (FileDescriptor[])fileDescriptorArray.clone();
            HashMap<String, FileDescriptor> hashMap = new HashMap<String, FileDescriptor>();
            for (FileDescriptor object : fileDescriptorArray) {
                hashMap.put(object.getName(), object);
            }
            ArrayList arrayList = new ArrayList();
            for (n2 = 0; n2 < fileDescriptorProto.getPublicDependencyCount(); ++n2) {
                int n3 = fileDescriptorProto.getPublicDependency(n2);
                if (n3 < 0 || n3 >= fileDescriptorProto.getDependencyCount()) {
                    throw new DescriptorValidationException(this, "Invalid public dependency index.");
                }
                String string = fileDescriptorProto.getDependency(n3);
                FileDescriptor fileDescriptor = (FileDescriptor)hashMap.get(string);
                if (fileDescriptor == null) {
                    if (bl2) continue;
                    throw new DescriptorValidationException(this, "Invalid public dependency: " + string);
                }
                arrayList.add(fileDescriptor);
            }
            this.publicDependencies = new FileDescriptor[arrayList.size()];
            arrayList.toArray(this.publicDependencies);
            descriptorPool.addPackage(this.getPackage(), this);
            this.messageTypes = fileDescriptorProto.getMessageTypeCount() > 0 ? new Descriptor[fileDescriptorProto.getMessageTypeCount()] : EMPTY_DESCRIPTORS;
            for (n2 = 0; n2 < fileDescriptorProto.getMessageTypeCount(); ++n2) {
                this.messageTypes[n2] = new Descriptor(fileDescriptorProto.getMessageType(n2), this, null, n2);
            }
            this.enumTypes = fileDescriptorProto.getEnumTypeCount() > 0 ? new EnumDescriptor[fileDescriptorProto.getEnumTypeCount()] : EMPTY_ENUM_DESCRIPTORS;
            for (n2 = 0; n2 < fileDescriptorProto.getEnumTypeCount(); ++n2) {
                this.enumTypes[n2] = new EnumDescriptor(fileDescriptorProto.getEnumType(n2), this, null, n2);
            }
            this.services = fileDescriptorProto.getServiceCount() > 0 ? new ServiceDescriptor[fileDescriptorProto.getServiceCount()] : EMPTY_SERVICE_DESCRIPTORS;
            for (n2 = 0; n2 < fileDescriptorProto.getServiceCount(); ++n2) {
                this.services[n2] = new ServiceDescriptor(fileDescriptorProto.getService(n2), this, n2);
            }
            this.extensions = fileDescriptorProto.getExtensionCount() > 0 ? new FieldDescriptor[fileDescriptorProto.getExtensionCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n2 = 0; n2 < fileDescriptorProto.getExtensionCount(); ++n2) {
                this.extensions[n2] = new FieldDescriptor(fileDescriptorProto.getExtension(n2), this, null, n2, true);
            }
        }

        FileDescriptor(String string, Descriptor descriptor) throws DescriptorValidationException {
            this.pool = new DescriptorPool(new FileDescriptor[0], true);
            this.proto = DescriptorProtos.FileDescriptorProto.newBuilder().setName(descriptor.getFullName() + ".placeholder.proto").setPackage(string).addMessageType(descriptor.toProto()).build();
            this.dependencies = new FileDescriptor[0];
            this.publicDependencies = new FileDescriptor[0];
            this.messageTypes = new Descriptor[]{descriptor};
            this.enumTypes = EMPTY_ENUM_DESCRIPTORS;
            this.services = EMPTY_SERVICE_DESCRIPTORS;
            this.extensions = EMPTY_FIELD_DESCRIPTORS;
            this.pool.addPackage(string, this);
            this.pool.addSymbol(descriptor);
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor genericDescriptor : this.messageTypes) {
                genericDescriptor.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.services) {
                ((ServiceDescriptor)genericDescriptor).crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void setProto(DescriptorProtos.FileDescriptorProto fileDescriptorProto) {
            int n2;
            this.proto = fileDescriptorProto;
            for (n2 = 0; n2 < this.messageTypes.length; ++n2) {
                this.messageTypes[n2].setProto(fileDescriptorProto.getMessageType(n2));
            }
            for (n2 = 0; n2 < this.enumTypes.length; ++n2) {
                this.enumTypes[n2].setProto(fileDescriptorProto.getEnumType(n2));
            }
            for (n2 = 0; n2 < this.services.length; ++n2) {
                this.services[n2].setProto(fileDescriptorProto.getService(n2));
            }
            for (n2 = 0; n2 < this.extensions.length; ++n2) {
                this.extensions[n2].setProto(fileDescriptorProto.getExtension(n2));
            }
        }

        boolean supportsUnknownEnumValue() {
            return this.getSyntax() == Syntax.PROTO3;
        }

        @Deprecated
        public static interface InternalDescriptorAssigner {
            public ExtensionRegistry assignDescriptors(FileDescriptor var1);
        }

        public static enum Syntax {
            UNKNOWN("unknown"),
            PROTO2("proto2"),
            PROTO3("proto3");

            private final String name;

            private Syntax(String string2) {
                this.name = string2;
            }
        }
    }
}

