/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.AbstractProtobufList;
import java.util.Arrays;
import java.util.RandomAccess;

final class ProtobufArrayList<E>
extends AbstractProtobufList<E>
implements RandomAccess {
    private static final ProtobufArrayList<Object> EMPTY_LIST = new ProtobufArrayList<Object>(new Object[0], 0);
    private E[] array;
    private int size;

    public static <E> ProtobufArrayList<E> emptyList() {
        return EMPTY_LIST;
    }

    ProtobufArrayList() {
        this(new Object[10], 0);
    }

    private ProtobufArrayList(E[] EArray, int n2) {
        this.array = EArray;
        this.size = n2;
    }

    @Override
    public ProtobufArrayList<E> mutableCopyWithCapacity(int n2) {
        if (n2 < this.size) {
            throw new IllegalArgumentException();
        }
        E[] EArray = Arrays.copyOf(this.array, n2);
        return new ProtobufArrayList<E>(EArray, this.size);
    }

    @Override
    public boolean add(E e2) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            E[] EArray = Arrays.copyOf(this.array, n2);
            this.array = EArray;
        }
        this.array[this.size++] = e2;
        ++this.modCount;
        return true;
    }

    @Override
    public void add(int n2, E e2) {
        this.ensureIsMutable();
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        } else {
            int n3 = this.size * 3 / 2 + 1;
            E[] EArray = ProtobufArrayList.createArray(n3);
            System.arraycopy(this.array, 0, EArray, 0, n2);
            System.arraycopy(this.array, n2, EArray, n2 + 1, this.size - n2);
            this.array = EArray;
        }
        this.array[n2] = e2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public E get(int n2) {
        this.ensureIndexInRange(n2);
        return this.array[n2];
    }

    @Override
    public E remove(int n2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        E e2 = this.array[n2];
        if (n2 < this.size - 1) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, this.size - n2 - 1);
        }
        --this.size;
        ++this.modCount;
        return e2;
    }

    @Override
    public E set(int n2, E e2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        E e3 = this.array[n2];
        this.array[n2] = e2;
        ++this.modCount;
        return e3;
    }

    @Override
    public int size() {
        return this.size;
    }

    private static <E> E[] createArray(int n2) {
        return new Object[n2];
    }

    private void ensureIndexInRange(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n2) {
        return "Index:" + n2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

