/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.ByteOutput;
import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class RopeByteString
extends ByteString {
    static final int[] minLengthByDepth = new int[]{1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170, 1836311903, Integer.MAX_VALUE};
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private static final long serialVersionUID = 1L;

    private RopeByteString(ByteString byteString, ByteString byteString2) {
        this.left = byteString;
        this.right = byteString2;
        this.leftLength = byteString.size();
        this.totalLength = this.leftLength + byteString2.size();
        this.treeDepth = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1;
    }

    static ByteString concatenate(ByteString byteString, ByteString byteString2) {
        int n2;
        if (byteString2.size() == 0) {
            return byteString;
        }
        if (byteString.size() == 0) {
            return byteString2;
        }
        int n3 = byteString.size() + byteString2.size();
        if (n3 < 128) {
            return RopeByteString.concatenateBytes(byteString, byteString2);
        }
        if (byteString instanceof RopeByteString) {
            RopeByteString ropeByteString = (RopeByteString)byteString;
            if (ropeByteString.right.size() + byteString2.size() < 128) {
                ByteString byteString3 = RopeByteString.concatenateBytes(ropeByteString.right, byteString2);
                return new RopeByteString(ropeByteString.left, byteString3);
            }
            if (ropeByteString.left.getTreeDepth() > ropeByteString.right.getTreeDepth() && ropeByteString.getTreeDepth() > byteString2.getTreeDepth()) {
                RopeByteString ropeByteString2 = new RopeByteString(ropeByteString.right, byteString2);
                return new RopeByteString(ropeByteString.left, ropeByteString2);
            }
        }
        if (n3 >= RopeByteString.minLength(n2 = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1)) {
            return new RopeByteString(byteString, byteString2);
        }
        return new Balancer().balance(byteString, byteString2);
    }

    private static ByteString concatenateBytes(ByteString byteString, ByteString byteString2) {
        int n2 = byteString.size();
        int n3 = byteString2.size();
        byte[] byArray = new byte[n2 + n3];
        byteString.copyTo(byArray, 0, 0, n2);
        byteString2.copyTo(byArray, 0, n2, n3);
        return ByteString.wrap(byArray);
    }

    static RopeByteString newInstanceForTest(ByteString byteString, ByteString byteString2) {
        return new RopeByteString(byteString, byteString2);
    }

    static int minLength(int n2) {
        if (n2 >= minLengthByDepth.length) {
            return Integer.MAX_VALUE;
        }
        return minLengthByDepth[n2];
    }

    @Override
    public byte byteAt(int n2) {
        RopeByteString.checkIndex(n2, this.totalLength);
        return this.internalByteAt(n2);
    }

    @Override
    byte internalByteAt(int n2) {
        if (n2 < this.leftLength) {
            return this.left.internalByteAt(n2);
        }
        return this.right.internalByteAt(n2 - this.leftLength);
    }

    @Override
    public int size() {
        return this.totalLength;
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new ByteString.AbstractByteIterator(){
            final PieceIterator pieces;
            ByteString.ByteIterator current;
            {
                this.pieces = new PieceIterator(RopeByteString.this);
                this.current = this.nextPiece();
            }

            private ByteString.ByteIterator nextPiece() {
                return this.pieces.hasNext() ? this.pieces.next().iterator() : null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public byte nextByte() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                byte by = this.current.nextByte();
                if (!this.current.hasNext()) {
                    this.current = this.nextPiece();
                }
                return by;
            }
        };
    }

    @Override
    protected int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected boolean isBalanced() {
        return this.totalLength >= RopeByteString.minLength(this.treeDepth);
    }

    @Override
    public ByteString substring(int n2, int n3) {
        int n4 = RopeByteString.checkRange(n2, n3, this.totalLength);
        if (n4 == 0) {
            return ByteString.EMPTY;
        }
        if (n4 == this.totalLength) {
            return this;
        }
        if (n3 <= this.leftLength) {
            return this.left.substring(n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.substring(n2 - this.leftLength, n3 - this.leftLength);
        }
        ByteString byteString = this.left.substring(n2);
        ByteString byteString2 = this.right.substring(0, n3 - this.leftLength);
        return new RopeByteString(byteString, byteString2);
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n2, int n3, int n4) {
        if (n2 + n4 <= this.leftLength) {
            this.left.copyToInternal(byArray, n2, n3, n4);
        } else if (n2 >= this.leftLength) {
            this.right.copyToInternal(byArray, n2 - this.leftLength, n3, n4);
        } else {
            int n5 = this.leftLength - n2;
            this.left.copyToInternal(byArray, n2, n3, n5);
            this.right.copyToInternal(byArray, 0, n3 + n5, n4 - n5);
        }
    }

    @Override
    public void copyTo(ByteBuffer byteBuffer) {
        this.left.copyTo(byteBuffer);
        this.right.copyTo(byteBuffer);
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray());
        return byteBuffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        PieceIterator pieceIterator = new PieceIterator(this);
        while (pieceIterator.hasNext()) {
            ByteString.LeafByteString leafByteString = pieceIterator.next();
            arrayList.add(leafByteString.asReadOnlyByteBuffer());
        }
        return arrayList;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.left.writeTo(outputStream);
        this.right.writeTo(outputStream);
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n2, int n3) throws IOException {
        if (n2 + n3 <= this.leftLength) {
            this.left.writeToInternal(outputStream, n2, n3);
        } else if (n2 >= this.leftLength) {
            this.right.writeToInternal(outputStream, n2 - this.leftLength, n3);
        } else {
            int n4 = this.leftLength - n2;
            this.left.writeToInternal(outputStream, n2, n4);
            this.right.writeToInternal(outputStream, 0, n3 - n4);
        }
    }

    @Override
    void writeTo(ByteOutput byteOutput) throws IOException {
        this.left.writeTo(byteOutput);
        this.right.writeTo(byteOutput);
    }

    @Override
    void writeToReverse(ByteOutput byteOutput) throws IOException {
        this.right.writeToReverse(byteOutput);
        this.left.writeToReverse(byteOutput);
    }

    @Override
    protected String toStringInternal(Charset charset) {
        return new String(this.toByteArray(), charset);
    }

    @Override
    public boolean isValidUtf8() {
        int n2 = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        int n3 = this.right.partialIsValidUtf8(n2, 0, this.right.size());
        return n3 == 0;
    }

    @Override
    protected int partialIsValidUtf8(int n2, int n3, int n4) {
        int n5 = n3 + n4;
        if (n5 <= this.leftLength) {
            return this.left.partialIsValidUtf8(n2, n3, n4);
        }
        if (n3 >= this.leftLength) {
            return this.right.partialIsValidUtf8(n2, n3 - this.leftLength, n4);
        }
        int n6 = this.leftLength - n3;
        int n7 = this.left.partialIsValidUtf8(n2, n3, n6);
        return this.right.partialIsValidUtf8(n7, 0, n4 - n6);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        if (this.totalLength != byteString.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        int n2 = this.peekCachedHashCode();
        int n3 = byteString.peekCachedHashCode();
        if (n2 != 0 && n3 != 0 && n2 != n3) {
            return false;
        }
        return this.equalsFragments(byteString);
    }

    private boolean equalsFragments(ByteString byteString) {
        int n2 = 0;
        PieceIterator pieceIterator = new PieceIterator(this);
        ByteString.LeafByteString leafByteString = (ByteString.LeafByteString)pieceIterator.next();
        int n3 = 0;
        PieceIterator pieceIterator2 = new PieceIterator(byteString);
        ByteString.LeafByteString leafByteString2 = (ByteString.LeafByteString)pieceIterator2.next();
        int n4 = 0;
        while (true) {
            boolean bl2;
            int n5 = leafByteString.size() - n2;
            int n6 = leafByteString2.size() - n3;
            int n7 = Math.min(n5, n6);
            boolean bl3 = bl2 = n2 == 0 ? leafByteString.equalsRange(leafByteString2, n3, n7) : leafByteString2.equalsRange(leafByteString, n2, n7);
            if (!bl2) {
                return false;
            }
            if ((n4 += n7) >= this.totalLength) {
                if (n4 == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (n7 == n5) {
                n2 = 0;
                leafByteString = (ByteString.LeafByteString)pieceIterator.next();
            } else {
                n2 += n7;
            }
            if (n7 == n6) {
                n3 = 0;
                leafByteString2 = (ByteString.LeafByteString)pieceIterator2.next();
                continue;
            }
            n3 += n7;
        }
    }

    @Override
    protected int partialHash(int n2, int n3, int n4) {
        int n5 = n3 + n4;
        if (n5 <= this.leftLength) {
            return this.left.partialHash(n2, n3, n4);
        }
        if (n3 >= this.leftLength) {
            return this.right.partialHash(n2, n3 - this.leftLength, n4);
        }
        int n6 = this.leftLength - n3;
        int n7 = this.left.partialHash(n2, n3, n6);
        return this.right.partialHash(n7, 0, n4 - n6);
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.asReadOnlyByteBufferList(), true);
    }

    @Override
    public InputStream newInput() {
        return new RopeInputStream();
    }

    Object writeReplace() {
        return ByteString.wrap(this.toByteArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("RopeByteStream instances are not to be serialized directly");
    }

    private class RopeInputStream
    extends InputStream {
        private PieceIterator pieceIterator;
        private ByteString.LeafByteString currentPiece;
        private int currentPieceSize;
        private int currentPieceIndex;
        private int currentPieceOffsetInRope;
        private int mark;

        public RopeInputStream() {
            this.initialize();
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = this.readSkipInternal(byArray, n2, n3);
            if (n4 == 0 && (n3 > 0 || this.availableInternal() == 0)) {
                return -1;
            }
            return n4;
        }

        @Override
        public long skip(long l2) {
            if (l2 < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (l2 > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
            }
            return this.readSkipInternal(null, 0, (int)l2);
        }

        private int readSkipInternal(byte[] byArray, int n2, int n3) {
            int n4;
            int n5;
            for (n4 = n3; n4 > 0; n4 -= n5) {
                this.advanceIfCurrentPieceFullyRead();
                if (this.currentPiece == null) break;
                int n6 = this.currentPieceSize - this.currentPieceIndex;
                n5 = Math.min(n6, n4);
                if (byArray != null) {
                    this.currentPiece.copyTo(byArray, this.currentPieceIndex, n2, n5);
                    n2 += n5;
                }
                this.currentPieceIndex += n5;
            }
            return n3 - n4;
        }

        @Override
        public int read() throws IOException {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                return -1;
            }
            return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
        }

        @Override
        public int available() throws IOException {
            return this.availableInternal();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int n2) {
            this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
        }

        @Override
        public synchronized void reset() {
            this.initialize();
            this.readSkipInternal(null, 0, this.mark);
        }

        private void initialize() {
            this.pieceIterator = new PieceIterator(RopeByteString.this);
            this.currentPiece = this.pieceIterator.next();
            this.currentPieceSize = this.currentPiece.size();
            this.currentPieceIndex = 0;
            this.currentPieceOffsetInRope = 0;
        }

        private void advanceIfCurrentPieceFullyRead() {
            if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
                this.currentPieceOffsetInRope += this.currentPieceSize;
                this.currentPieceIndex = 0;
                if (this.pieceIterator.hasNext()) {
                    this.currentPiece = this.pieceIterator.next();
                    this.currentPieceSize = this.currentPiece.size();
                } else {
                    this.currentPiece = null;
                    this.currentPieceSize = 0;
                }
            }
        }

        private int availableInternal() {
            int n2 = this.currentPieceOffsetInRope + this.currentPieceIndex;
            return RopeByteString.this.size() - n2;
        }
    }

    private static final class PieceIterator
    implements Iterator<ByteString.LeafByteString> {
        private final ArrayDeque<RopeByteString> breadCrumbs;
        private ByteString.LeafByteString next;

        private PieceIterator(ByteString byteString) {
            if (byteString instanceof RopeByteString) {
                RopeByteString ropeByteString = (RopeByteString)byteString;
                this.breadCrumbs = new ArrayDeque(ropeByteString.getTreeDepth());
                this.breadCrumbs.push(ropeByteString);
                this.next = this.getLeafByLeft(ropeByteString.left);
            } else {
                this.breadCrumbs = null;
                this.next = (ByteString.LeafByteString)byteString;
            }
        }

        private ByteString.LeafByteString getLeafByLeft(ByteString byteString) {
            ByteString byteString2 = byteString;
            while (byteString2 instanceof RopeByteString) {
                RopeByteString ropeByteString = (RopeByteString)byteString2;
                this.breadCrumbs.push(ropeByteString);
                byteString2 = ropeByteString.left;
            }
            return (ByteString.LeafByteString)byteString2;
        }

        private ByteString.LeafByteString getNextNonEmptyLeaf() {
            ByteString.LeafByteString leafByteString;
            do {
                if (this.breadCrumbs != null && !this.breadCrumbs.isEmpty()) continue;
                return null;
            } while ((leafByteString = this.getLeafByLeft(this.breadCrumbs.pop().right)).isEmpty());
            return leafByteString;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ByteString.LeafByteString next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ByteString.LeafByteString leafByteString = this.next;
            this.next = this.getNextNonEmptyLeaf();
            return leafByteString;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Balancer {
        private final ArrayDeque<ByteString> prefixesStack = new ArrayDeque();

        private Balancer() {
        }

        private ByteString balance(ByteString byteString, ByteString byteString2) {
            this.doBalance(byteString);
            this.doBalance(byteString2);
            ByteString byteString3 = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty()) {
                ByteString byteString4 = this.prefixesStack.pop();
                byteString3 = new RopeByteString(byteString4, byteString3);
            }
            return byteString3;
        }

        private void doBalance(ByteString byteString) {
            if (byteString.isBalanced()) {
                this.insert(byteString);
            } else if (byteString instanceof RopeByteString) {
                RopeByteString ropeByteString = (RopeByteString)byteString;
                this.doBalance(ropeByteString.left);
                this.doBalance(ropeByteString.right);
            } else {
                throw new IllegalArgumentException("Has a new type of ByteString been created? Found " + byteString.getClass());
            }
        }

        private void insert(ByteString byteString) {
            int n2 = this.getDepthBinForLength(byteString.size());
            int n3 = RopeByteString.minLength(n2 + 1);
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= n3) {
                this.prefixesStack.push(byteString);
            } else {
                ByteString byteString2;
                int n4 = RopeByteString.minLength(n2);
                ByteString byteString3 = this.prefixesStack.pop();
                while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < n4) {
                    byteString2 = this.prefixesStack.pop();
                    byteString3 = new RopeByteString(byteString2, byteString3);
                }
                byteString3 = new RopeByteString(byteString3, byteString);
                while (!this.prefixesStack.isEmpty()) {
                    n2 = this.getDepthBinForLength(byteString3.size());
                    n3 = RopeByteString.minLength(n2 + 1);
                    if (this.prefixesStack.peek().size() >= n3) break;
                    byteString2 = this.prefixesStack.pop();
                    byteString3 = new RopeByteString(byteString2, byteString3);
                }
                this.prefixesStack.push(byteString3);
            }
        }

        private int getDepthBinForLength(int n2) {
            int n3 = Arrays.binarySearch(minLengthByDepth, n2);
            if (n3 < 0) {
                int n4 = -(n3 + 1);
                n3 = n4 - 1;
            }
            return n3;
        }
    }
}

