/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.Address;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.AddressResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class DnsSrvRecordAddressResolver
implements AddressResolver {
    private final String service;
    private final String dnsUrls;

    public DnsSrvRecordAddressResolver(String string) {
        this(string, "dns:");
    }

    public DnsSrvRecordAddressResolver(String string, String string2) {
        this.service = string;
        this.dnsUrls = string2;
    }

    @Override
    public List<Address> getAddresses() throws IOException {
        List<SrvRecord> list = this.lookupSrvRecords(this.service, this.dnsUrls);
        list = this.sort(list);
        ArrayList<Address> arrayList = new ArrayList<Address>();
        for (SrvRecord srvRecord : list) {
            arrayList.add(new Address(srvRecord.getHost(), srvRecord.getPort()));
        }
        return arrayList;
    }

    protected List<SrvRecord> lookupSrvRecords(String string, String string2) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        hashtable.put("java.naming.provider.url", string2);
        ArrayList<SrvRecord> arrayList = new ArrayList<SrvRecord>();
        try {
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            Attributes attributes = initialDirContext.getAttributes(string, new String[]{"SRV"});
            NamingEnumeration<?> namingEnumeration = attributes.get("srv").getAll();
            while (namingEnumeration.hasMore()) {
                arrayList.add(this.mapSrvRecord((String)namingEnumeration.next()));
            }
        }
        catch (NamingException namingException) {
            throw new IOException("Error during DNS SRV query", namingException);
        }
        return arrayList;
    }

    protected SrvRecord mapSrvRecord(String string) {
        return SrvRecord.fromSrvQueryResult(string);
    }

    protected List<SrvRecord> sort(List<SrvRecord> list) {
        Collections.sort(list);
        return list;
    }

    public static class SrvRecord
    implements Comparable<SrvRecord> {
        private final int priority;
        private final int weight;
        private final int port;
        private final String host;

        public SrvRecord(int n2, int n3, int n4, String string) {
            this.priority = n2;
            this.weight = n3;
            this.port = n4;
            int n5 = string.lastIndexOf(".");
            this.host = n5 > 0 ? string.substring(0, n5) : string;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }

        public static SrvRecord fromSrvQueryResult(String string) {
            String[] stringArray = string.split(" ");
            return new SrvRecord(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), stringArray[3]);
        }

        @Override
        public int compareTo(SrvRecord srvRecord) {
            return this.priority < srvRecord.getPriority() ? -1 : (this.priority == srvRecord.getPriority() ? 0 : 1);
        }
    }
}

