/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.FrameBuilder;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslEngineFrameBuilder
extends FrameBuilder {
    private final SSLEngine sslEngine;
    private final ByteBuffer cipherBuffer;

    public SslEngineFrameBuilder(SSLEngine sSLEngine, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ReadableByteChannel readableByteChannel) {
        super(readableByteChannel, byteBuffer);
        this.sslEngine = sSLEngine;
        this.cipherBuffer = byteBuffer2;
    }

    @Override
    protected boolean somethingToRead() throws IOException {
        SSLEngineResult sSLEngineResult;
        if (this.applicationBuffer.hasRemaining()) {
            return true;
        }
        this.applicationBuffer.clear();
        block6: while (true) {
            sSLEngineResult = this.sslEngine.unwrap(this.cipherBuffer, this.applicationBuffer);
            switch (sSLEngineResult.getStatus()) {
                case OK: {
                    this.applicationBuffer.flip();
                    if (this.applicationBuffer.hasRemaining()) {
                        return true;
                    }
                    this.applicationBuffer.clear();
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("buffer overflow in read");
                }
                case BUFFER_UNDERFLOW: {
                    this.cipherBuffer.compact();
                    int n2 = NioHelper.read(this.channel, this.cipherBuffer);
                    if (n2 == 0) {
                        return false;
                    }
                    this.cipherBuffer.flip();
                    continue block6;
                }
                case CLOSED: {
                    throw new SSLException("closed in read");
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)sSLEngineResult.getStatus()));
    }
}

