/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.Command;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.NoOpMetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQImpl;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ChannelN;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConsumerWorkService;
import java.io.IOException;

public class RecoveryAwareChannelN
extends ChannelN {
    private volatile long maxSeenDeliveryTag = 0L;
    private volatile long activeDeliveryTagOffset = 0L;

    public RecoveryAwareChannelN(AMQConnection aMQConnection, int n2, ConsumerWorkService consumerWorkService) {
        this(aMQConnection, n2, consumerWorkService, new NoOpMetricsCollector());
    }

    public RecoveryAwareChannelN(AMQConnection aMQConnection, int n2, ConsumerWorkService consumerWorkService, MetricsCollector metricsCollector) {
        super(aMQConnection, n2, consumerWorkService, metricsCollector);
    }

    @Override
    protected void processDelivery(Command command, AMQImpl.Basic.Deliver deliver) {
        long l2 = deliver.getDeliveryTag();
        if (l2 > this.maxSeenDeliveryTag) {
            this.maxSeenDeliveryTag = l2;
        }
        super.processDelivery(command, this.offsetDeliveryTag(deliver));
    }

    private AMQImpl.Basic.Deliver offsetDeliveryTag(AMQImpl.Basic.Deliver deliver) {
        return new AMQImpl.Basic.Deliver(deliver.getConsumerTag(), deliver.getDeliveryTag() + this.activeDeliveryTagOffset, deliver.getRedelivered(), deliver.getExchange(), deliver.getRoutingKey());
    }

    @Override
    public void basicAck(long l2, boolean bl2) throws IOException {
        long l3 = l2 - this.activeDeliveryTagOffset;
        if (bl2 && l2 == 0L) {
            l3 = 0L;
        } else if (l3 <= 0L) {
            return;
        }
        this.transmit(new AMQImpl.Basic.Ack(l3, bl2));
        this.metricsCollector.basicAck(this, l2, bl2);
    }

    @Override
    public void basicNack(long l2, boolean bl2, boolean bl3) throws IOException {
        long l3 = l2 - this.activeDeliveryTagOffset;
        if (bl2 && l2 == 0L) {
            l3 = 0L;
        } else if (l3 <= 0L) {
            return;
        }
        this.transmit(new AMQImpl.Basic.Nack(l3, bl2, bl3));
        this.metricsCollector.basicNack(this, l2);
    }

    @Override
    public void basicReject(long l2, boolean bl2) throws IOException {
        long l3 = l2 - this.activeDeliveryTagOffset;
        if (l3 > 0L) {
            this.transmit(new AMQImpl.Basic.Reject(l3, bl2));
            this.metricsCollector.basicReject(this, l2);
        }
    }

    void inheritOffsetFrom(RecoveryAwareChannelN recoveryAwareChannelN) {
        this.activeDeliveryTagOffset = recoveryAwareChannelN.getActiveDeliveryTagOffset() + recoveryAwareChannelN.getMaxSeenDeliveryTag();
        this.maxSeenDeliveryTag = 0L;
    }

    public long getMaxSeenDeliveryTag() {
        return this.maxSeenDeliveryTag;
    }

    public long getActiveDeliveryTagOffset() {
        return this.activeDeliveryTagOffset;
    }
}

