/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.tools.jsonrpc;

import com.contrastsecurity.thirdparty.com.rabbitmq.tools.json.JSONUtil;
import com.contrastsecurity.thirdparty.com.rabbitmq.tools.jsonrpc.ProcedureDescription;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ServiceDescription {
    public static final String JSON_RPC_VERSION = "1.1";
    public String name;
    public String id;
    public String version;
    public String summary;
    public String help;
    private Map<String, ProcedureDescription> procedures;

    public ServiceDescription(Map<String, Object> map) {
        JSONUtil.tryFill(this, map);
    }

    public ServiceDescription(Class<?> clazz) {
        this.procedures = new HashMap<String, ProcedureDescription>();
        for (Method method : clazz.getMethods()) {
            ProcedureDescription procedureDescription = new ProcedureDescription(method);
            this.addProcedure(procedureDescription);
        }
    }

    public ServiceDescription() {
    }

    public Collection<ProcedureDescription> getProcs() {
        return this.procedures.values();
    }

    public void setProcs(Collection<Map<String, Object>> collection) {
        this.procedures = new HashMap<String, ProcedureDescription>();
        for (Map<String, Object> map : collection) {
            ProcedureDescription procedureDescription = new ProcedureDescription(map);
            this.addProcedure(procedureDescription);
        }
    }

    private void addProcedure(ProcedureDescription procedureDescription) {
        this.procedures.put(procedureDescription.name + "/" + procedureDescription.arity(), procedureDescription);
    }

    public ProcedureDescription getProcedure(String string, int n2) {
        ProcedureDescription procedureDescription = this.procedures.get(string + "/" + n2);
        if (procedureDescription == null) {
            throw new IllegalArgumentException("Procedure not found: " + string + ", arity " + n2);
        }
        return procedureDescription;
    }
}

