/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe;

import com.contrastsecurity.thirdparty.dev.failsafe.CallImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.FailsafeException;
import com.contrastsecurity.thirdparty.dev.failsafe.FailsafeExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.Policy;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionResult;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.Scheduler;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.SyncExecutionInternal;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

final class SyncExecutionImpl<R>
extends ExecutionImpl<R>
implements SyncExecutionInternal<R> {
    private final FailsafeExecutor<R> executor;
    private final CallImpl<R> call;
    private Function<SyncExecutionInternal<R>, ExecutionResult<R>> outerFn;
    private final Thread executionThread;
    private final AtomicBoolean interruptable;
    private final AtomicBoolean interrupted;
    private volatile long delayNanos;

    SyncExecutionImpl(List<? extends Policy<R>> list) {
        super(list);
        this.executor = null;
        this.call = null;
        this.interruptable = new AtomicBoolean();
        this.interrupted = new AtomicBoolean();
        this.executionThread = Thread.currentThread();
        this.preExecute();
    }

    SyncExecutionImpl(FailsafeExecutor<R> failsafeExecutor, Scheduler scheduler, CallImpl<R> callImpl, Function<SyncExecutionInternal<R>, ExecutionResult<R>> function) {
        super(failsafeExecutor.policies);
        this.executor = failsafeExecutor;
        this.call = callImpl;
        this.interruptable = new AtomicBoolean();
        this.interrupted = new AtomicBoolean();
        this.executionThread = Thread.currentThread();
        if (callImpl != null) {
            callImpl.setExecution(this);
        }
        this.outerFn = function;
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerFn = policyExecutor.apply(this.outerFn, scheduler);
        }
    }

    private SyncExecutionImpl(SyncExecutionImpl<R> syncExecutionImpl) {
        super(syncExecutionImpl);
        this.executor = syncExecutionImpl.executor;
        this.call = syncExecutionImpl.call;
        this.interruptable = syncExecutionImpl.interruptable;
        this.interrupted = syncExecutionImpl.interrupted;
        this.executionThread = syncExecutionImpl.executionThread;
        if (this.call != null) {
            this.call.setExecution(this);
        }
    }

    @Override
    public void complete() {
        this.postExecute(ExecutionResult.none());
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public Duration getDelay() {
        return Duration.ofNanos(this.delayNanos);
    }

    @Override
    public void record(R r2, Throwable throwable) {
        this.preExecute();
        this.postExecute(new ExecutionResult<R>(r2, throwable));
    }

    @Override
    public void recordResult(R r2) {
        this.preExecute();
        this.postExecute(new ExecutionResult<R>(r2, null));
    }

    @Override
    public void recordException(Throwable throwable) {
        this.preExecute();
        this.postExecute(new ExecutionResult<Object>(null, throwable));
    }

    @Override
    @Deprecated
    public void recordFailure(Throwable throwable) {
        this.recordException(throwable);
    }

    @Override
    public synchronized void preExecute() {
        if (this.isStandalone()) {
            this.attemptRecorded = false;
            this.cancelledIndex = Integer.MIN_VALUE;
            this.interrupted.set(false);
        }
        super.preExecute();
        this.interruptable.set(true);
    }

    @Override
    synchronized ExecutionResult<R> postExecute(ExecutionResult<R> executionResult) {
        executionResult = super.postExecute(executionResult);
        this.delayNanos = executionResult.getDelay();
        return executionResult;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted.get();
    }

    @Override
    public void setInterruptable(boolean bl2) {
        this.interruptable.set(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.interruptable.get()) {
                this.interrupted.set(true);
                this.executionThread.interrupt();
            }
        }
    }

    private boolean isStandalone() {
        return this.executor == null;
    }

    @Override
    public SyncExecutionImpl<R> copy() {
        return this.isStandalone() ? this : new SyncExecutionImpl<R>(this);
    }

    R executeSync() {
        ExecutionResult<R> executionResult = this.outerFn.apply(this);
        this.completed = executionResult.isComplete();
        this.executor.completionHandler.accept(executionResult, this);
        Throwable throwable = executionResult.getException();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new FailsafeException(throwable);
        }
        return executionResult.getResult();
    }
}

