/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.State;
import java.io.Serializable;

public class Transition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 40001L;
    char min;
    char max;
    State to;

    public Transition(char c2, State state) {
        this.min = this.max = c2;
        this.to = state;
    }

    public Transition(char c2, char c3, State state) {
        if (c3 < c2) {
            char c4 = c3;
            c3 = c2;
            c2 = c4;
        }
        this.min = c2;
        this.max = c3;
        this.to = state;
    }

    public char getMin() {
        return this.min;
    }

    public char getMax() {
        return this.max;
    }

    public State getDest() {
        return this.to;
    }

    public boolean equals(Object object) {
        if (object instanceof Transition) {
            Transition transition = (Transition)object;
            return transition.min == this.min && transition.max == this.max && transition.to == this.to;
        }
        return false;
    }

    public int hashCode() {
        return this.min * 2 + this.max * 3;
    }

    public Transition clone() {
        try {
            return (Transition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    static void appendCharString(char c2, StringBuilder stringBuilder) {
        if (c2 >= '!' && c2 <= '~' && c2 != '\\' && c2 != '\"') {
            stringBuilder.append(c2);
        } else {
            stringBuilder.append("\\u");
            String string = Integer.toHexString(c2);
            if (c2 < '\u0010') {
                stringBuilder.append("000").append(string);
            } else if (c2 < '\u0100') {
                stringBuilder.append("00").append(string);
            } else if (c2 < '\u1000') {
                stringBuilder.append("0").append(string);
            } else {
                stringBuilder.append(string);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Transition.appendCharString(this.min, stringBuilder);
        if (this.min != this.max) {
            stringBuilder.append("-");
            Transition.appendCharString(this.max, stringBuilder);
        }
        stringBuilder.append(" -> ").append(this.to.number);
        return stringBuilder.toString();
    }

    void appendDot(StringBuilder stringBuilder) {
        stringBuilder.append(" -> ").append(this.to.number).append(" [label=\"");
        Transition.appendCharString(this.min, stringBuilder);
        if (this.min != this.max) {
            stringBuilder.append("-");
            Transition.appendCharString(this.max, stringBuilder);
        }
        stringBuilder.append("\"]\n");
    }
}

