/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.JdkLoggerFactory;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.Slf4JLoggerFactory;
import java.util.Objects;

public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory;

    private static InternalLoggerFactory newDefaultFactory(String string) {
        InternalLoggerFactory internalLoggerFactory;
        try {
            internalLoggerFactory = Slf4JLoggerFactory.INSTANCE;
            internalLoggerFactory.newInstance(string).debug("Using SLF4J as the default logging framework");
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            internalLoggerFactory = JdkLoggerFactory.INSTANCE;
            internalLoggerFactory.newInstance(string).debug("Using java.util.logging as the default logging framework");
        }
        return internalLoggerFactory;
    }

    public static InternalLoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = InternalLoggerFactory.newDefaultFactory(InternalLoggerFactory.class.getName());
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory internalLoggerFactory) {
        Objects.requireNonNull(internalLoggerFactory, "defaultFactory");
        defaultFactory = internalLoggerFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String string) {
        return InternalLoggerFactory.getDefaultFactory().newInstance(string);
    }

    protected abstract InternalLogger newInstance(String var1);
}

