/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.StringUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public interface NamingConvention {
    public static final NamingConvention identity;
    public static final NamingConvention dot;
    public static final NamingConvention snakeCase;
    public static final NamingConvention camelCase;
    public static final NamingConvention upperCamelCase;
    public static final NamingConvention slashes;

    default public String name(String string, Meter.Type type) {
        return this.name(string, type, null);
    }

    public String name(String var1, Meter.Type var2, @Nullable String var3);

    default public String tagKey(String string) {
        return string;
    }

    default public String tagValue(String string) {
        return string;
    }

    static {
        dot = identity = (string, type, string2) -> string;
        snakeCase = new NamingConvention(){

            @Override
            public String name(String string, Meter.Type type, @Nullable String string2) {
                return this.toSnakeCase(string);
            }

            @Override
            public String tagKey(String string) {
                return this.toSnakeCase(string);
            }

            private String toSnakeCase(String string) {
                return Arrays.stream(string.split("\\.")).filter(Objects::nonNull).collect(Collectors.joining("_"));
            }
        };
        camelCase = new NamingConvention(){

            @Override
            public String name(String string, Meter.Type type, @Nullable String string2) {
                return this.toCamelCase(string);
            }

            @Override
            public String tagKey(String string) {
                return this.toCamelCase(string);
            }

            private String toCamelCase(String string) {
                String[] stringArray = string.split("\\.");
                StringBuilder stringBuilder = new StringBuilder(string.length());
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string2 = stringArray[i2];
                    if (StringUtils.isEmpty(string2)) continue;
                    if (i2 == 0) {
                        stringBuilder.append(string2);
                        continue;
                    }
                    char c2 = string2.charAt(0);
                    if (Character.isUpperCase(c2)) {
                        stringBuilder.append(string2);
                        continue;
                    }
                    stringBuilder.append(Character.toUpperCase(c2)).append(string2, 1, string2.length());
                }
                return stringBuilder.toString();
            }
        };
        upperCamelCase = new NamingConvention(){

            @Override
            public String name(String string, Meter.Type type, @Nullable String string2) {
                return this.capitalize(camelCase.name(string, type, string2));
            }

            @Override
            public String tagKey(String string) {
                return this.capitalize(camelCase.tagKey(string));
            }

            private String capitalize(String string) {
                if (string.length() == 0 || Character.isUpperCase(string.charAt(0))) {
                    return string;
                }
                char[] cArray = string.toCharArray();
                cArray[0] = Character.toUpperCase(cArray[0]);
                return new String(cArray);
            }
        };
        slashes = new NamingConvention(){

            @Override
            public String name(String string, Meter.Type type, @Nullable String string2) {
                return this.toSlashes(string);
            }

            @Override
            public String tagKey(String string) {
                return this.toSlashes(string);
            }

            private String toSlashes(String string) {
                return Arrays.stream(string.split("\\.")).filter(Objects::nonNull).collect(Collectors.joining("/"));
            }
        };
    }
}

