/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public final class ValueAtPercentile {
    private final double percentile;
    private final double value;

    public ValueAtPercentile(double d2, double d3) {
        this.percentile = d2;
        this.value = d3;
    }

    public double percentile() {
        return this.percentile;
    }

    public double value() {
        return this.value;
    }

    public double value(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.value, timeUnit);
    }

    public String toString() {
        return "(" + this.value + " at " + this.percentile * 100.0 + "%)";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ValueAtPercentile valueAtPercentile = (ValueAtPercentile)object;
        return Double.compare(valueAtPercentile.percentile, this.percentile) == 0 && Double.compare(valueAtPercentile.value, this.value) == 0;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.percentile);
        int n2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.value);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }
}

