/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.search;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.search.RequiredSearch;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.search.Search;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class MeterNotFoundException
extends RuntimeException {
    private static final String OK = "OK:";
    private static final String NOT_OK = "FAIL:";

    private MeterNotFoundException(@Nullable String string, @Nullable String string2, @Nullable List<String> list) {
        super("Unable to find a meter that matches all the requirements at once. Here's what was found:" + (string == null ? "" : "\n   " + string) + (string2 == null ? "" : "\n   " + string2) + (list == null ? "" : "\n   " + list.stream().collect(Collectors.joining("\n   "))));
    }

    static MeterNotFoundException forSearch(RequiredSearch requiredSearch, Class<? extends Meter> clazz) {
        return new FromRequiredSearch(requiredSearch, clazz).build();
    }

    private static class FromRequiredSearch {
        private final RequiredSearch search;
        private final Class<? extends Meter> requiredMeterType;

        private FromRequiredSearch(RequiredSearch requiredSearch, Class<? extends Meter> clazz) {
            this.search = requiredSearch;
            this.requiredMeterType = clazz;
        }

        @Nullable
        private String nameDetail() {
            if (this.search.nameMatches == null) {
                return null;
            }
            Collection collection = Search.in(this.search.registry).name(this.search.nameMatches).meters().stream().map(meter -> meter.getId().getName()).distinct().sorted().collect(Collectors.toList());
            if (!collection.isEmpty()) {
                if (collection.size() == 1) {
                    return "OK: A meter with name '" + (String)collection.iterator().next() + "' was found.";
                }
                return "OK: Meters with names [" + collection.stream().map(string -> "'" + string + "'").collect(Collectors.joining(", ")) + "] were found.";
            }
            if (this.search.exactNameMatch != null) {
                return "FAIL: No meter with name '" + this.search.exactNameMatch + "' was found.";
            }
            return "FAIL: No meter that matches the name predicate was found.";
        }

        @Nullable
        private List<String> tagDetail() {
            String string2;
            Collection collection;
            if (this.search.requiredTagKeys.isEmpty() && this.search.requiredTags.isEmpty()) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object : this.search.requiredTagKeys) {
                collection = Search.in(this.search.registry).name(this.search.nameMatches).tagKeys(object).meters().stream().filter(this.requiredMeterType::isInstance).map(meter -> meter.getId().getName()).distinct().sorted().collect(Collectors.toList());
                string2 = "the required tag '" + object + "'.";
                if (collection.isEmpty()) {
                    arrayList.add("FAIL: No meters have " + string2);
                    continue;
                }
                if (collection.size() == 1) {
                    arrayList.add("OK: A meter with name '" + (String)collection.iterator().next() + "' has " + string2);
                    continue;
                }
                arrayList.add("OK: Meters with names [" + collection.stream().map(string -> "'" + string + "'").collect(Collectors.joining(", ")) + "] have " + string2);
            }
            for (Tag tag : this.search.requiredTags) {
                collection = Search.in(this.search.registry).name(this.search.nameMatches).tag(tag.getKey(), tag.getValue()).meters().stream().filter(this.requiredMeterType::isInstance).map(meter -> meter.getId().getName()).distinct().sorted().collect(Collectors.toList());
                string2 = "a tag '" + tag.getKey() + "' with value '" + tag.getValue() + "'.";
                if (collection.isEmpty()) {
                    Collection collection2 = Search.in(this.search.registry).name(this.search.nameMatches).tagKeys(tag.getKey()).meters().stream().filter(this.requiredMeterType::isInstance).map(meter -> meter.getId().getTag(tag.getKey())).distinct().sorted().collect(Collectors.toList());
                    if (collection2.isEmpty()) {
                        arrayList.add("FAIL: No meters have the required tag '" + tag.getKey() + "'.");
                        continue;
                    }
                    if (collection2.size() == 1) {
                        arrayList.add("FAIL: No meters have " + string2 + " The only value found was '" + (String)collection2.iterator().next() + "'.");
                        continue;
                    }
                    arrayList.add("FAIL: No meters have " + string2 + " Tag values found were [" + collection2.stream().map(string -> "'" + string + "'").collect(Collectors.joining(", ")) + "].");
                    continue;
                }
                if (collection.size() == 1) {
                    arrayList.add("OK: A meter with name '" + (String)collection.iterator().next() + "' has " + string2);
                    continue;
                }
                arrayList.add("OK: Meters with names [" + collection.stream().map(string -> "'" + string + "'").collect(Collectors.joining(", ")) + "] have " + string2);
            }
            return arrayList;
        }

        @Nullable
        private String typeDetail() {
            long l2;
            Collection<Meter> collection;
            if (this.requiredMeterType.equals(Meter.class)) {
                return null;
            }
            if (this.search.nameMatches != null && !(collection = Search.in(this.search.registry).name(this.search.nameMatches).meters()).isEmpty()) {
                Collection collection2 = collection.stream().filter(meter -> !this.requiredMeterType.isInstance(meter)).map(meter -> this.meterTypeName(meter.getClass())).distinct().sorted().collect(Collectors.toList());
                if (collection2.size() == 1) {
                    return "FAIL: Expected to find a " + this.meterTypeName(this.requiredMeterType) + ". The only type found was a " + (String)collection2.iterator().next() + ".";
                }
                if (collection2.size() > 1) {
                    return "FAIL: Expected to find a " + this.meterTypeName(this.requiredMeterType) + ". Types found were [" + collection2.stream().collect(Collectors.joining(", ")) + "].";
                }
            }
            if ((l2 = Search.in(this.search.registry).meters().stream().filter(this.requiredMeterType::isInstance).count()) == 0L) {
                return "FAIL: No meters with type " + this.meterTypeName(this.requiredMeterType) + " were found.";
            }
            if (l2 == 1L) {
                return "OK: A meter with type " + this.meterTypeName(this.requiredMeterType) + " was found.";
            }
            return "OK: Meters with type " + this.meterTypeName(this.requiredMeterType) + " were found.";
        }

        private String meterTypeName(Class<?> clazz) {
            if (Counter.class.isAssignableFrom(clazz)) {
                return "counter";
            }
            if (Gauge.class.isAssignableFrom(clazz)) {
                return "gauge";
            }
            if (LongTaskTimer.class.isAssignableFrom(clazz)) {
                return "long task timer";
            }
            if (Timer.class.isAssignableFrom(clazz)) {
                return "timer";
            }
            if (FunctionTimer.class.isAssignableFrom(clazz)) {
                return "function timer";
            }
            if (FunctionCounter.class.isAssignableFrom(clazz)) {
                return "function counter";
            }
            if (TimeGauge.class.isAssignableFrom(clazz)) {
                return "time gauge";
            }
            if (DistributionSummary.class.isAssignableFrom(clazz)) {
                return "distribution summary";
            }
            return clazz.getSimpleName();
        }

        private MeterNotFoundException build() {
            return new MeterNotFoundException(this.nameDetail(), this.typeDetail(), this.tagDetail());
        }
    }
}

