/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public abstract class StepValue<V> {
    private final Clock clock;
    private final long stepMillis;
    private final AtomicLong lastInitPos;
    private volatile V previous;

    public StepValue(Clock clock, long l2) {
        this(clock, l2, null);
    }

    protected StepValue(Clock clock, long l2, @Nullable V v2) {
        this.clock = clock;
        this.stepMillis = l2;
        this.previous = v2 == null ? this.noValue() : v2;
        this.lastInitPos = new AtomicLong(clock.wallTime() / l2);
    }

    protected abstract Supplier<V> valueSupplier();

    protected abstract V noValue();

    private void rollCount(long l2) {
        long l3 = l2 / this.stepMillis;
        long l4 = this.lastInitPos.get();
        if (l4 < l3 && this.lastInitPos.compareAndSet(l4, l3)) {
            V v2 = this.valueSupplier().get();
            this.previous = l4 == l3 - 1L ? v2 : this.noValue();
        }
    }

    public V poll() {
        this.rollCount(this.clock.wallTime());
        return this.previous;
    }

    protected void _closingRollover() {
        this.lastInitPos.set(Long.MAX_VALUE);
        this.previous = this.valueSupplier().get();
    }
}

