/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.internal;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class OtelEncodingUtils {
    static final int LONG_BYTES = 8;
    static final int BYTE_BASE16 = 2;
    static final int LONG_BASE16 = 16;
    private static final String ALPHABET = "0123456789abcdef";
    private static final int NUM_ASCII_CHARACTERS = 128;
    private static final char[] ENCODING = OtelEncodingUtils.buildEncodingArray();
    private static final byte[] DECODING = OtelEncodingUtils.buildDecodingArray();
    private static final boolean[] VALID_HEX = OtelEncodingUtils.buildValidHexArray();

    private static char[] buildEncodingArray() {
        char[] cArray = new char[512];
        for (int i2 = 0; i2 < 256; ++i2) {
            cArray[i2] = ALPHABET.charAt(i2 >>> 4);
            cArray[i2 | 0x100] = ALPHABET.charAt(i2 & 0xF);
        }
        return cArray;
    }

    private static byte[] buildDecodingArray() {
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)-1);
        for (int i2 = 0; i2 < ALPHABET.length(); ++i2) {
            char c2 = ALPHABET.charAt(i2);
            byArray[c2] = (byte)i2;
        }
        return byArray;
    }

    private static boolean[] buildValidHexArray() {
        boolean[] blArray = new boolean[65535];
        for (int i2 = 0; i2 < 65535; ++i2) {
            blArray[i2] = 48 <= i2 && i2 <= 57 || 97 <= i2 && i2 <= 102;
        }
        return blArray;
    }

    public static long longFromBase16String(CharSequence charSequence, int n2) {
        return ((long)OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2), charSequence.charAt(n2 + 1)) & 0xFFL) << 56 | ((long)OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2 + 2), charSequence.charAt(n2 + 3)) & 0xFFL) << 48 | ((long)OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2 + 4), charSequence.charAt(n2 + 5)) & 0xFFL) << 40 | ((long)OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2 + 6), charSequence.charAt(n2 + 7)) & 0xFFL) << 32 | ((long)OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2 + 8), charSequence.charAt(n2 + 9)) & 0xFFL) << 24 | ((long)OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2 + 10), charSequence.charAt(n2 + 11)) & 0xFFL) << 16 | ((long)OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2 + 12), charSequence.charAt(n2 + 13)) & 0xFFL) << 8 | (long)OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2 + 14), charSequence.charAt(n2 + 15)) & 0xFFL;
    }

    public static void longToBase16String(long l2, char[] cArray, int n2) {
        OtelEncodingUtils.byteToBase16((byte)(l2 >> 56 & 0xFFL), cArray, n2);
        OtelEncodingUtils.byteToBase16((byte)(l2 >> 48 & 0xFFL), cArray, n2 + 2);
        OtelEncodingUtils.byteToBase16((byte)(l2 >> 40 & 0xFFL), cArray, n2 + 4);
        OtelEncodingUtils.byteToBase16((byte)(l2 >> 32 & 0xFFL), cArray, n2 + 6);
        OtelEncodingUtils.byteToBase16((byte)(l2 >> 24 & 0xFFL), cArray, n2 + 8);
        OtelEncodingUtils.byteToBase16((byte)(l2 >> 16 & 0xFFL), cArray, n2 + 10);
        OtelEncodingUtils.byteToBase16((byte)(l2 >> 8 & 0xFFL), cArray, n2 + 12);
        OtelEncodingUtils.byteToBase16((byte)(l2 & 0xFFL), cArray, n2 + 14);
    }

    public static byte[] bytesFromBase16(CharSequence charSequence, int n2) {
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            byArray[i2 / 2] = OtelEncodingUtils.byteFromBase16(charSequence.charAt(i2), charSequence.charAt(i2 + 1));
        }
        return byArray;
    }

    public static void bytesToBase16(byte[] byArray, char[] cArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            OtelEncodingUtils.byteToBase16(byArray[i2], cArray, i2 * 2);
        }
    }

    public static void byteToBase16(byte by, char[] cArray, int n2) {
        int n3 = by & 0xFF;
        cArray[n2] = ENCODING[n3];
        cArray[n2 + 1] = ENCODING[n3 | 0x100];
    }

    public static byte byteFromBase16(char c2, char c3) {
        if (c2 >= '\u0080' || DECODING[c2] == -1) {
            throw new IllegalArgumentException("invalid character " + c2);
        }
        if (c3 >= '\u0080' || DECODING[c3] == -1) {
            throw new IllegalArgumentException("invalid character " + c3);
        }
        int n2 = DECODING[c2] << 4 | DECODING[c3];
        return (byte)n2;
    }

    public static boolean isValidBase16String(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (OtelEncodingUtils.isValidBase16Character(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidBase16Character(char c2) {
        return VALID_HEX[c2];
    }

    private OtelEncodingUtils() {
    }
}

