/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.context;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ContextStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Scope;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.internal.shaded.AbstractWeakConcurrentMap;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class StrictContextStorage
implements ContextStorage,
AutoCloseable {
    private static final e logger = e.a(StrictContextStorage.class.getName());
    private final ContextStorage delegate;
    private final PendingScopes pendingScopes;

    static StrictContextStorage create(ContextStorage contextStorage) {
        return new StrictContextStorage(contextStorage);
    }

    private StrictContextStorage(ContextStorage contextStorage) {
        this.delegate = contextStorage;
        this.pendingScopes = PendingScopes.create();
    }

    @Override
    public Scope attach(Context context) {
        Object object;
        int n2;
        Scope scope = this.delegate.attach(context);
        CallerStackTrace callerStackTrace = new CallerStackTrace(context);
        StackTraceElement[] stackTraceElementArray = callerStackTrace.getStackTrace();
        for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
            StackTraceElement stackTraceElement;
            object = stackTraceElementArray[n2];
            if (((StackTraceElement)object).getClassName().equals(Context.class.getName()) && ((StackTraceElement)object).getMethodName().equals("makeCurrent") && n2 + 2 < stackTraceElementArray.length && (stackTraceElement = stackTraceElementArray[n2 + 2]).getClassName().equals("kotlin.coroutines.jvm.internal.BaseContinuationImpl") && stackTraceElement.getMethodName().equals("resumeWith")) {
                throw new AssertionError((Object)"Attempting to call Context.makeCurrent from inside a Kotlin coroutine. This is not allowed. Use Context.asContextElement provided by opentelemetry-extension-kotlin instead of makeCurrent.");
            }
        }
        for (n2 = 1; n2 < stackTraceElementArray.length && (((String)(object = stackTraceElementArray[n2].getClassName())).startsWith("com.contrastsecurity.thirdparty.io.opentelemetry.api.") || ((String)object).startsWith("com.contrastsecurity.thirdparty.io.opentelemetry.sdk.testing.context.SettableContextStorageProvider") || ((String)object).startsWith("com.contrastsecurity.thirdparty.io.opentelemetry.context.")); ++n2) {
        }
        int n3 = n2;
        stackTraceElementArray = Arrays.copyOfRange(stackTraceElementArray, n3, stackTraceElementArray.length);
        callerStackTrace.setStackTrace(stackTraceElementArray);
        return new StrictScope(scope, callerStackTrace);
    }

    @Override
    @Nullable
    public Context current() {
        return this.delegate.current();
    }

    @Override
    public void close() {
        this.pendingScopes.expungeStaleEntries();
        List<CallerStackTrace> list = this.pendingScopes.drainPendingCallers();
        if (!list.isEmpty()) {
            if (list.size() > 1) {
                logger.a(e.a.b, "Multiple scopes leaked - first will be thrown as an error.");
                for (CallerStackTrace callerStackTrace : list) {
                    logger.a(e.a.b, "Scope leaked", (Throwable)((Object)StrictContextStorage.callerError(callerStackTrace)));
                }
            }
            throw StrictContextStorage.callerError(list.get(0));
        }
    }

    static AssertionError callerError(CallerStackTrace callerStackTrace) {
        AssertionError assertionError = new AssertionError((Object)("Thread [" + callerStackTrace.threadName + "] opened a scope of " + callerStackTrace.context + " here:"));
        ((Throwable)((Object)assertionError)).setStackTrace(callerStackTrace.getStackTrace());
        return assertionError;
    }

    static class PendingScopes
    extends WeakConcurrentMap<Scope, CallerStackTrace> {
        private final ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace> map;

        static PendingScopes create() {
            return new PendingScopes(new ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace>());
        }

        PendingScopes(ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace> concurrentHashMap) {
            super(false, false, concurrentHashMap);
            this.map = concurrentHashMap;
            Thread thread = new Thread(this);
            thread.setName("weak-ref-cleaner-strictcontextstorage");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
        }

        List<CallerStackTrace> drainPendingCallers() {
            List<CallerStackTrace> list = this.map.values().stream().filter(callerStackTrace -> !callerStackTrace.closed).collect(Collectors.toList());
            this.map.clear();
            return list;
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    CallerStackTrace callerStackTrace = this.map.remove(this.remove());
                    if (callerStackTrace == null || callerStackTrace.closed) continue;
                    logger.a(e.a.b, "Scope garbage collected before being closed.", (Throwable)((Object)StrictContextStorage.callerError(callerStackTrace)));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class CallerStackTrace
    extends Throwable {
        final String threadName = Thread.currentThread().getName();
        final long threadId = Thread.currentThread().getId();
        final Context context;
        volatile boolean closed;

        CallerStackTrace(Context context) {
            super("Thread [" + Thread.currentThread().getName() + "] opened scope for " + context + " here:");
            this.context = context;
        }
    }

    final class StrictScope
    implements Scope {
        final Scope delegate;
        final CallerStackTrace caller;

        StrictScope(Scope scope, CallerStackTrace callerStackTrace) {
            this.delegate = scope;
            this.caller = callerStackTrace;
            StrictContextStorage.this.pendingScopes.put(this, callerStackTrace);
        }

        @Override
        public void close() {
            this.caller.closed = true;
            StrictContextStorage.this.pendingScopes.remove(this);
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
                StackTraceElement stackTraceElement;
                StackTraceElement stackTraceElement2 = stackTraceElementArray[i2];
                if (!stackTraceElement2.getClassName().equals(StrictScope.class.getName()) || !stackTraceElement2.getMethodName().equals("close")) continue;
                int n2 = i2 + 2;
                if (i2 + 1 < stackTraceElementArray.length && (stackTraceElement = stackTraceElementArray[i2 + 1]).getClassName().equals("kotlin.jdk7.AutoCloseableKt") && stackTraceElement.getMethodName().equals("closeFinally") && i2 + 2 < stackTraceElementArray.length) {
                    n2 = i2 + 3;
                }
                if (stackTraceElementArray[n2].getMethodName().equals("invokeSuspend")) {
                    ++n2;
                }
                if (n2 < stackTraceElementArray.length && (stackTraceElement = stackTraceElementArray[n2]).getClassName().equals("kotlin.coroutines.jvm.internal.BaseContinuationImpl") && stackTraceElement.getMethodName().equals("resumeWith")) {
                    throw new AssertionError((Object)"Attempting to close a Scope created by Context.makeCurrent from inside a Kotlin coroutine. This is not allowed. Use Context.asContextElement provided by opentelemetry-extension-kotlin instead of makeCurrent.");
                }
            }
            if (Thread.currentThread().getId() != this.caller.threadId) {
                throw new IllegalStateException(String.format("Thread [%s] opened scope, but thread [%s] closed it", this.caller.threadName, Thread.currentThread().getName()), this.caller);
            }
            this.delegate.close();
        }

        public String toString() {
            String string = this.caller.getMessage();
            return string != null ? string : super.toString();
        }
    }
}

