/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.context.internal.shaded;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.internal.shaded.AbstractWeakConcurrentMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class WeakConcurrentMap<K, V>
extends AbstractWeakConcurrentMap<K, V, LookupKey<K>> {
    private static final ThreadLocal<LookupKey<?>> LOOKUP_KEY_CACHE = new ThreadLocal<LookupKey<?>>(){

        @Override
        protected LookupKey<?> initialValue() {
            return new LookupKey();
        }
    };
    private static final AtomicLong ID = new AtomicLong();
    private final Thread thread;
    private final boolean reuseKeys;

    public WeakConcurrentMap(boolean bl2) {
        this(bl2, WeakConcurrentMap.isPersistentClassLoader(LookupKey.class.getClassLoader()));
    }

    private static boolean isPersistentClassLoader(ClassLoader classLoader) {
        try {
            return classLoader == null || classLoader == ClassLoader.getSystemClassLoader() || classLoader == ClassLoader.getSystemClassLoader().getParent();
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            return false;
        }
    }

    public WeakConcurrentMap(boolean bl2, boolean bl3) {
        this(bl2, bl3, new ConcurrentHashMap());
    }

    public WeakConcurrentMap(boolean bl2, boolean bl3, ConcurrentMap<AbstractWeakConcurrentMap.WeakKey<K>, V> concurrentMap) {
        super(concurrentMap);
        this.reuseKeys = bl3;
        if (bl2) {
            this.thread = new Thread(this);
            this.thread.setName("weak-ref-cleaner-" + ID.getAndIncrement());
            this.thread.setPriority(1);
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.thread = null;
        }
    }

    @Override
    protected LookupKey<K> getLookupKey(K k2) {
        LookupKey<Object> lookupKey = this.reuseKeys ? LOOKUP_KEY_CACHE.get() : new LookupKey();
        return lookupKey.withValue(k2);
    }

    @Override
    protected void resetLookupKey(LookupKey<K> lookupKey) {
        lookupKey.reset();
    }

    public Thread getCleanerThread() {
        return this.thread;
    }

    static final class LookupKey<K> {
        private K key;
        private int hashCode;

        LookupKey() {
        }

        LookupKey<K> withValue(K k2) {
            this.key = k2;
            this.hashCode = System.identityHashCode(k2);
            return this;
        }

        void reset() {
            this.key = null;
            this.hashCode = 0;
        }

        public boolean equals(Object object) {
            if (object instanceof LookupKey) {
                return ((LookupKey)object).key == this.key;
            }
            return ((AbstractWeakConcurrentMap.WeakKey)object).get() == this.key;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class WithInlinedExpunction<K, V>
    extends WeakConcurrentMap<K, V> {
        public WithInlinedExpunction() {
            super(false);
        }

        @Override
        public V get(K k2) {
            this.expungeStaleEntries();
            return (V)super.get((Object)k2);
        }

        @Override
        public boolean containsKey(K k2) {
            this.expungeStaleEntries();
            return super.containsKey((Object)k2);
        }

        @Override
        public V put(K k2, V v2) {
            this.expungeStaleEntries();
            return (V)super.put((Object)k2, (Object)v2);
        }

        @Override
        public V remove(K k2) {
            this.expungeStaleEntries();
            return (V)super.remove((Object)k2);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            this.expungeStaleEntries();
            return super.iterator();
        }

        @Override
        public int approximateSize() {
            this.expungeStaleEntries();
            return super.approximateSize();
        }
    }
}

