/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class TlsUtil {
    private static final String PEM_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PEM_KEY_FOOTER = "-----END PRIVATE KEY-----";
    private static final List<KeyFactory> SUPPORTED_KEY_FACTORIES = new ArrayList<KeyFactory>();

    private TlsUtil() {
    }

    public static X509KeyManager keyManager(byte[] byArray, byte[] byArray2) throws SSLException {
        Objects.requireNonNull(byArray, "privateKeyPem");
        Objects.requireNonNull(byArray2, "certificatePem");
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(TlsUtil.decodePem(byArray));
            PrivateKey privateKey = TlsUtil.generatePrivateKey(pKCS8EncodedKeySpec, SUPPORTED_KEY_FACTORIES);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            while (byteArrayInputStream.available() > 0) {
                arrayList.add(certificateFactory.generateCertificate(byteArrayInputStream));
            }
            keyStore.setKeyEntry("trusted", privateKey, "".toCharArray(), arrayList.toArray(new Certificate[0]));
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, "".toCharArray());
            return (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException exception) {
            throw new SSLException("Could not build KeyManagerFactory from clientKeysPem.", exception);
        }
    }

    static PrivateKey generatePrivateKey(PKCS8EncodedKeySpec pKCS8EncodedKeySpec, List<KeyFactory> list) throws SSLException {
        for (KeyFactory keyFactory : list) {
            try {
                return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        throw new SSLException("Unable to generate key from supported algorithms: " + list.stream().map(KeyFactory::getAlgorithm).collect(Collectors.joining(",", "[", "]")));
    }

    public static X509TrustManager trustManager(byte[] byArray) throws SSLException {
        Objects.requireNonNull(byArray, "trustedCertificatesPem");
        try {
            Object object;
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            int n2 = 0;
            while (byteArrayInputStream.available() > 0) {
                object = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                keyStore.setCertificateEntry("cert_" + n2, (Certificate)object);
                ++n2;
            }
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init(keyStore);
            return (X509TrustManager)((TrustManagerFactory)object).getTrustManagers()[0];
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new SSLException("Could not build TrustManagerFactory from trustedCertificatesPem.", exception);
        }
    }

    @IgnoreJRERequirement
    static byte[] decodePem(byte[] byArray) {
        String string = new String(byArray, StandardCharsets.UTF_8).trim();
        if (!string.startsWith(PEM_KEY_HEADER) || !string.endsWith(PEM_KEY_FOOTER)) {
            return byArray;
        }
        String string2 = string.substring(PEM_KEY_HEADER.length(), string.length() - PEM_KEY_FOOTER.length());
        String string3 = string2.replaceAll("\\s", "");
        try {
            return Base64.getDecoder().decode(string3);
        }
        catch (LinkageError linkageError) {
            throw new IllegalArgumentException("PEM private keys are currently not supported on Android. You may try a key encoded as DER.");
        }
    }

    static {
        try {
            SUPPORTED_KEY_FACTORIES.add(KeyFactory.getInstance("RSA"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            SUPPORTED_KEY_FACTORIES.add(KeyFactory.getInstance("EC"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

