/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.RetryUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.export.RetryPolicy;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class ManagedChannelUtil {
    private static final e logger = e.a(ManagedChannelUtil.class.getName());

    public static Map<String, ?> toServiceConfig(String string, RetryPolicy retryPolicy) {
        List list = RetryUtil.retryableGrpcStatusCodes().stream().map(Double::parseDouble).collect(Collectors.toList());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("retryableStatusCodes", list);
        hashMap.put("maxAttempts", Double.valueOf(retryPolicy.getMaxAttempts()));
        hashMap.put("initialBackoff", (double)retryPolicy.getInitialBackoff().toMillis() / 1000.0 + "s");
        hashMap.put("maxBackoff", (double)retryPolicy.getMaxBackoff().toMillis() / 1000.0 + "s");
        hashMap.put("backoffMultiplier", retryPolicy.getBackoffMultiplier());
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("name", Collections.singletonList(Collections.singletonMap("service", string)));
        hashMap2.put("retryPolicy", hashMap);
        return Collections.singletonMap("methodConfig", Collections.singletonList(hashMap2));
    }

    public static CompletableResultCode shutdownChannel(ManagedChannel managedChannel) {
        CompletableResultCode completableResultCode = new CompletableResultCode();
        managedChannel.shutdown();
        Thread thread = new Thread(() -> {
            try {
                managedChannel.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                logger.a(e.a.c, "Failed to shutdown the gRPC channel", interruptedException);
                completableResultCode.fail();
            }
            completableResultCode.succeed();
        });
        thread.setDaemon(true);
        thread.setName("grpc-cleanup");
        thread.start();
        return completableResultCode;
    }

    private ManagedChannelUtil() {
    }
}

