/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanId;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceId;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MarshalerUtil {
    private static final int TRACE_ID_VALUE_SIZE = CodedOutputStream.computeLengthDelimitedFieldSize(TraceId.getLength() / 2);
    private static final int SPAN_ID_VALUE_SIZE = CodedOutputStream.computeLengthDelimitedFieldSize(SpanId.getLength() / 2);
    private static final boolean JSON_AVAILABLE;
    private static final byte[] EMPTY_BYTES;

    public static <T, U> Map<Resource, Map<InstrumentationScopeInfo, List<U>>> groupByResourceAndScope(Collection<T> collection, Function<T, Resource> function, Function<T, InstrumentationScopeInfo> function2, Function<T, U> function3) {
        IdentityHashMap<Resource, Map<InstrumentationScopeInfo, List<U>>> identityHashMap = new IdentityHashMap<Resource, Map<InstrumentationScopeInfo, List<U>>>(8);
        for (T t2 : collection) {
            Map map = identityHashMap.computeIfAbsent(function.apply(t2), resource -> new IdentityHashMap(8));
            List list = map.computeIfAbsent(function2.apply(t2), instrumentationScopeInfo -> new ArrayList());
            list.add(function3.apply(t2));
        }
        return identityHashMap;
    }

    public static String preserializeJsonFields(Marshaler marshaler) {
        if (!JSON_AVAILABLE) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            marshaler.writeJsonTo(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new String(byArray, 1, byArray.length - 2, StandardCharsets.UTF_8);
    }

    public static int sizeRepeatedFixed64(ProtoFieldInfo protoFieldInfo, List<Long> list) {
        return MarshalerUtil.sizeRepeatedFixed64(protoFieldInfo, list.size());
    }

    private static int sizeRepeatedFixed64(ProtoFieldInfo protoFieldInfo, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 8 * n2;
        int n4 = 0;
        n4 += protoFieldInfo.getTagSize();
        return n4 += CodedOutputStream.computeLengthDelimitedFieldSize(n3);
    }

    public static int sizeRepeatedUInt64(ProtoFieldInfo protoFieldInfo, long[] lArray) {
        if (lArray.length == 0) {
            return 0;
        }
        int n2 = 0;
        for (long l2 : lArray) {
            n2 += CodedOutputStream.computeUInt64SizeNoTag(l2);
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(n2) + n2;
    }

    public static int sizeRepeatedDouble(ProtoFieldInfo protoFieldInfo, List<Double> list) {
        return MarshalerUtil.sizeRepeatedFixed64(protoFieldInfo, list.size());
    }

    public static <T extends Marshaler> int sizeRepeatedMessage(ProtoFieldInfo protoFieldInfo, T[] TArray) {
        int n2 = 0;
        int n3 = protoFieldInfo.getTagSize();
        for (T t2 : TArray) {
            int n4 = ((Marshaler)t2).getBinarySerializedSize();
            n2 += n3 + CodedOutputStream.computeUInt32SizeNoTag(n4) + n4;
        }
        return n2;
    }

    public static int sizeRepeatedMessage(ProtoFieldInfo protoFieldInfo, List<? extends Marshaler> list) {
        int n2 = 0;
        int n3 = protoFieldInfo.getTagSize();
        for (Marshaler marshaler : list) {
            int n4 = marshaler.getBinarySerializedSize();
            n2 += n3 + CodedOutputStream.computeUInt32SizeNoTag(n4) + n4;
        }
        return n2;
    }

    public static int sizeMessage(ProtoFieldInfo protoFieldInfo, Marshaler marshaler) {
        int n2 = marshaler.getBinarySerializedSize();
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(n2) + n2;
    }

    public static int sizeBool(ProtoFieldInfo protoFieldInfo, boolean bl2) {
        if (!bl2) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeBoolSizeNoTag(bl2);
    }

    public static int sizeInt64(ProtoFieldInfo protoFieldInfo, long l2) {
        if (l2 == 0L) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeInt64SizeNoTag(l2);
    }

    public static int sizeUInt32(ProtoFieldInfo protoFieldInfo, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(n2);
    }

    public static int sizeSInt32(ProtoFieldInfo protoFieldInfo, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeSInt32SizeNoTag(n2);
    }

    public static int sizeInt32(ProtoFieldInfo protoFieldInfo, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int sizeDouble(ProtoFieldInfo protoFieldInfo, double d2) {
        if (d2 == 0.0) {
            return 0;
        }
        return MarshalerUtil.sizeDoubleOptional(protoFieldInfo, d2);
    }

    public static int sizeDoubleOptional(ProtoFieldInfo protoFieldInfo, double d2) {
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeDoubleSizeNoTag(d2);
    }

    public static int sizeFixed64(ProtoFieldInfo protoFieldInfo, long l2) {
        if (l2 == 0L) {
            return 0;
        }
        return MarshalerUtil.sizeFixed64Optional(protoFieldInfo, l2);
    }

    public static int sizeFixed64Optional(ProtoFieldInfo protoFieldInfo, long l2) {
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeFixed64SizeNoTag(l2);
    }

    public static int sizeFixed32(ProtoFieldInfo protoFieldInfo, int n2) {
        if ((long)n2 == 0L) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeFixed32SizeNoTag(n2);
    }

    public static int sizeBytes(ProtoFieldInfo protoFieldInfo, byte[] byArray) {
        if (byArray.length == 0) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(byArray);
    }

    public static int sizeEnum(ProtoFieldInfo protoFieldInfo, ProtoEnumInfo protoEnumInfo) {
        int n2 = protoEnumInfo.getEnumNumber();
        if (n2 == 0) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + CodedOutputStream.computeEnumSizeNoTag(n2);
    }

    public static int sizeTraceId(ProtoFieldInfo protoFieldInfo, @Nullable String string) {
        if (string == null) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + TRACE_ID_VALUE_SIZE;
    }

    public static int sizeSpanId(ProtoFieldInfo protoFieldInfo, @Nullable String string) {
        if (string == null) {
            return 0;
        }
        return protoFieldInfo.getTagSize() + SPAN_ID_VALUE_SIZE;
    }

    public static byte[] toBytes(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return EMPTY_BYTES;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private MarshalerUtil() {
    }

    static {
        boolean bl2 = false;
        try {
            Class.forName("com.contrastsecurity.thirdparty.com.fasterxml.jackson.core.JsonFactory");
            bl2 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JSON_AVAILABLE = bl2;
        EMPTY_BYTES = new byte[0];
    }
}

