/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogramDataPoint;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.PrimitiveLongList;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import java.io.IOException;
import java.util.List;

public class ExponentialHistogramBucketsMarshaler
extends MarshalerWithSize {
    private final int offset;
    private final List<Long> counts;

    static ExponentialHistogramBucketsMarshaler create(ExponentialHistogramBuckets exponentialHistogramBuckets) {
        return new ExponentialHistogramBucketsMarshaler(exponentialHistogramBuckets.getOffset(), exponentialHistogramBuckets.getBucketCounts());
    }

    private ExponentialHistogramBucketsMarshaler(int n2, List<Long> list) {
        super(ExponentialHistogramBucketsMarshaler.calculateSize(n2, list));
        this.offset = n2;
        this.counts = list;
    }

    @Override
    protected void writeTo(Serializer serializer) throws IOException {
        serializer.serializeSInt32(ExponentialHistogramDataPoint.Buckets.OFFSET, this.offset);
        serializer.serializeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, PrimitiveLongList.toArray(this.counts));
    }

    private static int calculateSize(int n2, List<Long> list) {
        int n3 = 0;
        n3 += MarshalerUtil.sizeSInt32(ExponentialHistogramDataPoint.Buckets.OFFSET, n2);
        return n3 += MarshalerUtil.sizeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, PrimitiveLongList.toArray(list));
    }
}

