/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.trace;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.SpanData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpSpanExporter
implements SpanExporter {
    private final HttpExporterBuilder<TraceRequestMarshaler> builder;
    private final HttpExporter<TraceRequestMarshaler> delegate;

    OtlpHttpSpanExporter(HttpExporterBuilder<TraceRequestMarshaler> httpExporterBuilder, HttpExporter<TraceRequestMarshaler> httpExporter) {
        this.builder = httpExporterBuilder;
        this.delegate = httpExporter;
    }

    public static OtlpHttpSpanExporter getDefault() {
        return OtlpHttpSpanExporter.builder().build();
    }

    public static OtlpHttpSpanExporterBuilder builder() {
        return new OtlpHttpSpanExporterBuilder();
    }

    public OtlpHttpSpanExporterBuilder toBuilder() {
        return new OtlpHttpSpanExporterBuilder(this.builder.copy());
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> collection) {
        TraceRequestMarshaler traceRequestMarshaler = TraceRequestMarshaler.create(collection);
        return this.delegate.export(traceRequestMarshaler, collection.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpHttpSpanExporter{" + this.builder.toString(false) + "}";
    }
}

