/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.trace;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Utils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.export.RetryPolicy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpHttpSpanExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/traces";
    private final HttpExporterBuilder<TraceRequestMarshaler> delegate;

    OtlpHttpSpanExporterBuilder(HttpExporterBuilder<TraceRequestMarshaler> httpExporterBuilder) {
        this.delegate = httpExporterBuilder;
        OtlpUserAgent.addUserAgentHeader(httpExporterBuilder::addHeader);
    }

    OtlpHttpSpanExporterBuilder() {
        this(new HttpExporterBuilder<TraceRequestMarshaler>("otlp", "span", DEFAULT_ENDPOINT));
    }

    public OtlpHttpSpanExporterBuilder setTimeout(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(l2, timeUnit);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setTimeout(Duration duration) {
        Objects.requireNonNull(duration, "timeout");
        return this.setTimeout(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpSpanExporterBuilder setEndpoint(String string) {
        Objects.requireNonNull(string, "endpoint");
        this.delegate.setEndpoint(string);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setCompression(String string) {
        Objects.requireNonNull(string, "compressionMethod");
        Utils.checkArgument(string.equals("gzip") || string.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(string);
        return this;
    }

    public OtlpHttpSpanExporterBuilder addHeader(String string, String string2) {
        this.delegate.addHeader(string, string2);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setTrustedCertificates(byte[] byArray) {
        this.delegate.setTrustManagerFromCerts(byArray);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setClientTls(byte[] byArray, byte[] byArray2) {
        this.delegate.setKeyManagerFromCerts(byArray, byArray2);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        this.delegate.setSslContext(sSLContext, x509TrustManager);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.delegate.setMeterProvider(meterProvider);
        return this;
    }

    public OtlpHttpSpanExporter build() {
        return new OtlpHttpSpanExporter(this.delegate, this.delegate.build());
    }
}

