/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.logs;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Utils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.logs.LogsRequestMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.logs.MarshalerLogsServiceGrpc;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.export.RetryPolicy;
import io.grpc.ManagedChannel;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpGrpcLogRecordExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "com.contrastsecurity.thirdparty.opentelemetry.proto.collector.logs.v1.LogsService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.logs.v1.LogsService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    final GrpcExporterBuilder<LogsRequestMarshaler> delegate;

    OtlpGrpcLogRecordExporterBuilder(GrpcExporterBuilder<LogsRequestMarshaler> grpcExporterBuilder) {
        this.delegate = grpcExporterBuilder;
        OtlpUserAgent.addUserAgentHeader(grpcExporterBuilder::addHeader);
    }

    OtlpGrpcLogRecordExporterBuilder() {
        this(new GrpcExporterBuilder<LogsRequestMarshaler>("otlp", "log", 10L, DEFAULT_ENDPOINT, () -> MarshalerLogsServiceGrpc::newFutureStub, GRPC_ENDPOINT_PATH));
    }

    @Deprecated
    public OtlpGrpcLogRecordExporterBuilder setChannel(ManagedChannel managedChannel) {
        this.delegate.setChannel(managedChannel);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTimeout(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(l2, timeUnit);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTimeout(Duration duration) {
        Objects.requireNonNull(duration, "timeout");
        this.delegate.setTimeout(duration);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setEndpoint(String string) {
        Objects.requireNonNull(string, "endpoint");
        this.delegate.setEndpoint(string);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setCompression(String string) {
        Objects.requireNonNull(string, "compressionMethod");
        Utils.checkArgument(string.equals("gzip") || string.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(string);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTrustedCertificates(byte[] byArray) {
        this.delegate.setTrustManagerFromCerts(byArray);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setClientTls(byte[] byArray, byte[] byArray2) {
        this.delegate.setKeyManagerFromCerts(byArray, byArray2);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        this.delegate.setSslContext(sSLContext, x509TrustManager);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder addHeader(String string, String string2) {
        this.delegate.addHeader(string, string2);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.delegate.setMeterProvider(meterProvider);
        return this;
    }

    public OtlpGrpcLogRecordExporter build() {
        return new OtlpGrpcLogRecordExporter(this.delegate, this.delegate.build());
    }
}

