/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.logs.Severity;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.AttributesMap;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.LogLimits;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.SdkLogRecordData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.data.Body;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.data.LogRecordData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SdkReadWriteLogRecord
implements ReadWriteLogRecord {
    private final LogLimits logLimits;
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long timestampEpochNanos;
    private final long observedTimestampEpochNanos;
    private final SpanContext spanContext;
    private final Severity severity;
    @Nullable
    private final String severityText;
    private final Body body;
    private final Object lock = new Object();
    @Nullable
    private AttributesMap attributes;

    private SdkReadWriteLogRecord(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long l2, long l3, SpanContext spanContext, Severity severity, @Nullable String string, Body body, @Nullable AttributesMap attributesMap) {
        this.logLimits = logLimits;
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = l2;
        this.observedTimestampEpochNanos = l3;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = string;
        this.body = body;
        this.attributes = attributesMap;
    }

    static SdkReadWriteLogRecord create(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long l2, long l3, SpanContext spanContext, Severity severity, @Nullable String string, Body body, @Nullable AttributesMap attributesMap) {
        return new SdkReadWriteLogRecord(logLimits, resource, instrumentationScopeInfo, l2, l3, spanContext, severity, string, body, attributesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadWriteLogRecord setAttribute(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null || attributeKey.getKey().isEmpty() || t2 == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(attributeKey, t2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getImmutableAttributes() {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return Attributes.empty();
            }
            return this.attributes.immutableCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogRecordData toLogRecordData() {
        Object object = this.lock;
        synchronized (object) {
            return SdkLogRecordData.create(this.resource, this.instrumentationScopeInfo, this.timestampEpochNanos, this.observedTimestampEpochNanos, this.spanContext, this.severity, this.severityText, this.body, this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues());
        }
    }
}

