/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data;

import com.contrastsecurity.thirdparty.com.google.auto.value.AutoValue;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.PrimitiveLongList;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.AutoValue_ImmutableHistogramPointData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class ImmutableHistogramPointData
implements HistogramPointData {
    public static ImmutableHistogramPointData create(long l2, long l3, Attributes attributes, double d2, boolean bl2, double d3, boolean bl3, double d4, List<Double> list, List<Long> list2) {
        return ImmutableHistogramPointData.create(l2, l3, attributes, d2, bl2, d3, bl3, d4, list, list2, Collections.emptyList());
    }

    public static ImmutableHistogramPointData create(long l2, long l3, Attributes attributes, double d2, boolean bl2, double d3, boolean bl3, double d4, List<Double> list, List<Long> list2, List<DoubleExemplarData> list3) {
        if (list2.size() != list.size() + 1) {
            throw new IllegalArgumentException("invalid counts: size should be " + (list.size() + 1) + " instead of " + list2.size());
        }
        if (!ImmutableHistogramPointData.isStrictlyIncreasing(list)) {
            throw new IllegalArgumentException("invalid boundaries: " + list);
        }
        if (!list.isEmpty() && (list.get(0).isInfinite() || list.get(list.size() - 1).isInfinite())) {
            throw new IllegalArgumentException("invalid boundaries: contains explicit +/-Inf");
        }
        long l4 = 0L;
        for (long l5 : PrimitiveLongList.toArray(list2)) {
            l4 += l5;
        }
        return new AutoValue_ImmutableHistogramPointData(l2, l3, attributes, d2, l4, bl2, d3, bl3, d4, Collections.unmodifiableList(new ArrayList<Double>(list)), Collections.unmodifiableList(new ArrayList<Long>(list2)), list3);
    }

    ImmutableHistogramPointData() {
    }

    private static boolean isStrictlyIncreasing(List<Double> list) {
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            if (list.get(i2).compareTo(list.get(i2 + 1)) < 0) continue;
            return false;
        }
        return true;
    }
}

