/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;

abstract class FixedSizeExemplarReservoir<T extends ExemplarData>
implements ExemplarReservoir<T> {
    private final ReservoirCell[] storage;
    private final ReservoirCellSelector reservoirCellSelector;
    private final BiFunction<ReservoirCell, Attributes, T> mapAndResetCell;
    private volatile boolean hasMeasurements = false;

    FixedSizeExemplarReservoir(Clock clock, int n2, ReservoirCellSelector reservoirCellSelector, BiFunction<ReservoirCell, Attributes, T> biFunction) {
        this.storage = new ReservoirCell[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.storage[i2] = new ReservoirCell(clock);
        }
        this.reservoirCellSelector = reservoirCellSelector;
        this.mapAndResetCell = biFunction;
    }

    @Override
    public void offerLongMeasurement(long l2, Attributes attributes, Context context) {
        int n2 = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, l2, attributes, context);
        if (n2 != -1) {
            this.storage[n2].recordLongMeasurement(l2, attributes, context);
            this.hasMeasurements = true;
        }
    }

    @Override
    public void offerDoubleMeasurement(double d2, Attributes attributes, Context context) {
        int n2 = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, d2, attributes, context);
        if (n2 != -1) {
            this.storage[n2].recordDoubleMeasurement(d2, attributes, context);
            this.hasMeasurements = true;
        }
    }

    @Override
    public List<T> collectAndReset(Attributes attributes) {
        if (!this.hasMeasurements) {
            return Collections.emptyList();
        }
        ArrayList<ExemplarData> arrayList = new ArrayList<ExemplarData>();
        for (ReservoirCell reservoirCell : this.storage) {
            ExemplarData exemplarData = (ExemplarData)this.mapAndResetCell.apply(reservoirCell, attributes);
            if (exemplarData == null) continue;
            arrayList.add(exemplarData);
        }
        this.reservoirCellSelector.reset();
        this.hasMeasurements = false;
        return Collections.unmodifiableList(arrayList);
    }
}

