/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import java.util.List;
import javax.annotation.Nullable;

public final class SdkObservableMeasurement
implements ObservableDoubleMeasurement,
ObservableLongMeasurement {
    private static final e logger = e.a(SdkObservableMeasurement.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final InstrumentDescriptor instrumentDescriptor;
    private final List<AsynchronousMetricStorage<?, ?>> storages;
    @Nullable
    private volatile RegisteredReader activeReader;
    private volatile long startEpochNanos;
    private volatile long epochNanos;

    private SdkObservableMeasurement(InstrumentationScopeInfo instrumentationScopeInfo, InstrumentDescriptor instrumentDescriptor, List<AsynchronousMetricStorage<?, ?>> list) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.instrumentDescriptor = instrumentDescriptor;
        this.storages = list;
    }

    public static SdkObservableMeasurement create(InstrumentationScopeInfo instrumentationScopeInfo, InstrumentDescriptor instrumentDescriptor, List<AsynchronousMetricStorage<?, ?>> list) {
        return new SdkObservableMeasurement(instrumentationScopeInfo, instrumentDescriptor, list);
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    public void setActiveReader(RegisteredReader registeredReader, long l2, long l3) {
        this.activeReader = registeredReader;
        this.startEpochNanos = l2;
        this.epochNanos = l3;
    }

    public void unsetActiveReader() {
        this.activeReader = null;
    }

    InstrumentDescriptor getInstrumentDescriptor() {
        return this.instrumentDescriptor;
    }

    List<AsynchronousMetricStorage<?, ?>> getStorages() {
        return this.storages;
    }

    @Override
    public void record(long l2) {
        this.record(l2, Attributes.empty());
    }

    @Override
    public void record(long l2, Attributes attributes) {
        this.doRecord(Measurement.longMeasurement(this.startEpochNanos, this.epochNanos, l2, attributes));
    }

    @Override
    public void record(double d2) {
        this.record(d2, Attributes.empty());
    }

    @Override
    public void record(double d2, Attributes attributes) {
        this.doRecord(Measurement.doubleMeasurement(this.startEpochNanos, this.epochNanos, d2, attributes));
    }

    private void doRecord(Measurement measurement) {
        RegisteredReader registeredReader = this.activeReader;
        if (registeredReader == null) {
            this.throttlingLogger.log(e.a.f, "Measurement recorded for instrument " + this.instrumentDescriptor.getName() + " outside callback registered to instrument. Dropping measurement.");
            return;
        }
        for (AsynchronousMetricStorage<?, ?> asynchronousMetricStorage : this.storages) {
            if (!asynchronousMetricStorage.getRegisteredReader().equals(registeredReader)) continue;
            asynchronousMetricStorage.record(measurement);
        }
    }
}

